export declare class Color {
    r: number;
    g: number;
    b: number;
    a: number;
    constructor();
    constructor(color: string);
    constructor(color: Color.RGBA);
    constructor(r: number, g: number, b: number, a?: number);
    blend(start: Color, end: Color, weight: number): void;
    lighten(amount: number): void;
    darken(amount: number): void;
    set(rgba: Color.RGBA): this;
    set(r: number, g: number, b: number, a?: number): this;
    toHex(): string;
    toRGBA(): Color.RGBA;
    toHSLA(): Color.HSLA;
    toCSS(ignoreAlpha?: boolean): string;
    toGrey(): Color;
    toArray(): Color.RGBA;
    toString(): string;
}
export declare namespace Color {
    type RGBA = [number, number, number, number];
    type HSLA = [number, number, number, number];
    function fromArray(arr: RGBA): Color;
    function fromHex(color: string): Color;
    function fromRGBA(color: string): Color | null;
    function fromHSLA(color: string): Color | null;
    function fromString(color: string): Color | null;
    function makeGrey(g: number, a: number): Color;
    function rgba2hsla(rgba: RGBA): HSLA;
    function rgba2hsla(r: number, g: number, b: number, a?: number): HSLA;
    function hsla2rgba(hsla: HSLA): RGBA;
    function hsla2rgba(h: number, s: number, l: number, a?: number): RGBA;
    function random(ignoreAlpha?: boolean): Color;
    function randomHex(): string;
    function randomRGBA(ignoreAlpha?: boolean): string;
    function invert(rgba: RGBA, bw: boolean): RGBA;
    function invert(hex: string, bw: boolean): string;
    function lighten(rgba: RGBA, amt: number): RGBA;
    function lighten(hex: string, amt: number): string;
    function darken(rgba: RGBA, amt: number): RGBA;
    function darken(hex: string, amt: number): string;
}
export declare namespace Color {
    const named: {
        aliceblue: string;
        antiquewhite: string;
        aqua: string;
        aquamarine: string;
        azure: string;
        beige: string;
        bisque: string;
        black: string;
        blanchedalmond: string;
        blue: string;
        blueviolet: string;
        brown: string;
        burlywood: string;
        burntsienna: string;
        cadetblue: string;
        chartreuse: string;
        chocolate: string;
        coral: string;
        cornflowerblue: string;
        cornsilk: string;
        crimson: string;
        cyan: string;
        darkblue: string;
        darkcyan: string;
        darkgoldenrod: string;
        darkgray: string;
        darkgreen: string;
        darkgrey: string;
        darkkhaki: string;
        darkmagenta: string;
        darkolivegreen: string;
        darkorange: string;
        darkorchid: string;
        darkred: string;
        darksalmon: string;
        darkseagreen: string;
        darkslateblue: string;
        darkslategray: string;
        darkslategrey: string;
        darkturquoise: string;
        darkviolet: string;
        deeppink: string;
        deepskyblue: string;
        dimgray: string;
        dimgrey: string;
        dodgerblue: string;
        firebrick: string;
        floralwhite: string;
        forestgreen: string;
        fuchsia: string;
        gainsboro: string;
        ghostwhite: string;
        gold: string;
        goldenrod: string;
        gray: string;
        green: string;
        greenyellow: string;
        grey: string;
        honeydew: string;
        hotpink: string;
        indianred: string;
        indigo: string;
        ivory: string;
        khaki: string;
        lavender: string;
        lavenderblush: string;
        lawngreen: string;
        lemonchiffon: string;
        lightblue: string;
        lightcoral: string;
        lightcyan: string;
        lightgoldenrodyellow: string;
        lightgray: string;
        lightgreen: string;
        lightgrey: string;
        lightpink: string;
        lightsalmon: string;
        lightseagreen: string;
        lightskyblue: string;
        lightslategray: string;
        lightslategrey: string;
        lightsteelblue: string;
        lightyellow: string;
        lime: string;
        limegreen: string;
        linen: string;
        magenta: string;
        maroon: string;
        mediumaquamarine: string;
        mediumblue: string;
        mediumorchid: string;
        mediumpurple: string;
        mediumseagreen: string;
        mediumslateblue: string;
        mediumspringgreen: string;
        mediumturquoise: string;
        mediumvioletred: string;
        midnightblue: string;
        mintcream: string;
        mistyrose: string;
        moccasin: string;
        navajowhite: string;
        navy: string;
        oldlace: string;
        olive: string;
        olivedrab: string;
        orange: string;
        orangered: string;
        orchid: string;
        palegoldenrod: string;
        palegreen: string;
        paleturquoise: string;
        palevioletred: string;
        papayawhip: string;
        peachpuff: string;
        peru: string;
        pink: string;
        plum: string;
        powderblue: string;
        purple: string;
        rebeccapurple: string;
        red: string;
        rosybrown: string;
        royalblue: string;
        saddlebrown: string;
        salmon: string;
        sandybrown: string;
        seagreen: string;
        seashell: string;
        sienna: string;
        silver: string;
        skyblue: string;
        slateblue: string;
        slategray: string;
        slategrey: string;
        snow: string;
        springgreen: string;
        steelblue: string;
        tan: string;
        teal: string;
        thistle: string;
        tomato: string;
        turquoise: string;
        violet: string;
        wheat: string;
        white: string;
        whitesmoke: string;
        yellow: string;
        yellowgreen: string;
    };
}
