/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.task.operation.sink;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;
import org.apache.seatunnel.common.utils.SerializationUtils;
import org.apache.seatunnel.engine.server.SeaTunnelServer;
import org.apache.seatunnel.engine.server.TaskExecutionService;
import org.apache.seatunnel.engine.server.execution.TaskLocation;
import org.apache.seatunnel.engine.server.serializable.TaskDataSerializerHook;
import org.apache.seatunnel.engine.server.task.SinkAggregatedCommitterTask;
import org.apache.seatunnel.engine.server.task.operation.checkpoint.BarrierFlowOperation;
import org.apache.seatunnel.engine.server.task.record.Barrier;

public class SinkPrepareCommitOperation
extends BarrierFlowOperation {
    private byte[] commitInfos;

    public SinkPrepareCommitOperation(Barrier checkpointBarrier, TaskLocation taskLocation, byte[] commitInfos) {
        super(checkpointBarrier, taskLocation);
        this.commitInfos = commitInfos;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeByteArray(this.commitInfos);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.commitInfos = in.readByteArray();
    }

    @Override
    public String getServiceName() {
        return "st:impl:seaTunnelServer";
    }

    @Override
    public int getFactoryId() {
        return TaskDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getClassId() {
        return 8;
    }

    @Override
    public void run() throws Exception {
        TaskExecutionService taskExecutionService = ((SeaTunnelServer)this.getService()).getTaskExecutionService();
        SinkAggregatedCommitterTask committerTask = (SinkAggregatedCommitterTask)taskExecutionService.getTask(this.taskLocation);
        ClassLoader classLoader = taskExecutionService.getExecutionContext(this.taskLocation.getTaskGroupLocation()).getClassLoader();
        committerTask.receivedWriterCommitInfo(this.barrier.getId(), SerializationUtils.deserialize(this.commitInfos, classLoader));
        committerTask.triggerBarrier(this.barrier);
    }

    public SinkPrepareCommitOperation() {
    }
}

