/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.checkpoint;

import com.hazelcast.map.IMap;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.operationservice.impl.InvocationFuture;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.seatunnel.engine.checkpoint.storage.PipelineState;
import org.apache.seatunnel.engine.checkpoint.storage.api.CheckpointStorage;
import org.apache.seatunnel.engine.checkpoint.storage.api.CheckpointStorageFactory;
import org.apache.seatunnel.engine.checkpoint.storage.exception.CheckpointStorageException;
import org.apache.seatunnel.engine.common.config.server.CheckpointConfig;
import org.apache.seatunnel.engine.common.utils.ExceptionUtil;
import org.apache.seatunnel.engine.common.utils.FactoryUtil;
import org.apache.seatunnel.engine.common.utils.PassiveCompletableFuture;
import org.apache.seatunnel.engine.core.job.JobStatus;
import org.apache.seatunnel.engine.core.job.PipelineStatus;
import org.apache.seatunnel.engine.server.checkpoint.CheckpointCoordinator;
import org.apache.seatunnel.engine.server.checkpoint.CheckpointCoordinatorState;
import org.apache.seatunnel.engine.server.checkpoint.CheckpointPlan;
import org.apache.seatunnel.engine.server.checkpoint.CompletedCheckpoint;
import org.apache.seatunnel.engine.server.checkpoint.IMapCheckpointIDCounter;
import org.apache.seatunnel.engine.server.checkpoint.operation.TaskAcknowledgeOperation;
import org.apache.seatunnel.engine.server.checkpoint.operation.TaskReportStatusOperation;
import org.apache.seatunnel.engine.server.execution.TaskLocation;
import org.apache.seatunnel.engine.server.master.JobMaster;
import org.apache.seatunnel.engine.server.task.operation.TaskOperation;
import org.apache.seatunnel.engine.server.utils.NodeEngineUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckpointManager {
    private static final Logger log = LoggerFactory.getLogger(CheckpointManager.class);
    private final Long jobId;
    private final NodeEngine nodeEngine;
    private final Map<Integer, CheckpointCoordinator> coordinatorMap;
    private final CheckpointStorage checkpointStorage;
    private final JobMaster jobMaster;
    private final ExecutorService executorService;

    public CheckpointManager(long jobId, boolean isStartWithSavePoint, NodeEngine nodeEngine, JobMaster jobMaster, Map<Integer, CheckpointPlan> checkpointPlanMap, CheckpointConfig checkpointConfig, ExecutorService executorService) throws CheckpointStorageException {
        this.executorService = executorService;
        this.jobId = jobId;
        this.nodeEngine = nodeEngine;
        this.jobMaster = jobMaster;
        this.checkpointStorage = FactoryUtil.discoverFactory(Thread.currentThread().getContextClassLoader(), CheckpointStorageFactory.class, checkpointConfig.getStorage().getStorage()).create(checkpointConfig.getStorage().getStoragePluginConfig());
        IMap checkpointIdMap = nodeEngine.getHazelcastInstance().getMap(String.format("engine_checkpoint-id-%d", jobId));
        this.coordinatorMap = checkpointPlanMap.values().parallelStream().map(plan -> {
            IMapCheckpointIDCounter idCounter = new IMapCheckpointIDCounter(plan.getPipelineId(), checkpointIdMap);
            try {
                idCounter.start();
                PipelineState pipelineState = this.checkpointStorage.getLatestCheckpointByJobIdAndPipelineId(String.valueOf(jobId), String.valueOf(plan.getPipelineId()));
                if (pipelineState != null) {
                    long checkpointId = pipelineState.getCheckpointId();
                    idCounter.setCount(checkpointId + 1L);
                    log.info("pipeline({}) start with savePoint on checkPointId({})", (Object)plan.getPipelineId(), (Object)checkpointId);
                }
                return new CheckpointCoordinator(this, this.checkpointStorage, checkpointConfig, jobId, (CheckpointPlan)plan, idCounter, pipelineState, executorService);
            }
            catch (Exception e) {
                ExceptionUtil.sneakyThrow(e);
                throw new RuntimeException("Never throw here.");
            }
        }).collect(Collectors.toMap(CheckpointCoordinator::getPipelineId, Function.identity()));
    }

    public PassiveCompletableFuture<CompletedCheckpoint>[] triggerSavePoints() {
        return (PassiveCompletableFuture[])this.coordinatorMap.values().parallelStream().map(CheckpointCoordinator::startSavepoint).toArray(PassiveCompletableFuture[]::new);
    }

    public PassiveCompletableFuture<CompletedCheckpoint> triggerSavepoint(int pipelineId) {
        return this.getCheckpointCoordinator(pipelineId).startSavepoint();
    }

    public void reportedPipelineRunning(int pipelineId, boolean alreadyStarted) {
        this.getCheckpointCoordinator(pipelineId).restoreCoordinator(alreadyStarted);
    }

    protected void handleCheckpointError(int pipelineId) {
        this.jobMaster.handleCheckpointError(pipelineId);
    }

    private CheckpointCoordinator getCheckpointCoordinator(TaskLocation taskLocation) {
        return this.getCheckpointCoordinator(taskLocation.getPipelineId());
    }

    private CheckpointCoordinator getCheckpointCoordinator(int pipelineId) {
        CheckpointCoordinator coordinator = this.coordinatorMap.get(pipelineId);
        if (coordinator == null) {
            throw new RuntimeException(String.format("The checkpoint coordinator(%s) don't exist", pipelineId));
        }
        return coordinator;
    }

    public void reportedTask(TaskReportStatusOperation reportStatusOperation) {
        log.debug("reported task({}) status {}", (Object)reportStatusOperation.getLocation().getTaskID(), (Object)reportStatusOperation.getStatus());
        this.getCheckpointCoordinator(reportStatusOperation.getLocation()).reportedTask(reportStatusOperation);
    }

    public void readyToClose(TaskLocation taskLocation) {
        this.getCheckpointCoordinator(taskLocation).readyToClose(taskLocation);
    }

    public CompletableFuture<Void> listenPipeline(int pipelineId, PipelineStatus pipelineStatus) {
        return this.getCheckpointCoordinator(pipelineId).getCheckpointIdCounter().shutdown(pipelineStatus);
    }

    public CompletableFuture<Void> shutdown(JobStatus jobStatus) {
        if (!(jobStatus != JobStatus.FINISHED && jobStatus != JobStatus.CANCELED || this.isSavePointEnd())) {
            this.checkpointStorage.deleteCheckpoint(this.jobId + "");
        }
        return CompletableFuture.completedFuture(null);
    }

    public boolean isCompletedPipeline(int pipelineId) {
        return this.getCheckpointCoordinator(pipelineId).isCompleted();
    }

    public void acknowledgeTask(TaskAcknowledgeOperation ackOperation) {
        log.debug("checkpoint manager received ack {}", (Object)ackOperation.getTaskLocation());
        CheckpointCoordinator coordinator = this.getCheckpointCoordinator(ackOperation.getTaskLocation());
        if (coordinator.isCompleted()) {
            log.info("The checkpoint coordinator({}) is completed", (Object)ackOperation.getTaskLocation().getPipelineId());
            return;
        }
        coordinator.acknowledgeTask(ackOperation);
    }

    public boolean isSavePointEnd() {
        return this.coordinatorMap.values().stream().map(CheckpointCoordinator::isEndOfSavePoint).reduce((v1, v2) -> v1 != false && v2 != false).orElse(false);
    }

    protected InvocationFuture<?> sendOperationToMemberNode(TaskOperation operation) {
        return NodeEngineUtil.sendOperationToMemberNode(this.nodeEngine, operation, this.jobMaster.queryTaskGroupAddress(operation.getTaskLocation().getTaskGroupLocation().getTaskGroupId()));
    }

    public PassiveCompletableFuture<CheckpointCoordinatorState> cancelCheckpoint(int pipelineId) {
        return this.getCheckpointCoordinator(pipelineId).cancelCheckpoint();
    }

    public PassiveCompletableFuture<CheckpointCoordinatorState> waitCheckpointCoordinatorComplete(int pipelineId) {
        return this.getCheckpointCoordinator(pipelineId).waitCheckpointCoordinatorComplete();
    }
}

