/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff;

import io.protostuff.Output;
import io.protostuff.StringSerializer;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public final class ByteString {
    private final byte[] bytes;
    public static final String EMPTY_STRING = "";
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final ByteString EMPTY = new ByteString(EMPTY_BYTE_ARRAY);
    private volatile int hash = 0;

    static ByteString wrap(byte[] bytes) {
        return new ByteString(bytes);
    }

    byte[] getBytes() {
        return this.bytes;
    }

    public static void writeTo(OutputStream out, ByteString bs) throws IOException {
        out.write(bs.bytes);
    }

    public static void writeTo(DataOutput out, ByteString bs) throws IOException {
        out.write(bs.bytes);
    }

    public static void writeTo(Output output, ByteString bs, int fieldNumber, boolean repeated) throws IOException {
        output.writeByteArray(fieldNumber, bs.bytes, repeated);
    }

    public String toString() {
        return String.format("<ByteString@%s size=%d>", Integer.toHexString(System.identityHashCode(this)), this.size());
    }

    private ByteString(byte[] bytes) {
        this.bytes = bytes;
    }

    public byte byteAt(int index) {
        return this.bytes[index];
    }

    public int size() {
        return this.bytes.length;
    }

    public boolean isEmpty() {
        return this.bytes.length == 0;
    }

    public static ByteString copyFrom(byte[] bytes, int offset, int size2) {
        byte[] copy = new byte[size2];
        System.arraycopy(bytes, offset, copy, 0, size2);
        return new ByteString(copy);
    }

    public static ByteString copyFrom(byte[] bytes) {
        return ByteString.copyFrom(bytes, 0, bytes.length);
    }

    public static ByteString copyFrom(String text, String charsetName) {
        try {
            return new ByteString(text.getBytes(charsetName));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(charsetName + " not supported?", e);
        }
    }

    public static ByteString copyFromUtf8(String text) {
        return new ByteString(StringSerializer.STRING.ser(text));
    }

    public void copyTo(byte[] target, int offset) {
        System.arraycopy(this.bytes, 0, target, offset, this.bytes.length);
    }

    public void copyTo(byte[] target, int sourceOffset, int targetOffset, int size2) {
        System.arraycopy(this.bytes, sourceOffset, target, targetOffset, size2);
    }

    public byte[] toByteArray() {
        int size2 = this.bytes.length;
        byte[] copy = new byte[size2];
        System.arraycopy(this.bytes, 0, copy, 0, size2);
        return copy;
    }

    public ByteBuffer asReadOnlyByteBuffer() {
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.bytes);
        return byteBuffer.asReadOnlyBuffer();
    }

    public String toStringUtf8() {
        return StringSerializer.STRING.deser(this.bytes);
    }

    public boolean equals(Object o) {
        return o == this || o instanceof ByteString && ByteString.equals(this, (ByteString)o, false);
    }

    public static boolean equals(ByteString bs, ByteString other, boolean checkHash) {
        int size2 = bs.bytes.length;
        if (size2 != other.bytes.length) {
            return false;
        }
        if (checkHash) {
            int h1 = bs.hash;
            int h2 = other.hash;
            if (h1 != 0 && h2 != 0 && h1 != h2) {
                return false;
            }
        }
        byte[] thisBytes = bs.bytes;
        byte[] otherBytes = other.bytes;
        for (int i = 0; i < size2; ++i) {
            if (thisBytes[i] == otherBytes[i]) continue;
            return false;
        }
        return true;
    }

    public boolean equals(byte[] data) {
        return this.equals(data, 0, data.length);
    }

    public boolean equals(byte[] data, int offset, int len) {
        byte[] bytes = this.bytes;
        if (len != bytes.length) {
            return false;
        }
        int i = 0;
        while (i < len) {
            if (bytes[i++] == data[offset++]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h2 = this.hash;
        if (h2 == 0) {
            int size2;
            byte[] thisBytes = this.bytes;
            h2 = size2 = this.bytes.length;
            for (int i = 0; i < size2; ++i) {
                h2 = h2 * 31 + thisBytes[i];
            }
            if (h2 == 0) {
                h2 = 1;
            }
            this.hash = h2;
        }
        return h2;
    }

    public static String stringDefaultValue(String bytes) {
        try {
            return new String(bytes.getBytes("ISO-8859-1"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Java VM does not support a standard character set.", e);
        }
    }

    public static ByteString bytesDefaultValue(String bytes) {
        return new ByteString(ByteString.byteArrayDefaultValue(bytes));
    }

    public static byte[] byteArrayDefaultValue(String bytes) {
        try {
            return bytes.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Java VM does not support a standard character set.", e);
        }
    }
}

