/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.management.dto;

import com.hazelcast.internal.json.JsonObject;
import com.hazelcast.internal.util.JsonUtil;
import com.hazelcast.json.internal.JsonSerializable;

public final class ClientBwListEntryDTO
implements JsonSerializable {
    public Type type;
    public String value;

    public ClientBwListEntryDTO() {
    }

    public ClientBwListEntryDTO(Type type, String value) {
        this.type = type;
        this.value = value;
    }

    public Type getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public JsonObject toJson() {
        JsonObject root = new JsonObject();
        root.add("type", this.type.toString());
        root.add("value", this.value);
        return root;
    }

    @Override
    public void fromJson(JsonObject json) {
        String typeStr = JsonUtil.getString(json, "type");
        this.type = Type.valueOf(typeStr);
        this.value = JsonUtil.getString(json, "value");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientBwListEntryDTO that = (ClientBwListEntryDTO)o;
        if (this.type != that.type) {
            return false;
        }
        return this.value.equals(that.value);
    }

    public int hashCode() {
        int result2 = this.type.hashCode();
        result2 = 31 * result2 + this.value.hashCode();
        return result2;
    }

    public static enum Type {
        IP_ADDRESS(0),
        INSTANCE_NAME(1),
        LABEL(2);

        private final int id;

        private Type(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public static Type getById(int id) {
            for (Type type : Type.values()) {
                if (type.id != id) continue;
                return type;
            }
            return null;
        }
    }
}

