/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.internal.config.ConfigDataSerializerHook;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.wan.WanConsumer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

public class WanConsumerConfig
implements IdentifiedDataSerializable {
    public static final boolean DEFAULT_PERSIST_WAN_REPLICATED_DATA = false;
    private boolean persistWanReplicatedData = false;
    private String className;
    private WanConsumer implementation;
    private Map<String, Comparable> properties = new HashMap<String, Comparable>();

    public Map<String, Comparable> getProperties() {
        return this.properties;
    }

    public WanConsumerConfig setProperties(Map<String, Comparable> properties) {
        this.properties = properties;
        return this;
    }

    public String getClassName() {
        return this.className;
    }

    public WanConsumerConfig setClassName(@Nonnull String className) {
        this.className = Preconditions.checkNotNull(className, "Wan consumer class name must contain text");
        this.implementation = null;
        return this;
    }

    public WanConsumer getImplementation() {
        return this.implementation;
    }

    public WanConsumerConfig setImplementation(@Nonnull WanConsumer implementation) {
        this.implementation = Preconditions.checkNotNull(implementation, "Wan consumer cannot be null!");
        this.className = null;
        return this;
    }

    public boolean isPersistWanReplicatedData() {
        return this.persistWanReplicatedData;
    }

    public WanConsumerConfig setPersistWanReplicatedData(boolean persistWanReplicatedData) {
        this.persistWanReplicatedData = persistWanReplicatedData;
        return this;
    }

    public String toString() {
        return "WanConsumerConfig{properties=" + this.properties + ", className='" + this.className + '\'' + ", implementation=" + this.implementation + ", persistWanReplicatedData=" + this.persistWanReplicatedData + '}';
    }

    @Override
    public int getFactoryId() {
        return ConfigDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 3;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        int size2 = this.properties.size();
        out.writeInt(size2);
        for (Map.Entry<String, Comparable> entry : this.properties.entrySet()) {
            out.writeString(entry.getKey());
            out.writeObject(entry.getValue());
        }
        out.writeString(this.className);
        out.writeObject(this.implementation);
        out.writeBoolean(this.persistWanReplicatedData);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        int size2 = in.readInt();
        for (int i = 0; i < size2; ++i) {
            this.properties.put(in.readString(), (Comparable)in.readObject());
        }
        this.className = in.readString();
        this.implementation = (WanConsumer)in.readObject();
        this.persistWanReplicatedData = in.readBoolean();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WanConsumerConfig that = (WanConsumerConfig)o;
        return this.persistWanReplicatedData == that.persistWanReplicatedData && Objects.equals(this.className, that.className) && Objects.equals(this.implementation, that.implementation) && Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        return Objects.hash(this.persistWanReplicatedData, this.className, this.implementation, this.properties);
    }
}

