/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform;

import com.google.auto.service.AutoService;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.Options;
import org.apache.seatunnel.api.table.type.RowKind;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.transform.SeaTunnelTransform;
import org.apache.seatunnel.common.exception.CommonErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelRuntimeException;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.transform.common.FilterRowTransform;

@AutoService(value={SeaTunnelTransform.class})
public class FilterRowKindTransform
extends FilterRowTransform {
    public static final Option<List<RowKind>> INCLUDE_KINDS = Options.key((String)"include_kinds").listType(RowKind.class).noDefaultValue().withDescription("the row kinds to include");
    public static final Option<List<RowKind>> EXCLUDE_KINDS = Options.key((String)"exclude_kinds").listType(RowKind.class).noDefaultValue().withDescription("the row kinds to exclude");
    private Set<RowKind> includeKinds = Collections.emptySet();
    private Set<RowKind> excludeKinds = Collections.emptySet();

    public String getPluginName() {
        return "FilterRowKind";
    }

    @Override
    protected void setConfig(Config pluginConfig) {
        if (pluginConfig.hasPath(INCLUDE_KINDS.key())) {
            this.includeKinds = new HashSet<RowKind>(pluginConfig.getEnumList(RowKind.class, INCLUDE_KINDS.key()));
        }
        if (pluginConfig.hasPath(EXCLUDE_KINDS.key())) {
            this.excludeKinds = new HashSet<RowKind>(pluginConfig.getEnumList(RowKind.class, EXCLUDE_KINDS.key()));
        }
        if (this.includeKinds.isEmpty() && this.excludeKinds.isEmpty() || !this.includeKinds.isEmpty() && !this.excludeKinds.isEmpty()) {
            throw new SeaTunnelRuntimeException((SeaTunnelErrorCode)CommonErrorCode.ILLEGAL_ARGUMENT, String.format("These options(%s,%s) are mutually exclusive, allowing only one set of options to be configured.", INCLUDE_KINDS.key(), EXCLUDE_KINDS.key()));
        }
    }

    @Override
    protected SeaTunnelRow transformRow(SeaTunnelRow inputRow) {
        if (!this.excludeKinds.isEmpty()) {
            return this.excludeKinds.contains(inputRow.getRowKind()) ? null : inputRow;
        }
        if (!this.includeKinds.isEmpty()) {
            return this.includeKinds.contains(inputRow.getRowKind()) ? inputRow : null;
        }
        throw new SeaTunnelRuntimeException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_OPERATION, "Transform config error! Either excludeKinds or includeKinds must be configured");
    }

    public String toString() {
        return "FilterRowKindTransform(includeKinds=" + this.includeKinds + ", excludeKinds=" + this.excludeKinds + ")";
    }
}

