/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.seatunnel.connectors.seatunnel.fake.config;

import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.Options;

@SuppressWarnings("checkstyle:MagicNumber")
public class FakeOption {

    public static final Option<Integer> ROW_NUM = Options.key("row.num").intType().defaultValue(5)
        .withDescription("The total number of data generated per degree of parallelism");
    public static final Option<Integer> SPLIT_NUM = Options.key("split.num").intType().defaultValue(1)
        .withDescription("The number of splits generated by the enumerator for each degree of parallelism");
    public static final Option<Integer> SPLIT_READ_INTERVAL = Options.key("split.read-interval").intType().defaultValue(1)
        .withDescription("The interval(mills) between two split reads in a reader");
    public static final Option<Integer> MAP_SIZE = Options.key("map.size").intType().defaultValue(5)
        .withDescription("The size of map type that connector generated");
    public static final Option<Integer> ARRAY_SIZE = Options.key("array.size").intType().defaultValue(5)
        .withDescription("The size of array type that connector generated");
    public static final Option<Integer> BYTES_LENGTH = Options.key("bytes.length").intType().defaultValue(5)
        .withDescription("The length of bytes type that connector generated");
    public static final Option<Integer> STRING_LENGTH = Options.key("string.length").intType().defaultValue(5)
        .withDescription("The length of string type that connector generated");

}
