/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.console.sink;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.sink.SinkWriter;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.utils.JsonUtils;
import org.apache.seatunnel.connectors.seatunnel.common.sink.AbstractSinkWriter;

public class ConsoleSinkWriter
extends AbstractSinkWriter<SeaTunnelRow, Void> {
    private final SeaTunnelRowType seaTunnelRowType;
    public static final AtomicLong CNT = new AtomicLong(0L);
    public SinkWriter.Context context;

    public ConsoleSinkWriter(SeaTunnelRowType seaTunnelRowType, SinkWriter.Context context) {
        this.seaTunnelRowType = seaTunnelRowType;
        this.context = context;
        System.out.printf("fields : %s%n", StringUtils.join((Object[])seaTunnelRowType.getFieldNames(), (String)", "));
        System.out.printf("types : %s%n", StringUtils.join((Object[])seaTunnelRowType.getFieldTypes(), (String)", "));
    }

    public void write(SeaTunnelRow element) {
        Object[] arr = new String[this.seaTunnelRowType.getTotalFields()];
        SeaTunnelDataType[] fieldTypes = this.seaTunnelRowType.getFieldTypes();
        Object[] fields = element.getFields();
        for (int i = 0; i < fieldTypes.length; ++i) {
            arr[i] = this.fieldToString(fieldTypes[i], fields[i]);
        }
        System.out.format("subtaskIndex=%s: row=%s : %s%n", this.context.getIndexOfSubtask(), CNT.incrementAndGet(), StringUtils.join((Object[])arr, (String)", "));
    }

    public void close() {
    }

    private String fieldToString(SeaTunnelDataType<?> type, Object value) {
        if (value == null) {
            return null;
        }
        switch (type.getSqlType()) {
            case ARRAY: 
            case BYTES: {
                ArrayList<String> arrayData = new ArrayList<String>();
                for (int i = 0; i < Array.getLength(value); ++i) {
                    arrayData.add(String.valueOf(Array.get(value, i)));
                }
                return ((Object)arrayData).toString();
            }
            case MAP: {
                return JsonUtils.toJsonString((Object)value);
            }
            case ROW: {
                ArrayList<String> rowData = new ArrayList<String>();
                SeaTunnelRowType rowType = (SeaTunnelRowType)type;
                for (int i = 0; i < rowType.getTotalFields(); ++i) {
                    rowData.add(this.fieldToString(rowType.getFieldTypes()[i], ((SeaTunnelRow)value).getField(i)));
                }
                return ((Object)rowData).toString();
            }
        }
        return String.valueOf(value);
    }
}

