/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.task.operation;

import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;
import lombok.NonNull;
import org.apache.seatunnel.engine.server.SeaTunnelServer;
import org.apache.seatunnel.engine.server.resourcemanager.resource.SlotProfile;
import org.apache.seatunnel.engine.server.serializable.TaskDataSerializerHook;

public class DeployTaskOperation
extends Operation
implements IdentifiedDataSerializable {
    private Data taskImmutableInformation;
    private SlotProfile slotProfile;

    public DeployTaskOperation() {
    }

    public DeployTaskOperation(@NonNull SlotProfile slotProfile, @NonNull Data taskImmutableInformation) {
        if (slotProfile == null) {
            throw new NullPointerException("slotProfile is marked @NonNull but is null");
        }
        if (taskImmutableInformation == null) {
            throw new NullPointerException("taskImmutableInformation is marked @NonNull but is null");
        }
        this.taskImmutableInformation = taskImmutableInformation;
        this.slotProfile = slotProfile;
    }

    @Override
    public void run() throws Exception {
        SeaTunnelServer server = (SeaTunnelServer)this.getService();
        server.getSlotService().getSlotContext(this.slotProfile).getTaskExecutionService().deployTask(this.taskImmutableInformation);
    }

    @Override
    public int getFactoryId() {
        return TaskDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getClassId() {
        return 12;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        IOUtil.writeData(out, this.taskImmutableInformation);
        out.writeObject(this.slotProfile);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.taskImmutableInformation = IOUtil.readData(in);
        this.slotProfile = (SlotProfile)in.readObject();
    }
}

