/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.serializable;

import com.hazelcast.internal.serialization.DataSerializerHook;
import com.hazelcast.internal.serialization.impl.FactoryIdHelper;
import com.hazelcast.nio.serialization.DataSerializableFactory;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import org.apache.seatunnel.engine.server.resourcemanager.opeartion.ReleaseSlotOperation;
import org.apache.seatunnel.engine.server.resourcemanager.opeartion.RequestSlotOperation;
import org.apache.seatunnel.engine.server.resourcemanager.opeartion.ResetResourceOperation;
import org.apache.seatunnel.engine.server.resourcemanager.opeartion.WorkerHeartbeatOperation;
import org.apache.seatunnel.engine.server.resourcemanager.resource.SlotProfile;
import org.apache.seatunnel.engine.server.resourcemanager.worker.WorkerProfile;
import org.apache.seatunnel.engine.server.service.slot.SlotAndWorkerProfile;

public class ResourceDataSerializerHook
implements DataSerializerHook {
    public static final int WORKER_HEARTBEAT_TYPE = 1;
    public static final int REQUEST_SLOT_TYPE = 2;
    public static final int RELEASE_SLOT_TYPE = 3;
    public static final int RESET_RESOURCE_TYPE = 4;
    public static final int WORKER_PROFILE_TYPE = 5;
    public static final int SLOT_PROFILE_TYPE = 6;
    public static final int SLOT_AND_WORKER_PROFILE = 7;
    public static final int FACTORY_ID = FactoryIdHelper.getFactoryId("hazelcast.serialization.ds.seatunnel.engine.resource", -30005);

    @Override
    public int getFactoryId() {
        return FACTORY_ID;
    }

    @Override
    public DataSerializableFactory createFactory() {
        return new Factory();
    }

    private static class Factory
    implements DataSerializableFactory {
        private Factory() {
        }

        @Override
        public IdentifiedDataSerializable create(int typeId) {
            switch (typeId) {
                case 1: {
                    return new WorkerHeartbeatOperation();
                }
                case 2: {
                    return new RequestSlotOperation();
                }
                case 3: {
                    return new ReleaseSlotOperation();
                }
                case 4: {
                    return new ResetResourceOperation();
                }
                case 5: {
                    return new WorkerProfile();
                }
                case 6: {
                    return new SlotProfile();
                }
                case 7: {
                    return new SlotAndWorkerProfile();
                }
            }
            throw new IllegalArgumentException("Unknown type id " + typeId);
        }
    }
}

