/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.master;

import com.google.common.collect.Lists;
import com.hazelcast.cluster.Address;
import com.hazelcast.flakeidgen.FlakeIdGenerator;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.jet.datamodel.Tuple2;
import com.hazelcast.jet.impl.execution.init.CustomClassLoadedObject;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.map.IMap;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.impl.InvocationFuture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.seatunnel.api.common.metrics.RawJobMetrics;
import org.apache.seatunnel.api.env.EnvCommonOptions;
import org.apache.seatunnel.common.utils.ExceptionUtils;
import org.apache.seatunnel.common.utils.RetryUtils;
import org.apache.seatunnel.common.utils.SeaTunnelException;
import org.apache.seatunnel.engine.common.config.EngineConfig;
import org.apache.seatunnel.engine.common.config.server.CheckpointConfig;
import org.apache.seatunnel.engine.common.config.server.CheckpointStorageConfig;
import org.apache.seatunnel.engine.common.exception.SeaTunnelEngineException;
import org.apache.seatunnel.engine.common.loader.SeatunnelChildFirstClassLoader;
import org.apache.seatunnel.engine.common.utils.PassiveCompletableFuture;
import org.apache.seatunnel.engine.core.dag.actions.ActionUtils;
import org.apache.seatunnel.engine.core.dag.logical.LogicalDag;
import org.apache.seatunnel.engine.core.dag.logical.LogicalVertex;
import org.apache.seatunnel.engine.core.job.Edge;
import org.apache.seatunnel.engine.core.job.JobDAGInfo;
import org.apache.seatunnel.engine.core.job.JobImmutableInformation;
import org.apache.seatunnel.engine.core.job.JobStatus;
import org.apache.seatunnel.engine.core.job.VertexInfo;
import org.apache.seatunnel.engine.server.checkpoint.CheckpointManager;
import org.apache.seatunnel.engine.server.checkpoint.CheckpointPlan;
import org.apache.seatunnel.engine.server.dag.execution.ExecutionPlanGenerator;
import org.apache.seatunnel.engine.server.dag.execution.Pipeline;
import org.apache.seatunnel.engine.server.dag.physical.PhysicalPlan;
import org.apache.seatunnel.engine.server.dag.physical.PipelineLocation;
import org.apache.seatunnel.engine.server.dag.physical.PlanUtils;
import org.apache.seatunnel.engine.server.dag.physical.SubPlan;
import org.apache.seatunnel.engine.server.execution.TaskExecutionState;
import org.apache.seatunnel.engine.server.execution.TaskGroupLocation;
import org.apache.seatunnel.engine.server.resourcemanager.ResourceManager;
import org.apache.seatunnel.engine.server.resourcemanager.resource.SlotProfile;
import org.apache.seatunnel.engine.server.scheduler.JobScheduler;
import org.apache.seatunnel.engine.server.scheduler.PipelineBaseScheduler;
import org.apache.seatunnel.engine.server.task.operation.CleanTaskGroupContextOperation;
import org.apache.seatunnel.engine.server.task.operation.GetTaskGroupMetricsOperation;

public class JobMaster
extends Thread {
    private static final ILogger LOGGER = Logger.getLogger(JobMaster.class);
    private PhysicalPlan physicalPlan;
    private final Data jobImmutableInformationData;
    private final NodeEngine nodeEngine;
    private final ExecutorService executorService;
    private final FlakeIdGenerator flakeIdGenerator;
    private final ResourceManager resourceManager;
    private CheckpointManager checkpointManager;
    private CompletableFuture<JobStatus> jobMasterCompleteFuture;
    private JobImmutableInformation jobImmutableInformation;
    private JobScheduler jobScheduler;
    private LogicalDag logicalDag;
    private JobDAGInfo jobDAGInfo;
    private final IMap<PipelineLocation, Map<TaskGroupLocation, SlotProfile>> ownedSlotProfilesIMap;
    private final IMap<Object, Object> runningJobStateIMap;
    private final IMap<Object, Object> runningJobStateTimestampsIMap;
    private CompletableFuture<Void> scheduleFuture;
    private volatile boolean restore = false;
    private boolean isPhyicalDAGInfo = true;
    private final EngineConfig engineConfig;
    private boolean isRunning = true;

    public JobMaster(@NonNull Data jobImmutableInformationData, @NonNull NodeEngine nodeEngine, @NonNull ExecutorService executorService, @NonNull ResourceManager resourceManager, @NonNull IMap runningJobStateIMap, @NonNull IMap runningJobStateTimestampsIMap, @NonNull IMap ownedSlotProfilesIMap, EngineConfig engineConfig) {
        if (jobImmutableInformationData == null) {
            throw new NullPointerException("jobImmutableInformationData is marked @NonNull but is null");
        }
        if (nodeEngine == null) {
            throw new NullPointerException("nodeEngine is marked @NonNull but is null");
        }
        if (executorService == null) {
            throw new NullPointerException("executorService is marked @NonNull but is null");
        }
        if (resourceManager == null) {
            throw new NullPointerException("resourceManager is marked @NonNull but is null");
        }
        if (runningJobStateIMap == null) {
            throw new NullPointerException("runningJobStateIMap is marked @NonNull but is null");
        }
        if (runningJobStateTimestampsIMap == null) {
            throw new NullPointerException("runningJobStateTimestampsIMap is marked @NonNull but is null");
        }
        if (ownedSlotProfilesIMap == null) {
            throw new NullPointerException("ownedSlotProfilesIMap is marked @NonNull but is null");
        }
        this.jobImmutableInformationData = jobImmutableInformationData;
        this.nodeEngine = nodeEngine;
        this.executorService = executorService;
        this.flakeIdGenerator = this.nodeEngine.getHazelcastInstance().getFlakeIdGenerator("SeaTunnelIdGenerator");
        this.ownedSlotProfilesIMap = ownedSlotProfilesIMap;
        this.resourceManager = resourceManager;
        this.runningJobStateIMap = runningJobStateIMap;
        this.runningJobStateTimestampsIMap = runningJobStateTimestampsIMap;
        this.engineConfig = engineConfig;
    }

    public void init(long initializationTimestamp) throws Exception {
        this.jobImmutableInformation = (JobImmutableInformation)this.nodeEngine.getSerializationService().toObject(this.jobImmutableInformationData);
        LOGGER.info(String.format("Init JobMaster for Job %s (%s) ", this.jobImmutableInformation.getJobConfig().getName(), this.jobImmutableInformation.getJobId()));
        LOGGER.info(String.format("Job %s (%s) needed jar urls %s", this.jobImmutableInformation.getJobConfig().getName(), this.jobImmutableInformation.getJobId(), this.jobImmutableInformation.getPluginJarsUrls()));
        this.logicalDag = !CollectionUtils.isEmpty(this.jobImmutableInformation.getPluginJarsUrls()) ? (LogicalDag)CustomClassLoadedObject.deserializeWithCustomClassLoader(this.nodeEngine.getSerializationService(), new SeatunnelChildFirstClassLoader(this.jobImmutableInformation.getPluginJarsUrls()), this.jobImmutableInformation.getLogicalDag()) : (LogicalDag)this.nodeEngine.getSerializationService().toObject(this.jobImmutableInformation.getLogicalDag());
        CheckpointConfig checkpointConfig = this.mergeEnvAndEngineConfig(this.engineConfig.getCheckpointConfig(), this.jobImmutableInformation.getJobConfig().getEnvOptions());
        Tuple2<PhysicalPlan, Map<Integer, CheckpointPlan>> planTuple = PlanUtils.fromLogicalDAG(this.logicalDag, this.nodeEngine, this.jobImmutableInformation, initializationTimestamp, this.executorService, this.flakeIdGenerator, this.runningJobStateIMap, this.runningJobStateTimestampsIMap);
        this.physicalPlan = planTuple.f0();
        this.physicalPlan.setJobMaster(this);
        this.checkpointManager = new CheckpointManager(this.jobImmutableInformation.getJobId(), this.nodeEngine, this, planTuple.f1(), checkpointConfig);
        this.initStateFuture();
    }

    private CheckpointConfig mergeEnvAndEngineConfig(CheckpointConfig engine, Map<String, Object> env) {
        CheckpointConfig checkpointConfig = new CheckpointConfig();
        if (env.containsKey(EnvCommonOptions.CHECKPOINT_INTERVAL.key())) {
            checkpointConfig.setCheckpointInterval(((Integer)env.get(EnvCommonOptions.CHECKPOINT_INTERVAL.key())).intValue());
        }
        checkpointConfig.setCheckpointTimeout(engine.getCheckpointTimeout());
        checkpointConfig.setTolerableFailureCheckpoints(engine.getTolerableFailureCheckpoints());
        checkpointConfig.setMaxConcurrentCheckpoints(engine.getMaxConcurrentCheckpoints());
        CheckpointStorageConfig storageConfig = new CheckpointStorageConfig();
        storageConfig.setMaxRetainedCheckpoints(engine.getStorage().getMaxRetainedCheckpoints());
        storageConfig.setStorage(engine.getStorage().getStorage());
        storageConfig.setStoragePluginConfig(engine.getStorage().getStoragePluginConfig());
        checkpointConfig.setStorage(storageConfig);
        return checkpointConfig;
    }

    public void initStateFuture() {
        this.jobMasterCompleteFuture = new CompletableFuture();
        PassiveCompletableFuture<JobStatus> jobStatusFuture = this.physicalPlan.initStateFuture();
        jobStatusFuture.whenComplete((BiConsumer)ExceptionUtil.withTryCatch(LOGGER, (v, t) -> {
            if (JobStatus.FAILING.equals(v)) {
                this.cleanJob();
                this.physicalPlan.updateJobState(JobStatus.FAILING, JobStatus.FAILED);
            }
            this.jobMasterCompleteFuture.complete(this.physicalPlan.getJobStatus());
        }));
    }

    @Override
    public void run() {
        try {
            if (!this.restore) {
                this.jobScheduler = new PipelineBaseScheduler(this.physicalPlan, this);
                this.scheduleFuture = CompletableFuture.runAsync(() -> this.jobScheduler.startScheduling(), this.executorService);
                LOGGER.info(String.format("Job %s waiting for scheduler finished", this.physicalPlan.getJobFullName()));
                this.scheduleFuture.join();
                LOGGER.info(String.format("%s scheduler finished", this.physicalPlan.getJobFullName()));
            }
        }
        catch (Throwable e) {
            LOGGER.severe(String.format("Job %s (%s) run error with: %s", this.physicalPlan.getJobImmutableInformation().getJobConfig().getName(), this.physicalPlan.getJobImmutableInformation().getJobId(), ExceptionUtils.getMessage(e)));
            this.cancelJob();
        }
        finally {
            this.jobMasterCompleteFuture.join();
        }
    }

    public void handleCheckpointError(long pipelineId, Throwable e) {
        this.physicalPlan.getPipelineList().forEach(pipeline -> {
            if ((long)pipeline.getPipelineLocation().getPipelineId() == pipelineId) {
                LOGGER.warning(String.format("%s checkpoint have error, cancel the pipeline", pipeline.getPipelineFullName()), e);
                pipeline.cancelPipeline();
            }
        });
    }

    public JobDAGInfo getJobDAGInfo() {
        if (this.jobDAGInfo != null) {
            return this.jobDAGInfo;
        }
        List<Pipeline> pipelines = new ExecutionPlanGenerator(this.logicalDag, this.getJobImmutableInformation()).generate().getPipelines();
        if (this.isPhyicalDAGInfo) {
            HashMap<Integer, List<Edge>> pipelineWithEdges = new HashMap<Integer, List<Edge>>();
            HashMap<Long, VertexInfo> vertexInfoMap = new HashMap<Long, VertexInfo>();
            pipelines.forEach(pipeline -> {
                pipelineWithEdges.put(pipeline.getId(), pipeline.getEdges().stream().map(e -> new Edge(e.getLeftVertexId(), e.getRightVertexId())).collect(Collectors.toList()));
                pipeline.getVertexes().forEach((id, vertex) -> vertexInfoMap.put((Long)id, new VertexInfo(vertex.getVertexId(), ActionUtils.getActionType(vertex.getAction()), vertex.getAction().getName())));
            });
            this.jobDAGInfo = new JobDAGInfo(this.jobImmutableInformation.getJobId(), pipelineWithEdges, vertexInfoMap);
        } else {
            List edges = this.logicalDag.getEdges().stream().map(e -> new Edge(e.getInputVertexId(), e.getTargetVertexId())).collect(Collectors.toList());
            Map<Long, LogicalVertex> logicalVertexMap = this.logicalDag.getLogicalVertexMap();
            Map<Long, VertexInfo> vertexInfoMap = logicalVertexMap.values().stream().map(v -> new VertexInfo(v.getVertexId(), ActionUtils.getActionType(v.getAction()), v.getAction().getName())).collect(Collectors.toMap(VertexInfo::getVertexId, Function.identity()));
            Map<Integer, List<Edge>> pipelineWithEdges = edges.stream().collect(Collectors.groupingBy(e -> {
                LogicalVertex info = (LogicalVertex)logicalVertexMap.get(e.getInputVertexId() != null ? e.getInputVertexId() : e.getTargetVertexId());
                return pipelines.stream().filter(p -> p.getActions().containsKey(info.getAction().getId())).findFirst().get().getId();
            }, Collectors.toList()));
            this.jobDAGInfo = new JobDAGInfo(this.jobImmutableInformation.getJobId(), pipelineWithEdges, vertexInfoMap);
        }
        return this.jobDAGInfo;
    }

    public PassiveCompletableFuture<Void> reSchedulerPipeline(SubPlan subPlan) {
        if (this.jobScheduler == null) {
            this.jobScheduler = new PipelineBaseScheduler(this.physicalPlan, this);
        }
        return new PassiveCompletableFuture<Void>(this.jobScheduler.reSchedulerPipeline(subPlan));
    }

    public void releasePipelineResource(SubPlan subPlan) {
        this.resourceManager.releaseResources(this.jobImmutableInformation.getJobId(), Lists.newArrayList(this.ownedSlotProfilesIMap.get(subPlan.getPipelineLocation()).values())).join();
        this.ownedSlotProfilesIMap.remove(subPlan.getPipelineLocation());
    }

    public void cleanJob() {
    }

    public Address queryTaskGroupAddress(long taskGroupId) {
        for (PipelineLocation pipelineLocation : this.ownedSlotProfilesIMap.keySet()) {
            Optional<TaskGroupLocation> currentVertex = this.ownedSlotProfilesIMap.get(pipelineLocation).keySet().stream().filter(taskGroupLocation -> taskGroupLocation.getTaskGroupId() == taskGroupId).findFirst();
            if (!currentVertex.isPresent()) continue;
            return this.ownedSlotProfilesIMap.get(pipelineLocation).get(currentVertex.get()).getWorker();
        }
        throw new IllegalArgumentException("can't find task group address from task group id: " + taskGroupId);
    }

    public void cancelJob() {
        this.physicalPlan.neverNeedRestore();
        this.physicalPlan.cancelJob();
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public CheckpointManager getCheckpointManager() {
        return this.checkpointManager;
    }

    public PassiveCompletableFuture<JobStatus> getJobMasterCompleteFuture() {
        return new PassiveCompletableFuture<JobStatus>(this.jobMasterCompleteFuture);
    }

    public JobImmutableInformation getJobImmutableInformation() {
        return this.jobImmutableInformation;
    }

    public JobStatus getJobStatus() {
        return this.physicalPlan.getJobStatus();
    }

    public List<RawJobMetrics> getCurrJobMetrics() {
        ArrayList<RawJobMetrics> metrics = new ArrayList<RawJobMetrics>();
        this.ownedSlotProfilesIMap.forEach((pipelineLocation, taskGroupLocationSlotProfileMap) -> taskGroupLocationSlotProfileMap.forEach((taskGroupLocation, slotProfile) -> {
            if (taskGroupLocation.getJobId() == this.getJobImmutableInformation().getJobId()) {
                Address worker = slotProfile.getWorker();
                InvocationFuture invoke = this.nodeEngine.getOperationService().createInvocationBuilder("st:impl:seaTunnelServer", (Operation)new GetTaskGroupMetricsOperation((TaskGroupLocation)taskGroupLocation), worker).invoke();
                try {
                    RawJobMetrics rawJobMetrics = (RawJobMetrics)invoke.get();
                    metrics.add(rawJobMetrics);
                }
                catch (Exception e) {
                    throw new SeaTunnelException(e.getMessage());
                }
            }
        }));
        return metrics;
    }

    public void cleanTaskGroupContext() {
        this.ownedSlotProfilesIMap.forEach((pipelineLocation, taskGroupLocationSlotProfileMap) -> taskGroupLocationSlotProfileMap.forEach((taskGroupLocation, slotProfile) -> {
            Address worker = slotProfile.getWorker();
            InvocationFuture invoke = this.nodeEngine.getOperationService().createInvocationBuilder("st:impl:seaTunnelServer", (Operation)new CleanTaskGroupContextOperation((TaskGroupLocation)taskGroupLocation), worker).invoke();
            try {
                invoke.get();
            }
            catch (Exception e) {
                throw new SeaTunnelException(e.getMessage());
            }
        }));
    }

    public PhysicalPlan getPhysicalPlan() {
        return this.physicalPlan;
    }

    public void updateTaskExecutionState(TaskExecutionState taskExecutionState) {
        this.physicalPlan.getPipelineList().forEach(pipeline -> {
            if (pipeline.getPipelineLocation().getPipelineId() != taskExecutionState.getTaskGroupLocation().getPipelineId()) {
                return;
            }
            pipeline.getCoordinatorVertexList().forEach(task -> {
                if (!task.getTaskGroupLocation().equals(taskExecutionState.getTaskGroupLocation())) {
                    return;
                }
                task.updateTaskExecutionState(taskExecutionState);
            });
            pipeline.getPhysicalVertexList().forEach(task -> {
                if (!task.getTaskGroupLocation().equals(taskExecutionState.getTaskGroupLocation())) {
                    return;
                }
                task.updateTaskExecutionState(taskExecutionState);
            });
        });
    }

    public Map<TaskGroupLocation, SlotProfile> getOwnedSlotProfiles(PipelineLocation pipelineLocation) {
        return this.ownedSlotProfilesIMap.get(pipelineLocation);
    }

    public void setOwnedSlotProfiles(@NonNull PipelineLocation pipelineLocation, @NonNull Map<TaskGroupLocation, SlotProfile> pipelineOwnedSlotProfiles) {
        if (pipelineLocation == null) {
            throw new NullPointerException("pipelineLocation is marked @NonNull but is null");
        }
        if (pipelineOwnedSlotProfiles == null) {
            throw new NullPointerException("pipelineOwnedSlotProfiles is marked @NonNull but is null");
        }
        this.ownedSlotProfilesIMap.put(pipelineLocation, pipelineOwnedSlotProfiles);
        try {
            RetryUtils.retryWithException(() -> pipelineOwnedSlotProfiles.equals(this.ownedSlotProfilesIMap.get(pipelineLocation)), new RetryUtils.RetryMaterial(20, true, exception -> exception instanceof NullPointerException && this.isRunning, 1000L));
        }
        catch (Exception e) {
            throw new SeaTunnelEngineException("Can not sync pipeline owned slot profiles with IMap", e);
        }
    }

    public SlotProfile getOwnedSlotProfiles(@NonNull TaskGroupLocation taskGroupLocation) {
        if (taskGroupLocation == null) {
            throw new NullPointerException("taskGroupLocation is marked @NonNull but is null");
        }
        return this.ownedSlotProfilesIMap.get(new PipelineLocation(taskGroupLocation.getJobId(), taskGroupLocation.getPipelineId())).get(taskGroupLocation);
    }

    public CompletableFuture<Void> getScheduleFuture() {
        return this.scheduleFuture;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void interrupt() {
        try {
            this.isRunning = false;
            this.jobMasterCompleteFuture.cancel(true);
        }
        finally {
            super.interrupt();
        }
    }

    public void markRestore() {
        this.restore = true;
    }
}

