/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.checkpoint;

import com.hazelcast.map.IMap;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.operationservice.impl.InvocationFuture;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.table.factory.FactoryUtil;
import org.apache.seatunnel.engine.checkpoint.storage.PipelineState;
import org.apache.seatunnel.engine.checkpoint.storage.api.CheckpointStorage;
import org.apache.seatunnel.engine.checkpoint.storage.api.CheckpointStorageFactory;
import org.apache.seatunnel.engine.checkpoint.storage.exception.CheckpointStorageException;
import org.apache.seatunnel.engine.common.config.server.CheckpointConfig;
import org.apache.seatunnel.engine.common.utils.ExceptionUtil;
import org.apache.seatunnel.engine.common.utils.PassiveCompletableFuture;
import org.apache.seatunnel.engine.core.job.JobStatus;
import org.apache.seatunnel.engine.core.job.PipelineStatus;
import org.apache.seatunnel.engine.server.checkpoint.CheckpointCoordinator;
import org.apache.seatunnel.engine.server.checkpoint.CheckpointFailureReason;
import org.apache.seatunnel.engine.server.checkpoint.CheckpointPlan;
import org.apache.seatunnel.engine.server.checkpoint.CompletedCheckpoint;
import org.apache.seatunnel.engine.server.checkpoint.IMapCheckpointIDCounter;
import org.apache.seatunnel.engine.server.checkpoint.operation.TaskAcknowledgeOperation;
import org.apache.seatunnel.engine.server.checkpoint.operation.TaskReportStatusOperation;
import org.apache.seatunnel.engine.server.execution.TaskLocation;
import org.apache.seatunnel.engine.server.master.JobMaster;
import org.apache.seatunnel.engine.server.task.operation.TaskOperation;
import org.apache.seatunnel.engine.server.utils.NodeEngineUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckpointManager {
    private static final Logger log = LoggerFactory.getLogger(CheckpointManager.class);
    private final Long jobId;
    private final NodeEngine nodeEngine;
    private final Map<Integer, CheckpointCoordinator> coordinatorMap;
    private final CheckpointStorage checkpointStorage;
    private final JobMaster jobMaster;

    public CheckpointManager(long jobId, NodeEngine nodeEngine, JobMaster jobMaster, Map<Integer, CheckpointPlan> checkpointPlanMap, CheckpointConfig checkpointConfig) throws CheckpointStorageException {
        this.jobId = jobId;
        this.nodeEngine = nodeEngine;
        this.jobMaster = jobMaster;
        this.checkpointStorage = FactoryUtil.discoverFactory(Thread.currentThread().getContextClassLoader(), CheckpointStorageFactory.class, checkpointConfig.getStorage().getStorage()).create(checkpointConfig.getStorage().getStoragePluginConfig());
        IMap checkpointIdMap = nodeEngine.getHazelcastInstance().getMap(String.format("engine_checkpoint-id-%d", jobId));
        this.coordinatorMap = checkpointPlanMap.values().parallelStream().map(plan -> {
            IMapCheckpointIDCounter idCounter = new IMapCheckpointIDCounter(plan.getPipelineId(), checkpointIdMap);
            try {
                idCounter.start();
                PipelineState pipelineState = null;
                if (idCounter.get() != 1L) {
                    pipelineState = this.checkpointStorage.getCheckpoint(String.valueOf(jobId), String.valueOf(plan.getPipelineId()), String.valueOf(idCounter.get() - 1L));
                }
                return new CheckpointCoordinator(this, this.checkpointStorage, checkpointConfig, jobId, (CheckpointPlan)plan, idCounter, pipelineState);
            }
            catch (Exception e) {
                ExceptionUtil.sneakyThrow(e);
                throw new RuntimeException("Never throw here.");
            }
        }).collect(Collectors.toMap(CheckpointCoordinator::getPipelineId, Function.identity()));
    }

    public PassiveCompletableFuture<CompletedCheckpoint>[] triggerSavepoints() {
        return (PassiveCompletableFuture[])this.coordinatorMap.values().parallelStream().map(CheckpointCoordinator::startSavepoint).toArray(PassiveCompletableFuture[]::new);
    }

    public PassiveCompletableFuture<CompletedCheckpoint> triggerSavepoint(int pipelineId) {
        return this.getCheckpointCoordinator(pipelineId).startSavepoint();
    }

    public void reportedPipelineRunning(int pipelineId) {
        this.getCheckpointCoordinator(pipelineId).setAllTaskReady(true);
        this.getCheckpointCoordinator(pipelineId).tryTriggerPendingCheckpoint();
    }

    protected void handleCheckpointError(int pipelineId, Throwable e) {
        this.jobMaster.handleCheckpointError(pipelineId, e);
    }

    private CheckpointCoordinator getCheckpointCoordinator(TaskLocation taskLocation) {
        return this.getCheckpointCoordinator(taskLocation.getPipelineId());
    }

    private CheckpointCoordinator getCheckpointCoordinator(int pipelineId) {
        CheckpointCoordinator coordinator = this.coordinatorMap.get(pipelineId);
        if (coordinator == null) {
            throw new RuntimeException(String.format("The checkpoint coordinator(%s) don't exist", pipelineId));
        }
        return coordinator;
    }

    public void reportedTask(TaskReportStatusOperation reportStatusOperation) {
        log.debug("reported task({}) status {}", (Object)reportStatusOperation.getLocation().getTaskID(), (Object)reportStatusOperation.getStatus());
        this.getCheckpointCoordinator(reportStatusOperation.getLocation()).reportedTask(reportStatusOperation);
    }

    public void readyToClose(TaskLocation taskLocation) {
        this.getCheckpointCoordinator(taskLocation).readyToClose(taskLocation);
    }

    public CompletableFuture<Void> listenPipelineRetry(int pipelineId, PipelineStatus pipelineStatus) {
        this.getCheckpointCoordinator(pipelineId).cleanPendingCheckpoint(CheckpointFailureReason.PIPELINE_END);
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> listenPipeline(int pipelineId, PipelineStatus pipelineStatus) {
        return this.getCheckpointCoordinator(pipelineId).getCheckpointIdCounter().shutdown(pipelineStatus);
    }

    public CompletableFuture<Void> shutdown(JobStatus jobStatus) {
        if (jobStatus == JobStatus.FINISHED) {
            this.checkpointStorage.deleteCheckpoint(this.jobId + "");
        }
        return CompletableFuture.completedFuture(null);
    }

    public boolean isCompletedPipeline(int pipelineId) {
        return this.getCheckpointCoordinator(pipelineId).isCompleted();
    }

    public void acknowledgeTask(TaskAcknowledgeOperation ackOperation) {
        CheckpointCoordinator coordinator = this.getCheckpointCoordinator(ackOperation.getTaskLocation());
        if (coordinator.isCompleted()) {
            log.info("The checkpoint coordinator({}) is completed", (Object)ackOperation.getTaskLocation().getPipelineId());
            return;
        }
        coordinator.acknowledgeTask(ackOperation);
    }

    protected InvocationFuture<?> sendOperationToMemberNode(TaskOperation operation) {
        return NodeEngineUtil.sendOperationToMemberNode(this.nodeEngine, operation, this.jobMaster.queryTaskGroupAddress(operation.getTaskLocation().getTaskGroupLocation().getTaskGroupId()));
    }
}

