/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.imap.storage.file.disruptor;

import com.lmax.disruptor.WorkHandler;
import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.seatunnel.engine.imap.storage.api.common.Serializer;
import org.apache.seatunnel.engine.imap.storage.api.exception.IMapStorageException;
import org.apache.seatunnel.engine.imap.storage.file.bean.IMapFileData;
import org.apache.seatunnel.engine.imap.storage.file.common.WALWriter;
import org.apache.seatunnel.engine.imap.storage.file.disruptor.FileWALEvent;
import org.apache.seatunnel.engine.imap.storage.file.disruptor.WALEventType;
import org.apache.seatunnel.engine.imap.storage.file.future.RequestFutureCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WALWorkHandler
implements WorkHandler<FileWALEvent> {
    private static final Logger log = LoggerFactory.getLogger(WALWorkHandler.class);
    private WALWriter writer;

    public WALWorkHandler(FileSystem fs, String parentPath, Serializer serializer) {
        try {
            this.writer = new WALWriter(fs, new Path(parentPath), serializer);
        }
        catch (IOException e) {
            throw new IMapStorageException(e, "create new current writer failed, parent path is %s", parentPath);
        }
    }

    @Override
    public void onEvent(FileWALEvent fileWALEvent) throws Exception {
        log.debug("write data to orc file");
        this.walEvent(fileWALEvent.getData(), fileWALEvent.getType(), fileWALEvent.getRequestId());
    }

    private void walEvent(IMapFileData iMapFileData, WALEventType type, long requestId) throws Exception {
        if (type == WALEventType.APPEND) {
            boolean writeSuccess = true;
            try {
                this.writer.write(iMapFileData);
            }
            catch (IOException e) {
                writeSuccess = false;
                log.error("write orc file error, walEventBean is {} ", (Object)iMapFileData, (Object)e);
            }
            this.executeResponse(requestId, writeSuccess);
            return;
        }
        if (type == WALEventType.CLOSED) {
            this.writer.close();
        }
    }

    private void executeResponse(long requestId, boolean success) {
        try {
            RequestFutureCache.get(requestId).done(success);
        }
        catch (RuntimeException e) {
            log.error("response error, requestId is {} ", (Object)requestId, (Object)e);
        }
    }
}

