/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.core.job;

import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import lombok.NonNull;
import org.apache.seatunnel.engine.common.config.JobConfig;
import org.apache.seatunnel.engine.core.serializable.JobDataSerializerHook;

public class JobImmutableInformation
implements IdentifiedDataSerializable {
    private long jobId;
    private long createTime;
    private Data logicalDag;
    private JobConfig jobConfig;
    private List<URL> pluginJarsUrls;

    public JobImmutableInformation() {
    }

    public JobImmutableInformation(long jobId, @NonNull Data logicalDag, @NonNull JobConfig jobConfig, @NonNull List<URL> pluginJarsUrls) {
        if (logicalDag == null) {
            throw new NullPointerException("logicalDag is marked @NonNull but is null");
        }
        if (jobConfig == null) {
            throw new NullPointerException("jobConfig is marked @NonNull but is null");
        }
        if (pluginJarsUrls == null) {
            throw new NullPointerException("pluginJarsUrls is marked @NonNull but is null");
        }
        this.createTime = System.currentTimeMillis();
        this.jobId = jobId;
        this.logicalDag = logicalDag;
        this.jobConfig = jobConfig;
        this.pluginJarsUrls = pluginJarsUrls;
    }

    public long getJobId() {
        return this.jobId;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public Data getLogicalDag() {
        return this.logicalDag;
    }

    public JobConfig getJobConfig() {
        return this.jobConfig;
    }

    public List<URL> getPluginJarsUrls() {
        return this.pluginJarsUrls;
    }

    @Override
    public int getFactoryId() {
        return JobDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getClassId() {
        return 3;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeLong(this.jobId);
        out.writeLong(this.createTime);
        IOUtil.writeData(out, this.logicalDag);
        out.writeObject(this.jobConfig);
        out.writeObject(this.pluginJarsUrls);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.jobId = in.readLong();
        this.createTime = in.readLong();
        this.logicalDag = IOUtil.readData(in);
        this.jobConfig = (JobConfig)in.readObject();
        this.pluginJarsUrls = (List)in.readObject();
    }
}

