/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.core.dag.logical;

import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.seatunnel.engine.common.config.JobConfig;
import org.apache.seatunnel.engine.common.utils.IdGenerator;
import org.apache.seatunnel.engine.core.dag.actions.Action;
import org.apache.seatunnel.engine.core.dag.logical.LogicalDag;
import org.apache.seatunnel.engine.core.dag.logical.LogicalEdge;
import org.apache.seatunnel.engine.core.dag.logical.LogicalVertex;

public class LogicalDagGenerator {
    private static final ILogger LOGGER = Logger.getLogger(LogicalDagGenerator.class);
    private List<Action> actions;
    private JobConfig jobConfig;
    private IdGenerator idGenerator;
    private final Map<Long, LogicalVertex> logicalVertexMap = new HashMap<Long, LogicalVertex>();
    private final Map<Long, Set<Long>> inputVerticesMap = new HashMap<Long, Set<Long>>();

    public LogicalDagGenerator(@NonNull List<Action> actions, @NonNull JobConfig jobConfig, @NonNull IdGenerator idGenerator) {
        if (actions == null) {
            throw new NullPointerException("actions is marked @NonNull but is null");
        }
        if (jobConfig == null) {
            throw new NullPointerException("jobConfig is marked @NonNull but is null");
        }
        if (idGenerator == null) {
            throw new NullPointerException("idGenerator is marked @NonNull but is null");
        }
        this.actions = actions;
        this.jobConfig = jobConfig;
        this.idGenerator = idGenerator;
        if (actions.size() <= 0) {
            throw new IllegalStateException("No actions define in the job. Cannot execute.");
        }
    }

    public LogicalDag generate() {
        this.actions.forEach(this::createLogicalVertex);
        Set<LogicalEdge> logicalEdges = this.createLogicalEdges();
        LogicalDag logicalDag = new LogicalDag(this.jobConfig, this.idGenerator);
        logicalDag.getEdges().addAll(logicalEdges);
        logicalDag.getLogicalVertexMap().putAll(this.logicalVertexMap);
        return logicalDag;
    }

    private void createLogicalVertex(Action action) {
        Long logicalVertexId = action.getId();
        if (this.logicalVertexMap.containsKey(logicalVertexId)) {
            return;
        }
        action.getUpstream().forEach(inputAction -> {
            this.createLogicalVertex((Action)inputAction);
            this.inputVerticesMap.computeIfAbsent(inputAction.getId(), id -> new HashSet()).add(logicalVertexId);
        });
        LogicalVertex logicalVertex = new LogicalVertex(logicalVertexId, action, action.getParallelism());
        this.logicalVertexMap.put(logicalVertexId, logicalVertex);
    }

    private Set<LogicalEdge> createLogicalEdges() {
        return this.inputVerticesMap.entrySet().stream().map(entry -> ((Set)entry.getValue()).stream().map(targetId -> new LogicalEdge(this.logicalVertexMap.get(entry.getKey()), this.logicalVertexMap.get(targetId))).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toSet());
    }
}

