/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.client.job;

import lombok.NonNull;
import org.apache.seatunnel.engine.client.SeaTunnelHazelcastClient;
import org.apache.seatunnel.engine.client.job.ClientJobProxy;
import org.apache.seatunnel.engine.core.job.JobImmutableInformation;

public class JobClient {
    private final SeaTunnelHazelcastClient hazelcastClient;

    public JobClient(@NonNull SeaTunnelHazelcastClient hazelcastClient) {
        if (hazelcastClient == null) {
            throw new NullPointerException("hazelcastClient is marked @NonNull but is null");
        }
        this.hazelcastClient = hazelcastClient;
    }

    public long getNewJobId() {
        return this.hazelcastClient.getHazelcastInstance().getFlakeIdGenerator("SeaTunnelIdGenerator").newId();
    }

    public ClientJobProxy createJobProxy(@NonNull JobImmutableInformation jobImmutableInformation) {
        if (jobImmutableInformation == null) {
            throw new NullPointerException("jobImmutableInformation is marked @NonNull but is null");
        }
        return new ClientJobProxy(this.hazelcastClient, jobImmutableInformation);
    }
}

