/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.core.starter.seatunnel.command;

import java.nio.file.Path;
import org.apache.seatunnel.core.starter.command.Command;
import org.apache.seatunnel.core.starter.config.ConfigBuilder;
import org.apache.seatunnel.core.starter.exception.ConfigCheckException;
import org.apache.seatunnel.core.starter.seatunnel.args.ClientCommandArgs;
import org.apache.seatunnel.core.starter.seatunnel.config.SeaTunnelApiConfigChecker;
import org.apache.seatunnel.core.starter.utils.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiConfValidateCommand
implements Command<ClientCommandArgs> {
    private static final Logger log = LoggerFactory.getLogger(ApiConfValidateCommand.class);
    private final ClientCommandArgs clientCommandArgs;

    public ApiConfValidateCommand(ClientCommandArgs clientCommandArgs) {
        this.clientCommandArgs = clientCommandArgs;
    }

    @Override
    public void execute() throws ConfigCheckException {
        Path configPath = FileUtils.getConfigPath(this.clientCommandArgs);
        ConfigBuilder configBuilder = new ConfigBuilder(configPath);
        new SeaTunnelApiConfigChecker().checkConfig(configBuilder.getConfig());
        log.info("config OK !");
    }
}

