/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.topic.impl.reliable;

import com.hazelcast.cluster.Member;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.OperationTimeoutException;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.ringbuffer.ReadResultSet;
import com.hazelcast.ringbuffer.Ringbuffer;
import com.hazelcast.spi.exception.DistributedObjectDestroyedException;
import com.hazelcast.topic.Message;
import com.hazelcast.topic.ReliableMessageListener;
import com.hazelcast.topic.impl.reliable.ReliableTopicMessage;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;

public abstract class MessageRunner<E>
implements BiConsumer<ReadResultSet<ReliableTopicMessage>, Throwable> {
    protected final Ringbuffer<ReliableTopicMessage> ringbuffer;
    protected final ILogger logger;
    protected final ReliableMessageListener<E> listener;
    protected final String topicName;
    protected volatile long sequence;
    private final SerializationService serializationService;
    private final ConcurrentMap<UUID, MessageRunner<E>> runnersMap;
    private final UUID id;
    private final Executor executor;
    private final int batchSize;
    private volatile boolean cancelled;

    public MessageRunner(UUID id, ReliableMessageListener<E> listener, Ringbuffer<ReliableTopicMessage> ringbuffer, String topicName, int batchSize, SerializationService serializationService, Executor executor, ConcurrentMap<UUID, MessageRunner<E>> runnersMap, ILogger logger) {
        this.id = id;
        this.listener = listener;
        this.ringbuffer = ringbuffer;
        this.topicName = topicName;
        this.serializationService = serializationService;
        this.logger = logger;
        this.batchSize = batchSize;
        this.executor = executor;
        this.runnersMap = runnersMap;
        long initialSequence = listener.retrieveInitialSequence();
        if (initialSequence == -1L) {
            initialSequence = ringbuffer.tailSequence() + 1L;
        }
        this.sequence = initialSequence;
    }

    public void next() {
        if (this.cancelled) {
            return;
        }
        this.ringbuffer.readManyAsync(this.sequence, 1, this.batchSize, null).whenCompleteAsync(this, this.executor);
    }

    @Override
    public void accept(ReadResultSet<ReliableTopicMessage> result2, Throwable throwable) {
        if (this.cancelled) {
            return;
        }
        if (throwable == null) {
            long lostCount = result2.getNextSequenceToReadFrom() - (long)result2.readCount() - this.sequence;
            if (lostCount != 0L && !this.isLossTolerable(lostCount)) {
                this.cancel();
                return;
            }
            for (int i = 0; i < result2.size(); ++i) {
                ReliableTopicMessage message = result2.get(i);
                try {
                    this.listener.storeSequence(result2.getSequence(i));
                    this.listener.onMessage(this.toMessage(message));
                    continue;
                }
                catch (Throwable t) {
                    if (!this.terminate(t)) continue;
                    this.cancel();
                    return;
                }
            }
            this.sequence = result2.getNextSequenceToReadFrom();
            this.next();
        } else if (this.handleInternalException(throwable = this.adjustThrowable(throwable))) {
            this.next();
        } else {
            this.cancel();
        }
    }

    private Message<E> toMessage(ReliableTopicMessage m) {
        Member member = this.getMember(m);
        Object payload = this.serializationService.toObject(m.getPayload());
        return new Message(this.topicName, payload, m.getPublishTime(), member);
    }

    protected abstract Member getMember(ReliableTopicMessage var1);

    protected boolean handleInternalException(Throwable t) {
        if (t instanceof OperationTimeoutException) {
            return this.handleOperationTimeoutException();
        }
        if (t instanceof IllegalArgumentException) {
            return this.handleIllegalArgumentException((IllegalArgumentException)t);
        }
        if (t instanceof HazelcastInstanceNotActiveException) {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Terminating MessageListener " + this.listener + " on topic: " + this.topicName + ".  Reason: HazelcastInstance is shutting down");
            }
        } else if (t instanceof DistributedObjectDestroyedException) {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Terminating MessageListener " + this.listener + " on topic: " + this.topicName + ". Reason: Topic is destroyed");
            }
        } else {
            this.logger.warning("Terminating MessageListener " + this.listener + " on topic: " + this.topicName + ". Reason: Unhandled exception, message: " + t.getMessage(), t);
        }
        return false;
    }

    private boolean handleOperationTimeoutException() {
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("MessageListener " + this.listener + " on topic: " + this.topicName + " timed out. Continuing from last known sequence: " + this.sequence);
        }
        return true;
    }

    protected abstract Throwable adjustThrowable(Throwable var1);

    private boolean isLossTolerable(long lossCount) {
        if (this.listener.isLossTolerant()) {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("MessageListener " + this.listener + " on topic: " + this.topicName + " lost " + lossCount + "messages");
            }
            return true;
        }
        this.logger.warning("Terminating MessageListener:" + this.listener + " on topic: " + this.topicName + ". Reason: The listener was too slow or the retention period of the message has been violated. " + lossCount + " messages lost.");
        return false;
    }

    private boolean handleIllegalArgumentException(IllegalArgumentException t) {
        long currentHeadSequence = this.ringbuffer.headSequence();
        if (this.listener.isLossTolerant()) {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest(String.format("MessageListener %s on topic %s requested a too large sequence: %s. . Jumping from old sequence: %s to sequence: %s", this.listener, this.topicName, t.getMessage(), this.sequence, currentHeadSequence));
            }
            this.sequence = currentHeadSequence;
            return true;
        }
        this.logger.warning("Terminating MessageListener:" + this.listener + " on topic: " + this.topicName + ". Reason: Underlying ring buffer data related to reliable topic is lost. ");
        return false;
    }

    public void cancel() {
        this.cancelled = true;
        this.runnersMap.remove(this.id);
    }

    private boolean terminate(Throwable failure) {
        if (this.cancelled) {
            return true;
        }
        try {
            boolean terminate = this.listener.isTerminal(failure);
            if (terminate) {
                this.logger.warning("Terminating MessageListener " + this.listener + " on topic: " + this.topicName + ". Reason: Unhandled exception, message: " + failure.getMessage(), failure);
            } else if (this.logger.isFinestEnabled()) {
                this.logger.finest("MessageListener " + this.listener + " on topic: " + this.topicName + " ran into an exception: message:" + failure.getMessage(), failure);
            }
            return terminate;
        }
        catch (Throwable t) {
            this.logger.warning("Terminating messageListener:" + this.listener + " on topic: " + this.topicName + ". Reason: Unhandled exception while calling ReliableMessageListener.isTerminal() method", t);
            return true;
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }
}

