/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.connector;

import com.hazelcast.internal.util.JVMUtil;
import com.hazelcast.jet.core.AbstractProcessor;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.security.impl.function.SecuredFunctions;
import com.hazelcast.security.permission.ConnectorPermission;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.security.Permission;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import javax.annotation.Nonnull;

public final class StreamSocketP
extends AbstractProcessor {
    private static final int BUFFER_SIZE = 4096;
    private static final int MAX_BYTES_PER_CHAR = 4;
    private final String host;
    private final int port;
    private final CharsetDecoder charsetDecoder;
    private final StringBuilder lineBuilder = new StringBuilder();
    private String pendingLine;
    private SocketChannel socketChannel;
    private final ByteBuffer byteBuffer = ByteBuffer.allocate(4096);
    private final CharBuffer charBuffer = CharBuffer.allocate(4096);
    private boolean socketDone;
    private boolean maybeLfExpected;

    public StreamSocketP(String host, int port, Charset charset) {
        this.host = host;
        this.port = port;
        this.charsetDecoder = charset.newDecoder();
    }

    @Override
    protected void init(@Nonnull Processor.Context context) throws Exception {
        this.getLogger().info("Connecting to socket " + this.hostAndPort());
        this.socketChannel = SocketChannel.open();
        this.socketChannel.configureBlocking(false);
        this.socketChannel.connect(new InetSocketAddress(this.host, this.port));
        while (!this.socketChannel.finishConnect()) {
            LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(1L));
        }
        this.getLogger().info("Connected to socket " + this.hostAndPort());
        JVMUtil.upcast(this.byteBuffer).limit(0);
        JVMUtil.upcast(this.charBuffer).limit(0);
    }

    @Override
    public boolean complete() {
        try {
            return this.tryComplete();
        }
        catch (Exception e) {
            throw ExceptionUtil.sneakyThrow(e);
        }
    }

    private boolean tryComplete() throws IOException {
        this.fillCharBuffer();
        this.emitFromCharBuffer();
        return this.socketDone && this.pendingLine == null;
    }

    private void fillCharBuffer() throws IOException {
        if (this.socketDone || this.charBuffer.hasRemaining()) {
            return;
        }
        this.socketDone = this.socketChannel.read(this.byteBuffer) < 0;
        JVMUtil.upcast(this.byteBuffer).flip();
        JVMUtil.upcast(this.charBuffer).clear();
        this.charsetDecoder.decode(this.byteBuffer, this.charBuffer, this.socketDone);
        JVMUtil.upcast(this.charBuffer).flip();
        this.byteBuffer.compact();
        assert (this.byteBuffer.position() < 3) : "position=" + this.byteBuffer.position();
    }

    private void emitFromCharBuffer() {
        while (this.charBuffer.hasRemaining()) {
            if (this.pendingLine == null) {
                this.pendingLine = this.tryReadLineFromBuffer();
            }
            if (this.pendingLine == null) continue;
            if (!this.tryEmit(this.pendingLine)) break;
            this.pendingLine = null;
        }
    }

    private String tryReadLineFromBuffer() {
        while (this.charBuffer.hasRemaining()) {
            char ch = this.charBuffer.get();
            if (ch == '\r' || ch == '\n') {
                if (this.maybeLfExpected && ch == '\n') {
                    this.maybeLfExpected = false;
                    continue;
                }
                if (ch == '\r') {
                    this.maybeLfExpected = true;
                }
                try {
                    String string2 = this.lineBuilder.toString();
                    return string2;
                }
                finally {
                    this.lineBuilder.setLength(0);
                }
            }
            this.lineBuilder.append(ch);
            this.maybeLfExpected = false;
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        if (this.socketChannel != null) {
            this.getLogger().info("Closing socket " + this.hostAndPort());
            this.socketChannel.close();
        }
    }

    private String hostAndPort() {
        return this.host + ':' + this.port;
    }

    public static ProcessorMetaSupplier supplier(String host, int port, @Nonnull String charset) {
        return ProcessorMetaSupplier.preferLocalParallelismOne((Permission)ConnectorPermission.socket(host, port, "read"), SecuredFunctions.streamSocketProcessorFn(host, port, charset));
    }
}

