/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.custom;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.CustomTypeFactory;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListMultiFrameCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.client.impl.protocol.codec.custom.BitmapIndexOptionsCodec;
import com.hazelcast.config.BitmapIndexOptions;
import com.hazelcast.config.IndexConfig;
import java.util.List;

public final class IndexConfigCodec {
    private static final int TYPE_FIELD_OFFSET = 0;
    private static final int INITIAL_FRAME_SIZE = 4;

    private IndexConfigCodec() {
    }

    public static void encode(ClientMessage clientMessage, IndexConfig indexConfig) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[4]);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, indexConfig.getType());
        clientMessage.add(initialFrame);
        CodecUtil.encodeNullable(clientMessage, indexConfig.getName(), StringCodec::encode);
        ListMultiFrameCodec.encode(clientMessage, indexConfig.getAttributes(), StringCodec::encode);
        CodecUtil.encodeNullable(clientMessage, indexConfig.getBitmapIndexOptions(), BitmapIndexOptionsCodec::encode);
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static IndexConfig decode(ClientMessage.ForwardFrameIterator iterator2) {
        iterator2.next();
        ClientMessage.Frame initialFrame = iterator2.next();
        int type = FixedSizeTypesCodec.decodeInt(initialFrame.content, 0);
        String name = CodecUtil.decodeNullable(iterator2, StringCodec::decode);
        List<String> attributes = ListMultiFrameCodec.decode(iterator2, StringCodec::decode);
        BitmapIndexOptions bitmapIndexOptions = CodecUtil.decodeNullable(iterator2, BitmapIndexOptionsCodec::decode);
        CodecUtil.fastForwardToEndFrame(iterator2);
        return CustomTypeFactory.createIndexConfig(name, type, attributes, bitmapIndexOptions);
    }
}

