/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.translation.spark.sink;

import java.io.IOException;
import java.util.Optional;
import org.apache.seatunnel.api.sink.SeaTunnelSink;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.common.utils.SerializationUtils;
import org.apache.seatunnel.translation.spark.sink.SparkDataSourceWriter;
import org.apache.seatunnel.translation.spark.sink.SparkStreamWriter;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.sources.v2.DataSourceOptions;
import org.apache.spark.sql.sources.v2.DataSourceV2;
import org.apache.spark.sql.sources.v2.StreamWriteSupport;
import org.apache.spark.sql.sources.v2.WriteSupport;
import org.apache.spark.sql.sources.v2.writer.DataSourceWriter;
import org.apache.spark.sql.sources.v2.writer.streaming.StreamWriter;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.types.StructType;

public class SparkSink<StateT, CommitInfoT, AggregatedCommitInfoT>
implements WriteSupport,
StreamWriteSupport,
DataSourceV2 {
    private volatile SeaTunnelSink<SeaTunnelRow, StateT, CommitInfoT, AggregatedCommitInfoT> sink;

    private void init(DataSourceOptions options) {
        if (this.sink == null) {
            this.sink = (SeaTunnelSink)SerializationUtils.stringToObject((String)options.get("sink").orElseThrow(() -> new IllegalArgumentException("can not find sink class string in DataSourceOptions")));
        }
    }

    public StreamWriter createStreamWriter(String queryId, StructType schema, OutputMode mode, DataSourceOptions options) {
        this.init(options);
        try {
            return new SparkStreamWriter<StateT, CommitInfoT, AggregatedCommitInfoT>(this.sink);
        }
        catch (IOException e) {
            throw new RuntimeException("find error when createStreamWriter", e);
        }
    }

    public Optional<DataSourceWriter> createWriter(String writeUUID, StructType schema, SaveMode mode, DataSourceOptions options) {
        this.init(options);
        try {
            return Optional.of(new SparkDataSourceWriter<StateT, CommitInfoT, AggregatedCommitInfoT>(this.sink));
        }
        catch (IOException e) {
            throw new RuntimeException("find error when createStreamWriter", e);
        }
    }
}

