/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.translation.spark.sink;

import java.io.IOException;
import org.apache.seatunnel.api.sink.DefaultSinkWriterContext;
import org.apache.seatunnel.api.sink.SeaTunnelSink;
import org.apache.seatunnel.api.sink.SinkCommitter;
import org.apache.seatunnel.api.sink.SinkWriter;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.translation.spark.sink.SparkDataWriter;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.sources.v2.writer.DataWriter;
import org.apache.spark.sql.sources.v2.writer.DataWriterFactory;

public class SparkDataWriterFactory<CommitInfoT, StateT>
implements DataWriterFactory<InternalRow> {
    private final SeaTunnelSink<SeaTunnelRow, StateT, CommitInfoT, ?> sink;

    SparkDataWriterFactory(SeaTunnelSink<SeaTunnelRow, StateT, CommitInfoT, ?> sink) {
        this.sink = sink;
    }

    public DataWriter<InternalRow> createDataWriter(int partitionId, long taskId, long epochId) {
        SinkCommitter committer;
        SinkWriter<SeaTunnelRow, CommitInfoT, StateT> writer;
        DefaultSinkWriterContext context = new DefaultSinkWriterContext((int)taskId);
        try {
            writer = this.sink.createWriter(context);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create SinkWriter.", e);
        }
        try {
            committer = this.sink.createCommitter().orElse(null);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create SinkCommitter.", e);
        }
        return new SparkDataWriter<CommitInfoT, StateT>(writer, committer, this.sink.getConsumedType(), epochId);
    }
}

