/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.translation.spark.common.utils;

import java.time.Instant;

public class InstantConverterUtils {
    private static final long MICRO_OF_SECOND = 1000000L;
    private static final int MICRO_OF_NANOS = 1000;

    public static Long toEpochMicro(Instant instant) {
        long seconds = instant.getEpochSecond();
        int nanos = instant.getNano();
        if (seconds < 0L && nanos > 0) {
            long micro = Math.multiplyExact(seconds + 1L, 1000000L);
            long adjustment = (long)(nanos / 1000) - 1000000L;
            return Math.addExact(micro, adjustment);
        }
        long millis = Math.multiplyExact(seconds, 1000000L);
        return Math.addExact(millis, (long)(nanos / 1000));
    }

    public static Instant ofEpochMicro(long epochMicro) {
        long secs = Math.floorDiv(epochMicro, 1000000L);
        int mos = (int)Math.floorMod(epochMicro, 1000000L);
        return Instant.ofEpochSecond(secs, Math.multiplyExact(mos, 1000));
    }
}

