/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.common.config;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum DeployMode {
    CLIENT("client"),
    CLUSTER("cluster");

    private static final Map<String, DeployMode> NAME_MAP;
    private final String name;

    public static Optional<DeployMode> from(String name) {
        return Optional.ofNullable(NAME_MAP.get(name.toLowerCase()));
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    private DeployMode(String name) {
        this.name = name;
    }

    static {
        NAME_MAP = Arrays.stream(DeployMode.values()).collect(Collectors.toMap(DeployMode::getName, Function.identity()));
    }
}

