/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.common.metrics;

import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class Measurement
implements Serializable {
    private Map<String, String> tags;
    private String metric;
    private Object value;
    private long timestamp;

    Measurement() {
    }

    private Measurement(String metric, Object value, long timestamp, Map<String, String> tags) {
        this.metric = metric;
        this.value = value;
        this.timestamp = timestamp;
        this.tags = new HashMap<String, String>(tags);
    }

    public static Measurement of(String metric, Object value, long timestamp, Map<String, String> tags) {
        Objects.requireNonNull(tags, "metric");
        Objects.requireNonNull(tags, "tags");
        return new Measurement(metric, value, timestamp, tags);
    }

    public Object value() {
        return this.value;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public String metric() {
        return this.metric;
    }

    public String tag(String name) {
        return this.tags.get(name);
    }

    public int hashCode() {
        return 31 * (int)(this.timestamp * 31L + (long)this.value.hashCode()) + Objects.hashCode(this.tags);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof Measurement)) return false;
        Measurement that = (Measurement)obj;
        if (this.timestamp != that.timestamp) return false;
        if (this.value != that.value) return false;
        if (!Objects.equals(this.tags, that.tags)) return false;
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%s %s", this.metric, this.value)).append(" ").append(this.timestamp).append(" [");
        String tags = this.tags.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(", "));
        sb.append(tags).append(']');
        return sb.toString();
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public String getMetric() {
        return this.metric;
    }

    public Object getValue() {
        return this.value;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public void setMetric(String metric) {
        this.metric = metric;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }
}

