/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.core.starter.spark.execution;

import java.util.ArrayList;
import java.util.List;
import org.apache.seatunnel.api.common.JobContext;
import org.apache.seatunnel.core.starter.exception.TaskExecuteException;
import org.apache.seatunnel.core.starter.spark.config.SparkEnvironmentFactory;
import org.apache.seatunnel.core.starter.spark.execution.PluginExecuteProcessor;
import org.apache.seatunnel.core.starter.spark.execution.SinkExecuteProcessor;
import org.apache.seatunnel.core.starter.spark.execution.SourceExecuteProcessor;
import org.apache.seatunnel.core.starter.spark.execution.TransformExecuteProcessor;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.spark.SparkEnvironment;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkExecution {
    private static final Logger LOGGER = LoggerFactory.getLogger(SparkExecution.class);
    private final SparkEnvironment sparkEnvironment;
    private final PluginExecuteProcessor sourcePluginExecuteProcessor;
    private final PluginExecuteProcessor transformPluginExecuteProcessor;
    private final PluginExecuteProcessor sinkPluginExecuteProcessor;

    public SparkExecution(Config config) {
        this.sparkEnvironment = (SparkEnvironment)new SparkEnvironmentFactory(config).getEnvironment();
        JobContext jobContext = new JobContext();
        jobContext.setJobMode(this.sparkEnvironment.getJobMode());
        this.sourcePluginExecuteProcessor = new SourceExecuteProcessor(this.sparkEnvironment, jobContext, config.getConfigList("source"));
        this.transformPluginExecuteProcessor = new TransformExecuteProcessor(this.sparkEnvironment, jobContext, config.getConfigList("transform"));
        this.sinkPluginExecuteProcessor = new SinkExecuteProcessor(this.sparkEnvironment, jobContext, config.getConfigList("sink"));
    }

    public void execute() throws TaskExecuteException {
        List<Dataset<Row>> datasets = new ArrayList<Dataset<Row>>();
        datasets = this.sourcePluginExecuteProcessor.execute(datasets);
        datasets = this.transformPluginExecuteProcessor.execute(datasets);
        this.sinkPluginExecuteProcessor.execute(datasets);
        LOGGER.info("Spark Execution started");
    }
}

