/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.common.utils;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;

public class ReflectionUtils {
    public static Optional<Method> getDeclaredMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        Optional<Method> method = Optional.empty();
        while (clazz != null) {
            try {
                Method m = clazz.getDeclaredMethod(methodName, parameterTypes);
                m.setAccessible(true);
                return Optional.of(m);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                clazz = clazz.getSuperclass();
            }
        }
        return method;
    }

    public static Optional<Object> getField(Object object, Class<?> clazz, String fieldName) {
        try {
            Field field2 = clazz.getDeclaredField(fieldName);
            field2.setAccessible(true);
            return Optional.of(field2.get(object));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return Optional.empty();
        }
    }

    public static Optional<Object> getField(Object object, String fieldName) {
        return ReflectionUtils.getField(object, object.getClass(), fieldName);
    }

    public static void setField(Object object, Class<?> clazz, String fieldName, Object value) {
        try {
            Field field2 = clazz.getDeclaredField(fieldName);
            field2.setAccessible(true);
            field2.set(object, value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("field set failed", e);
        }
    }

    public static void setField(Object object, String fieldName, Object value) {
        ReflectionUtils.setField(object, object.getClass(), fieldName, value);
    }

    public static Object invoke(Object object, String methodName, Object ... args) {
        Class[] argTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            argTypes[i] = args[i].getClass();
        }
        return ReflectionUtils.invoke(object, methodName, argTypes, args);
    }

    public static Object invoke(Object object, String methodName, Class<?>[] argTypes, Object[] args) {
        try {
            Optional<Method> method = ReflectionUtils.getDeclaredMethod(object.getClass(), methodName, argTypes);
            if (method.isPresent()) {
                method.get().setAccessible(true);
                return method.get().invoke(object, args);
            }
            throw new NoSuchMethodException(String.format("method invoke failed, no such method '%s' in '%s'", methodName, object.getClass()));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("method invoke failed", e);
        }
    }
}

