/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.table.catalog;

import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;

public abstract class Column
implements Serializable {
    private static final long serialVersionUID = -1L;
    protected final String name;
    protected final SeaTunnelDataType<?> dataType;
    protected final String comment;

    private Column(String name, SeaTunnelDataType<?> dataType, String comment) {
        this.name = name;
        this.dataType = dataType;
        this.comment = comment;
    }

    public static PhysicalColumn physical(String name, SeaTunnelDataType<?> dataType) {
        return new PhysicalColumn(name, (SeaTunnelDataType)dataType);
    }

    public static MetadataColumn metadata(String name, SeaTunnelDataType<?> dataType, String metadataKey) {
        return new MetadataColumn(name, (SeaTunnelDataType)dataType, metadataKey);
    }

    public abstract Column withComment(String var1);

    public abstract boolean isPhysical();

    public SeaTunnelDataType<?> getDataType() {
        return this.dataType;
    }

    public String getName() {
        return this.name;
    }

    public Optional<String> getComment() {
        return Optional.ofNullable(this.comment);
    }

    public abstract Column copy(SeaTunnelDataType<?> var1);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Column that = (Column)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.dataType, that.dataType) && Objects.equals(this.comment, that.comment);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.dataType);
    }

    public static final class MetadataColumn
    extends Column {
        private final String metadataKey;

        private MetadataColumn(String name, SeaTunnelDataType<?> dataType, String metadataKey) {
            this(name, dataType, metadataKey, null);
        }

        private MetadataColumn(String name, SeaTunnelDataType<?> dataType, String metadataKey, String comment) {
            super(name, dataType, comment);
            this.metadataKey = metadataKey;
        }

        public Optional<String> getMetadataKey() {
            return Optional.ofNullable(this.metadataKey);
        }

        @Override
        public MetadataColumn withComment(String comment) {
            if (comment == null) {
                return this;
            }
            return new MetadataColumn(this.name, this.dataType, this.metadataKey, comment);
        }

        @Override
        public boolean isPhysical() {
            return false;
        }

        @Override
        public Column copy(SeaTunnelDataType<?> newDataType) {
            return new MetadataColumn(this.name, newDataType, this.metadataKey, this.comment);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            MetadataColumn that = (MetadataColumn)o;
            return Objects.equals(this.metadataKey, that.metadataKey);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.metadataKey);
        }
    }

    public static final class PhysicalColumn
    extends Column {
        private PhysicalColumn(String name, SeaTunnelDataType<?> dataType) {
            this(name, dataType, null);
        }

        private PhysicalColumn(String name, SeaTunnelDataType<?> dataType, String comment) {
            super(name, dataType, comment);
        }

        @Override
        public PhysicalColumn withComment(String comment) {
            if (comment == null) {
                return this;
            }
            return new PhysicalColumn(this.name, this.dataType, comment);
        }

        @Override
        public boolean isPhysical() {
            return true;
        }

        @Override
        public Column copy(SeaTunnelDataType<?> newDataType) {
            return new PhysicalColumn(this.name, newDataType, this.comment);
        }
    }
}

