/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.samza.system.azureblob.utils;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;


public class TestNullBlobMetadataGenerator {
  private NullBlobMetadataGenerator nullBlobMetadataGenerator;

  @Before
  public void setup() {
    nullBlobMetadataGenerator = new NullBlobMetadataGenerator();
  }

  @Test
  public void testGetBlobMetadata() {
    Assert.assertNull(nullBlobMetadataGenerator.getBlobMetadata(new BlobMetadataContext("fake_stream", 100, 10)));
  }

  @Test
  public void testGetBlobMetadataEmptyInput() {
    Assert.assertNull(nullBlobMetadataGenerator.getBlobMetadata(new BlobMetadataContext("", 0, 0)));
  }

  @Test
  public void testGetBlobMetadataNullInput() {
    Assert.assertNull(nullBlobMetadataGenerator.getBlobMetadata(new BlobMetadataContext(null, 0, 0)));
  }
}
