/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.swc.io;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.security.DigestOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.royale.swc.ISWC;
import org.apache.royale.swc.ISWCFileEntry;
import org.apache.royale.swc.ISWCLibrary;
import org.apache.royale.swc.io.SWCWriterBase;
import org.apache.royale.swf.ISWF;
import org.apache.royale.swf.io.ISWFWriter;
import org.apache.royale.swf.io.ISWFWriterFactory;
import org.apache.royale.swf.io.SizeReportWritingSWFWriter;

public class SWCDirectoryWriter
extends SWCWriterBase {
    private final File directory;

    public SWCDirectoryWriter(String path) {
        this(path, true, true, false, SizeReportWritingSWFWriter.getSWFWriterFactory(null));
    }

    public SWCDirectoryWriter(String path, boolean compressLibrarySWF, boolean enableDebug, boolean enableTelemetry, ISWFWriterFactory swfWriterFactory) {
        super(compressLibrarySWF, enableDebug, enableTelemetry, swfWriterFactory);
        this.directory = new File(path);
    }

    @Override
    void writeCatalog(ISWC swc) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(new File(this.directory, "catalog.xml")));
        this.writeCatalogXML(swc, writer);
        ((Writer)writer).flush();
        ((Writer)writer).close();
    }

    @Override
    void writeLibrary(ISWCLibrary library) throws IOException {
        ISWF swf = library.getSWF();
        String path = library.getPath();
        assert (swf != null) : "Expect SWF model";
        assert (path != null) : "Expect SWF path";
        BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(new File(this.directory, path)));
        DigestOutputStream digestStream = this.getDigestOutputStream(library, outputStream);
        ISWFWriter swfWriter = this.swfWriterFactory.createSWFWriter(swf, this.getLibrarySWFCompression(), this.enableDebug, this.enableTelemetry);
        swfWriter.writeTo(digestStream != null ? digestStream : outputStream);
        swfWriter.close();
        ((OutputStream)outputStream).close();
        if (digestStream != null) {
            this.addDigestToLibrary(digestStream, library);
        }
    }

    @Override
    void writeFile(ISWCFileEntry fileEntry) throws IOException {
        File file = new File(this.directory, fileEntry.getPath()).getAbsoluteFile();
        File parentFolder = file.getParentFile();
        if (!parentFolder.isDirectory()) {
            parentFolder.mkdirs();
        }
        file.createNewFile();
        FileOutputStream outputStream = new FileOutputStream(file);
        InputStream fileInputStream = fileEntry.createInputStream();
        IOUtils.copy((InputStream)fileInputStream, (OutputStream)outputStream);
        fileInputStream.close();
        ((OutputStream)outputStream).close();
    }

    @Override
    void prepare(ISWC swc) throws IOException {
        if (!this.directory.exists() && !this.directory.mkdir()) {
            throw new FileNotFoundException(this.directory.getAbsolutePath());
        }
    }

    @Override
    void finish(ISWC swc) throws IOException {
    }
}

