/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.clients;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.royale.compiler.asdoc.IASDocDelegate;
import org.apache.royale.compiler.clients.COMPC;
import org.apache.royale.compiler.clients.COMPJSCNative;
import org.apache.royale.compiler.clients.COMPJSCRoyale;
import org.apache.royale.compiler.clients.MXMLJSC;
import org.apache.royale.compiler.clients.problems.ProblemFormatter;
import org.apache.royale.compiler.clients.problems.ProblemPrinter;
import org.apache.royale.compiler.clients.problems.WorkspaceProblemFormatter;
import org.apache.royale.compiler.config.CompilerDiagnosticsConstants;
import org.apache.royale.compiler.internal.driver.js.goog.JSGoogCompcConfiguration;
import org.apache.royale.compiler.internal.parsing.as.RoyaleASDocDelegate;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.problems.UnexpectedExceptionProblem;
import org.apache.royale.compiler.targets.ITarget;
import org.apache.royale.utils.ArgumentUtil;

public class COMPJSC
extends MXMLJSC {
    @Override
    public String getName() {
        return "COMPC";
    }

    @Override
    public int execute(String[] args) {
        return COMPJSC.staticMainNoExit(args);
    }

    public static void main(String[] args) {
        int exitCode = COMPJSC.staticMainNoExit(args);
        System.exit(exitCode);
    }

    public static int staticMainNoExit(String[] args) {
        long startTime = System.nanoTime();
        COMPJSC mxmlc = new COMPJSC();
        mxmlc.configurationClass = JSGoogCompcConfiguration.class;
        ArrayList<ICompilerProblem> problems = new ArrayList<ICompilerProblem>();
        int exitCode = mxmlc.mainNoExit(args, problems, true);
        long endTime = System.nanoTime();
        System.out.println((double)(endTime - startTime) / 1.0E9 + " seconds");
        return exitCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int mainNoExit(String[] args, List<ICompilerProblem> problems, Boolean printProblems) {
        int exitCode = -1;
        try {
            exitCode = this._mainNoExit(ArgumentUtil.fixArgs((String[])args), problems);
        }
        catch (Exception e) {
            System.err.println(e.toString());
        }
        finally {
            if (problems != null && !problems.isEmpty() && printProblems.booleanValue()) {
                WorkspaceProblemFormatter formatter = new WorkspaceProblemFormatter(this.workspace);
                ProblemPrinter printer = new ProblemPrinter((ProblemFormatter)formatter);
                printer.printProblems(problems);
            }
        }
        return exitCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int _mainNoExit(String[] args, List<ICompilerProblem> outProblems) {
        Iterator<String> iterator;
        System.out.println("args:");
        for (String arg : args) {
            System.out.println(arg);
        }
        ExitCode exitCode = ExitCode.SUCCESS;
        try {
            boolean continueCompilation = this.configure(args);
            CompilerDiagnosticsConstants.diagnostics = this.config.getDiagnosticsLevel();
            if (continueCompilation) {
                List<String> targets = this.config.getCompilerTargets();
                for (String target : targets) {
                    System.out.println("target:" + target);
                }
            } else {
                if (this.problems.hasFilteredProblems()) {
                    exitCode = ExitCode.FAILED_WITH_CONFIG_PROBLEMS;
                    return exitCode.code;
                }
                exitCode = ExitCode.PRINT_HELP;
                return exitCode.code;
            }
            iterator = this.config.getCompilerTargets().iterator();
        }
        catch (Exception e) {
            if (outProblems == null) {
                System.err.println(e.getMessage());
            } else {
                UnexpectedExceptionProblem unexpectedExceptionProblem = new UnexpectedExceptionProblem((Throwable)e);
                this.problems.add((ICompilerProblem)unexpectedExceptionProblem);
            }
            exitCode = ExitCode.FAILED_WITH_EXCEPTIONS;
            return (int)exitCode;
        }
        finally {
            this.waitAndClose();
            if (outProblems == null) return exitCode.code;
            if (!this.problems.hasFilteredProblems()) return exitCode.code;
            Iterator iterator2 = this.problems.getFilteredProblems().iterator();
            while (iterator2.hasNext()) {
                ICompilerProblem problem = (ICompilerProblem)iterator2.next();
                outProblems.add(problem);
            }
            return exitCode.code;
        }
        block13: while (iterator.hasNext()) {
            String target;
            target = iterator.next();
            int result = 0;
            switch (MXMLJSC.JSTargetType.fromString(target)) {
                case SWF: {
                    System.out.println("COMPC");
                    COMPC compc = new COMPC();
                    this.mxmlc = compc;
                    compc.workspace.setASDocDelegate((IASDocDelegate)new RoyaleASDocDelegate(true));
                    compc.configurationClass = JSGoogCompcConfiguration.class;
                    result = compc.mainNoExit(this.removeJSArgs(args));
                    if (result == 0) break;
                    this.problems.addAll((Iterable)compc.problems.getProblems());
                    break block13;
                }
                case JS_ROYALE: {
                    System.out.println("COMPCJSCRoyale");
                    COMPJSCRoyale royale = new COMPJSCRoyale();
                    this.lastCompiler = royale;
                    result = royale.mainNoExit(this.removeASArgs(args), this.problems.getProblems(), false);
                    if (result == 0) break;
                    break block13;
                }
                case JS_NATIVE: 
                case JS_NODE: {
                    COMPJSCNative jsc = new COMPJSCNative();
                    this.lastCompiler = jsc;
                    result = jsc.mainNoExit(this.removeASArgs(args), this.problems.getProblems(), false);
                    if (result != 0) break block13;
                }
            }
        }
        if (!this.problems.hasFilteredProblems()) return exitCode.code;
        if (this.problems.hasErrors()) {
            exitCode = ExitCode.FAILED_WITH_EXCEPTIONS;
            return exitCode.code;
        }
        exitCode = ExitCode.FAILED_WITH_PROBLEMS;
        return exitCode.code;
    }

    @Override
    protected String getProgramName() {
        return "compc";
    }

    protected boolean isCompc() {
        return true;
    }

    @Override
    protected ITarget.TargetType getTargetType() {
        return ITarget.TargetType.SWC;
    }

    static enum ExitCode {
        SUCCESS(0),
        PRINT_HELP(1),
        FAILED_WITH_PROBLEMS(2),
        FAILED_WITH_EXCEPTIONS(3),
        FAILED_WITH_CONFIG_PROBLEMS(4);

        final int code;

        private ExitCode(int code) {
            this.code = code;
        }
    }
}

