/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.embedding.transcoders;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import org.apache.royale.compiler.common.IFileSpecificationGetter;
import org.apache.royale.compiler.internal.embedding.EmbedData;
import org.apache.royale.compiler.internal.embedding.transcoders.DataTranscoder;
import org.apache.royale.compiler.internal.parsing.as.ASToken;
import org.apache.royale.compiler.internal.semantics.PostProcessStep;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorNodeBase;
import org.apache.royale.compiler.internal.tree.as.ClassNode;
import org.apache.royale.compiler.internal.tree.as.FileNode;
import org.apache.royale.compiler.internal.tree.as.FunctionCallNode;
import org.apache.royale.compiler.internal.tree.as.FunctionNode;
import org.apache.royale.compiler.internal.tree.as.IdentifierNode;
import org.apache.royale.compiler.internal.tree.as.ImportNode;
import org.apache.royale.compiler.internal.tree.as.LanguageIdentifierNode;
import org.apache.royale.compiler.internal.tree.as.NamespaceIdentifierNode;
import org.apache.royale.compiler.internal.tree.as.PackageNode;
import org.apache.royale.compiler.internal.tree.as.ScopedBlockNode;
import org.apache.royale.compiler.internal.workspaces.Workspace;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.swf.tags.ICharacterTag;
import org.apache.royale.swf.tags.ITag;

public class PBJTranscoder
extends DataTranscoder {
    public PBJTranscoder(EmbedData data, Workspace workspace) {
        super(data, workspace);
    }

    @Override
    protected Map<String, ICharacterTag> doTranscode(Collection<ITag> tags, Collection<ICompilerProblem> problems) {
        String symbolName = this.data.getQName() + "ByteArray";
        return this.doTranscode(symbolName, tags, problems);
    }

    @Override
    public FileNode buildAST(Collection<ICompilerProblem> problems, String filename) {
        FileNode fileNode = new FileNode((IFileSpecificationGetter)this.workspace, filename);
        PackageNode packageNode = new PackageNode(new IdentifierNode(""), null);
        fileNode.addItem(packageNode);
        ScopedBlockNode packageContents = packageNode.getScopedNode();
        ImportNode importNode = ImportNode.buildImportNode(this.getBaseClassQName());
        packageContents.addItem(importNode);
        importNode = ImportNode.buildImportNode("mx.core.IFlexAsset");
        packageContents.addItem(importNode);
        importNode = ImportNode.buildImportNode("flash.utils.ByteArray");
        packageContents.addItem(importNode);
        importNode = ImportNode.buildImportNode("flash.display.Shader");
        packageContents.addItem(importNode);
        String byteArrayClassName = this.data.getQName() + "ByteArray";
        ClassNode classNodeByteArray = new ClassNode(new IdentifierNode(byteArrayClassName));
        classNodeByteArray.setBaseClass(new IdentifierNode(this.getBaseClassName()));
        classNodeByteArray.setNamespace(new NamespaceIdentifierNode("public"));
        packageContents.addItem(classNodeByteArray);
        String pbjClassName = this.data.getQName();
        ClassNode classNodePbj = new ClassNode(new IdentifierNode(pbjClassName));
        classNodePbj.setBaseClass(new IdentifierNode("Shader"));
        classNodePbj.addInterface(new IdentifierNode("IFlexAsset"));
        classNodePbj.setNamespace(new NamespaceIdentifierNode("public"));
        packageContents.addItem(classNodePbj);
        IdentifierNode constructorNameNode = new IdentifierNode(pbjClassName);
        constructorNameNode.setReferenceValue(classNodePbj.getDefinition());
        FunctionNode constructorNode = new FunctionNode(null, constructorNameNode);
        constructorNode.setNamespace(new NamespaceIdentifierNode("public"));
        ScopedBlockNode constructorContents = constructorNode.getScopedNode();
        FunctionCallNode superCall = new FunctionCallNode(LanguageIdentifierNode.buildSuper());
        constructorContents.addItem(superCall);
        ASToken newToken = new ASToken(153, -1, -1, -1, -1, "new");
        FunctionCallNode newCall = new FunctionCallNode(newToken, new IdentifierNode(byteArrayClassName));
        ASToken assignToken = new ASToken(53, -1, -1, -1, -1, "=");
        BinaryOperatorNodeBase assignment = BinaryOperatorNodeBase.create(assignToken, new IdentifierNode("byteCode"), newCall);
        constructorContents.addItem(assignment);
        classNodePbj.getScopedNode().addItem(constructorNode);
        fileNode.runPostProcess(EnumSet.of(PostProcessStep.POPULATE_SCOPE));
        return fileNode;
    }
}

