/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.js.jx;

import java.util.EnumSet;
import org.apache.royale.compiler.codegen.ISubEmitter;
import org.apache.royale.compiler.codegen.js.IJSEmitter;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.constants.IASLanguageConstants;
import org.apache.royale.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.JSSubEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.PseudoCatchAllParam;
import org.apache.royale.compiler.internal.codegen.js.jx.PseudoCatchBlock;
import org.apache.royale.compiler.internal.codegen.js.jx.PseudoCatchParam;
import org.apache.royale.compiler.internal.codegen.js.jx.ReplacementCatchParam;
import org.apache.royale.compiler.internal.parsing.as.ASToken;
import org.apache.royale.compiler.internal.scopes.CatchScope;
import org.apache.royale.compiler.internal.semantics.PostProcessStep;
import org.apache.royale.compiler.internal.tree.as.BaseStatementNode;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorNodeBase;
import org.apache.royale.compiler.internal.tree.as.BlockNode;
import org.apache.royale.compiler.internal.tree.as.CatchNode;
import org.apache.royale.compiler.internal.tree.as.ConditionalNode;
import org.apache.royale.compiler.internal.tree.as.ExpressionNodeBase;
import org.apache.royale.compiler.internal.tree.as.IdentifierNode;
import org.apache.royale.compiler.internal.tree.as.IfNode;
import org.apache.royale.compiler.internal.tree.as.NodeBase;
import org.apache.royale.compiler.internal.tree.as.ParameterNode;
import org.apache.royale.compiler.internal.tree.as.TerminalNode;
import org.apache.royale.compiler.internal.tree.as.ThrowNode;
import org.apache.royale.compiler.parsing.IASToken;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.ICatchNode;
import org.apache.royale.compiler.tree.as.IContainerNode;
import org.apache.royale.compiler.tree.as.IScopedNode;
import org.apache.royale.compiler.tree.as.ITerminalNode;
import org.apache.royale.compiler.tree.as.ITryNode;

public class TryEmitter
extends JSSubEmitter
implements ISubEmitter<ITryNode> {
    public static final String ROYALE_MULTI_CATCH_ERROR_NAME = "$$royaleMultiCatchErr";
    private final EnumSet<PostProcessStep> postProcess = EnumSet.of(PostProcessStep.POPULATE_SCOPE);

    public TryEmitter(IJSEmitter emitter) {
        super(emitter);
    }

    @Override
    public void emit(ITryNode node) {
        ITerminalNode fnode;
        this.startMapping((ISourceLocation)node);
        this.writeToken(ASEmitterTokens.TRY);
        this.endMapping((ISourceLocation)node);
        this.getWalker().walk(node.getStatementContentsNode());
        if (node.getCatchNodeCount() >= 1) {
            if (node.getCatchNodeCount() == 1) {
                this.getWalker().walk((IASNode)node.getCatchNode(0));
            } else {
                this.getWalker().walk((IASNode)this.codeGenMultipleCatchSupport(node));
            }
        }
        if ((fnode = node.getFinallyNode()) != null) {
            this.startMapping((ISourceLocation)fnode);
            this.write(ASEmitterTokens.SPACE);
            this.writeToken(ASEmitterTokens.FINALLY);
            this.endMapping((ISourceLocation)fnode);
            this.getWalker().walk((IASNode)fnode);
        }
    }

    private ICatchNode codeGenMultipleCatchSupport(ITryNode node) {
        int catchCount = node.getCatchNodeCount();
        boolean hasCatchAll = false;
        IdentifierNode royaleErr = new IdentifierNode(ROYALE_MULTI_CATCH_ERROR_NAME);
        IdentifierNode ErrorClassIdentifier = new IdentifierNode("Error");
        ParameterNode argumentNode = new ParameterNode(royaleErr, (ExpressionNodeBase)ErrorClassIdentifier);
        argumentNode.addChild((NodeBase)royaleErr);
        argumentNode.addChild((NodeBase)royaleErr);
        CatchNode wrapper = new CatchNode(argumentNode);
        wrapper.setParent((NodeBase)node);
        argumentNode.setParent((NodeBase)wrapper);
        BlockNode wrapperBlock = wrapper.getContentsNode();
        wrapperBlock.setContainerType(IContainerNode.ContainerType.BRACES);
        wrapperBlock.setParent((NodeBase)wrapper);
        wrapper.setSourcePath(node.getSourcePath());
        wrapper.setLine(node.getEndLine());
        wrapper.setEndLine(node.getEndLine());
        wrapper.setColumn(node.getEndColumn() + 1);
        wrapper.setEndColumn(node.getEndColumn() + 1);
        IfNode ifNode = new IfNode(null);
        for (int i = 0; i < catchCount; ++i) {
            TerminalNode rewrittenCatch;
            ICatchNode childCatch = node.getCatchNode(i);
            int childChildren = childCatch.getStatementContentsNode().getChildCount();
            ParameterNode catchParam = (ParameterNode)childCatch.getCatchParameterNode();
            if (catchParam.getTypeNode().resolve(this.getProject()).equals(this.getProject().getBuiltinType(IASLanguageConstants.BuiltinType.ANY_TYPE))) {
                hasCatchAll = true;
                if (i == 0) {
                    return childCatch;
                }
            }
            if (hasCatchAll) {
                TerminalNode terminalNode = this.createTerminalCatchAllNode(catchParam, royaleErr, (CatchNode)childCatch);
                ifNode.addBranch(terminalNode);
                rewrittenCatch = terminalNode;
            } else {
                ConditionalNode conditionalNode = this.createConditionalNode(catchParam, royaleErr, (CatchNode)childCatch);
                ifNode.addBranch(conditionalNode);
                conditionalNode.setSourceLocation((ISourceLocation)childCatch);
                rewrittenCatch = conditionalNode;
            }
            for (int j = 0; j < childChildren; ++j) {
                rewrittenCatch.getContentsNode().addChild((NodeBase)childCatch.getStatementContentsNode().getChild(j));
            }
            if (hasCatchAll) break;
        }
        if (!hasCatchAll) {
            TerminalNode terminalNode = this.createTerminalThrowNode(royaleErr);
            ifNode.addBranch(terminalNode);
        }
        wrapperBlock.addChild((NodeBase)ifNode);
        wrapper.runPostProcess(this.postProcess, ((NodeBase)node).getASScope());
        return wrapper;
    }

    private void addVarStartToRewrittenCatch(ParameterNode parameterNode, IdentifierNode assignedValue, BaseStatementNode parentNode, PseudoCatchBlock content, CatchNode originalCatch) {
        content.setParent((NodeBase)parentNode);
        content.setContainerType(IContainerNode.ContainerType.BRACES);
        content.setSourceLocation((ISourceLocation)originalCatch.getContentsNode());
        IdentifierNode name = new IdentifierNode(parameterNode.getName());
        name.setSourceLocation((ISourceLocation)parameterNode.getNameExpressionNode());
        ExpressionNodeBase type = parameterNode.getTypeNode().copyForInitializer((IScopedNode)originalCatch);
        ReplacementCatchParam varNode = new ReplacementCatchParam(name, type);
        varNode.setAssignedValue(null, (ExpressionNodeBase)assignedValue);
        content.addChild((NodeBase)varNode);
    }

    private ConditionalNode createConditionalNode(ParameterNode parameterNode, IdentifierNode hoistedError, CatchNode originalCatch) {
        PseudoCatchParam conditionalNode = new PseudoCatchParam((CatchScope)originalCatch.getScope());
        BinaryOperatorNodeBase check = this.getEmitter().getGeneratedTypeCheck((ExpressionNodeBase)hoistedError, parameterNode.getTypeNode());
        check.setSourceLocation((ISourceLocation)parameterNode);
        conditionalNode.setConditionalExpression((ExpressionNodeBase)check);
        check.setParent((NodeBase)conditionalNode);
        this.addVarStartToRewrittenCatch(parameterNode, hoistedError, (BaseStatementNode)conditionalNode, (PseudoCatchBlock)conditionalNode.getContentsNode(), originalCatch);
        return conditionalNode;
    }

    private TerminalNode createTerminalThrowNode(IdentifierNode hoistedError) {
        TerminalNode terminalNode = new TerminalNode((IASToken)TryEmitter.getElseToken());
        ThrowNode throwNode = new ThrowNode(null);
        IdentifierNode localCopy = new IdentifierNode(hoistedError.getName());
        localCopy.setSourceLocation((ISourceLocation)hoistedError);
        throwNode.setStatementExpression((ExpressionNodeBase)localCopy);
        BlockNode contents = terminalNode.getContentsNode();
        contents.setContainerType(IContainerNode.ContainerType.BRACES);
        contents.setParent((NodeBase)terminalNode);
        contents.addChild((NodeBase)throwNode);
        return terminalNode;
    }

    private TerminalNode createTerminalCatchAllNode(ParameterNode parameterNode, IdentifierNode hoistedError, CatchNode originalCatch) {
        PseudoCatchAllParam terminalNode = new PseudoCatchAllParam((CatchScope)originalCatch.getScope());
        this.addVarStartToRewrittenCatch(parameterNode, hoistedError, (BaseStatementNode)terminalNode, (PseudoCatchBlock)terminalNode.getContentsNode(), originalCatch);
        terminalNode.setSourceLocation((ISourceLocation)originalCatch);
        return terminalNode;
    }

    static ASToken getElseToken() {
        return new ASToken(67, -1, -1, -1, -1, (CharSequence)"else");
    }
}

