/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.InvalidatingTypes;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.ObjectType;
import java.util.HashMap;
import java.util.Map;

final class InlineProperties
implements CompilerPass {
    private final AbstractCompiler compiler;
    private static final PropertyInfo INVALIDATED = new PropertyInfo(null, null);
    private final Map<String, PropertyInfo> props = new HashMap<String, PropertyInfo>();
    private final InvalidatingTypes invalidatingTypes;

    InlineProperties(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.invalidatingTypes = new InvalidatingTypes.Builder(compiler.getTypeRegistry()).disallowGlobalThis().addTypesInvalidForPropertyRenaming().addAllTypeMismatches(compiler.getTypeMismatches()).build();
        this.invalidateExternProperties();
    }

    private void invalidateExternProperties() {
        for (String name : this.compiler.getExternProperties()) {
            this.props.put(name, INVALIDATED);
        }
    }

    private JSType getJSType(Node n) {
        JSType type = n.getJSType();
        if (type == null) {
            return this.compiler.getTypeRegistry().getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }
        return type;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, new GatherCandidates());
        NodeTraversal.traverse(this.compiler, root, new ReplaceCandidates());
    }

    class ReplaceCandidates
    extends NodeTraversal.AbstractPostOrderCallback {
        ReplaceCandidates() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isGetProp() && !NodeUtil.isLValue(n)) {
                Node target = n.getFirstChild();
                String propName = n.getLastChild().getString();
                PropertyInfo info = (PropertyInfo)InlineProperties.this.props.get(propName);
                if (info != null && info != INVALIDATED && this.isMatchingType(target, info.type)) {
                    Node replacement = info.value.cloneTree();
                    if (NodeUtil.mayHaveSideEffects(n.getFirstChild(), InlineProperties.this.compiler)) {
                        replacement = IR.comma(n.removeFirstChild(), replacement).srcref(n);
                    }
                    parent.replaceChild(n, replacement);
                    InlineProperties.this.compiler.reportChangeToEnclosingScope(replacement);
                }
            }
        }

        private boolean isMatchingType(Node n, JSType src) {
            src = src.restrictByNotNullOrUndefined();
            JSType dest = InlineProperties.this.getJSType(n).restrictByNotNullOrUndefined();
            if (InlineProperties.this.invalidatingTypes.isInvalidating(dest)) {
                return false;
            }
            if (dest.isConstructor() || src.isConstructor()) {
                return this.hasInPrototypeChain(dest.toMaybeFunctionType(), src.toMaybeFunctionType());
            }
            return dest.isSubtypeOf(src);
        }

        private boolean hasInPrototypeChain(FunctionType subCtor, FunctionType superCtor) {
            if (subCtor == null || superCtor == null) {
                return false;
            }
            for (ObjectType proto = subCtor; proto != null; proto = ((ObjectType)proto).getImplicitPrototype()) {
                if (proto != superCtor) continue;
                return true;
            }
            return false;
        }
    }

    class GatherCandidates
    extends NodeTraversal.AbstractPostOrderCallback {
        GatherCandidates() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            boolean invalidatingPropRef;
            String propName;
            if (n.isGetProp()) {
                propName = n.getLastChild().getString();
                invalidatingPropRef = parent.isAssign() ? !this.maybeRecordCandidateDefinition(t, n, parent) : (NodeUtil.isLValue(n) ? true : parent.isDelProp());
            } else if (n.isStringKey() && !n.getParent().isObjectPattern() || n.isGetterDef() || n.isSetterDef() || n.isMemberFunctionDef()) {
                propName = n.getString();
                invalidatingPropRef = true;
            } else {
                return;
            }
            if (invalidatingPropRef) {
                Preconditions.checkNotNull(propName);
                this.invalidateProperty(propName);
            }
        }

        private boolean maybeRecordCandidateDefinition(NodeTraversal t, Node n, Node parent) {
            JSType targetType;
            Preconditions.checkState(n.isGetProp() && parent.isAssign(), n);
            Node src = n.getFirstChild();
            String propName = n.getLastChild().getString();
            Node value = parent.getLastChild();
            if (src.isThis()) {
                if (this.inConstructor(t)) {
                    return this.maybeStoreCandidateValue(InlineProperties.this.getJSType(src), propName, value);
                }
                return false;
            }
            if (t.inGlobalHoistScope() && src.isGetProp() && src.getLastChild().getString().equals("prototype")) {
                JSType instanceType = this.maybeGetInstanceTypeFromPrototypeRef(src);
                if (instanceType != null) {
                    return this.maybeStoreCandidateValue(instanceType, propName, value);
                }
            } else if (t.inGlobalHoistScope() && (targetType = InlineProperties.this.getJSType(src)) != null && targetType.isConstructor()) {
                return this.maybeStoreCandidateValue(targetType, propName, value);
            }
            return false;
        }

        private JSType maybeGetInstanceTypeFromPrototypeRef(Node src) {
            JSType ownerType = InlineProperties.this.getJSType(src.getFirstChild());
            if (ownerType.isConstructor()) {
                FunctionType functionType = ownerType.toMaybeFunctionType();
                return functionType.getInstanceType();
            }
            return null;
        }

        private void invalidateProperty(String propName) {
            InlineProperties.this.props.put(propName, INVALIDATED);
        }

        private boolean maybeStoreCandidateValue(JSType type, String propName, Node value) {
            Preconditions.checkNotNull(value);
            if (!InlineProperties.this.props.containsKey(propName) && !InlineProperties.this.invalidatingTypes.isInvalidating(type) && NodeUtil.isImmutableValue(value) && NodeUtil.isExecutedExactlyOnce(value)) {
                InlineProperties.this.props.put(propName, new PropertyInfo(type, value));
                return true;
            }
            return false;
        }

        private boolean inConstructor(NodeTraversal t) {
            Node root = t.getEnclosingFunction();
            if (root == null) {
                return false;
            }
            return NodeUtil.isConstructor(root);
        }
    }

    private static class PropertyInfo {
        final JSType type;
        final Node value;

        PropertyInfo(JSType type, Node value) {
            this.type = type;
            this.value = value;
        }
    }
}

