/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.storage;

import com.alipay.sofa.jraft.rhea.metrics.KVMetrics;
import com.alipay.sofa.jraft.rhea.storage.CASEntry;
import com.alipay.sofa.jraft.rhea.storage.KVEntry;
import com.alipay.sofa.jraft.rhea.storage.KVIterator;
import com.alipay.sofa.jraft.rhea.storage.KVStoreClosure;
import com.alipay.sofa.jraft.rhea.storage.MetricsKVClosureAdapter;
import com.alipay.sofa.jraft.rhea.storage.NodeExecutor;
import com.alipay.sofa.jraft.rhea.storage.RawKVStore;
import com.alipay.sofa.jraft.rhea.util.concurrent.DistributedLock;
import com.codahale.metrics.Timer;
import java.util.List;

public class MetricsRawKVStore
implements RawKVStore {
    private final String regionId;
    private final RawKVStore rawKVStore;
    private final Timer timer;

    public MetricsRawKVStore(long regionId, RawKVStore rawKVStore) {
        this.regionId = String.valueOf(regionId);
        this.rawKVStore = rawKVStore;
        this.timer = KVMetrics.timer("rhea-rpc-request-timer", this.regionId);
    }

    @Override
    public KVIterator localIterator() {
        return this.rawKVStore.localIterator();
    }

    @Override
    public void get(byte[] key, KVStoreClosure closure) {
        this.get(key, true, closure);
    }

    @Override
    public void get(byte[] key, boolean readOnlySafe, KVStoreClosure closure) {
        MetricsKVClosureAdapter c = this.metricsAdapter(closure, (byte)10, 1L, 0L);
        this.rawKVStore.get(key, readOnlySafe, c);
    }

    @Override
    public void multiGet(List<byte[]> keys, KVStoreClosure closure) {
        this.multiGet(keys, true, closure);
    }

    @Override
    public void multiGet(List<byte[]> keys, boolean readOnlySafe, KVStoreClosure closure) {
        MetricsKVClosureAdapter c = this.metricsAdapter(closure, (byte)11, keys.size(), 0L);
        this.rawKVStore.multiGet(keys, readOnlySafe, c);
    }

    @Override
    public void containsKey(byte[] key, KVStoreClosure closure) {
        MetricsKVClosureAdapter c = this.metricsAdapter(closure, (byte)19, 1L, 0L);
        this.rawKVStore.containsKey(key, c);
    }

    @Override
    public void scan(byte[] startKey, byte[] endKey, KVStoreClosure closure) {
        this.scan(startKey, endKey, Integer.MAX_VALUE, closure);
    }

    @Override
    public void scan(byte[] startKey, byte[] endKey, boolean readOnlySafe, KVStoreClosure closure) {
        this.scan(startKey, endKey, Integer.MAX_VALUE, readOnlySafe, closure);
    }

    @Override
    public void scan(byte[] startKey, byte[] endKey, boolean readOnlySafe, boolean returnValue, KVStoreClosure closure) {
        this.scan(startKey, endKey, Integer.MAX_VALUE, readOnlySafe, returnValue, closure);
    }

    @Override
    public void scan(byte[] startKey, byte[] endKey, int limit, KVStoreClosure closure) {
        this.scan(startKey, endKey, limit, true, closure);
    }

    @Override
    public void scan(byte[] startKey, byte[] endKey, int limit, boolean readOnlySafe, KVStoreClosure closure) {
        this.scan(startKey, endKey, limit, readOnlySafe, true, closure);
    }

    @Override
    public void scan(byte[] startKey, byte[] endKey, int limit, boolean readOnlySafe, boolean returnValue, KVStoreClosure closure) {
        MetricsKVClosureAdapter c = this.metricsAdapter(closure, (byte)12, 0L, 0L);
        this.rawKVStore.scan(startKey, endKey, limit, readOnlySafe, returnValue, c);
    }

    @Override
    public void reverseScan(byte[] startKey, byte[] endKey, KVStoreClosure closure) {
        this.reverseScan(startKey, endKey, Integer.MAX_VALUE, closure);
    }

    @Override
    public void reverseScan(byte[] startKey, byte[] endKey, boolean readOnlySafe, KVStoreClosure closure) {
        this.reverseScan(startKey, endKey, Integer.MAX_VALUE, readOnlySafe, closure);
    }

    @Override
    public void reverseScan(byte[] startKey, byte[] endKey, boolean readOnlySafe, boolean returnValue, KVStoreClosure closure) {
        this.reverseScan(startKey, endKey, Integer.MAX_VALUE, readOnlySafe, returnValue, closure);
    }

    @Override
    public void reverseScan(byte[] startKey, byte[] endKey, int limit, KVStoreClosure closure) {
        this.reverseScan(startKey, endKey, limit, true, closure);
    }

    @Override
    public void reverseScan(byte[] startKey, byte[] endKey, int limit, boolean readOnlySafe, KVStoreClosure closure) {
        this.reverseScan(startKey, endKey, limit, readOnlySafe, true, closure);
    }

    @Override
    public void reverseScan(byte[] startKey, byte[] endKey, int limit, boolean readOnlySafe, boolean returnValue, KVStoreClosure closure) {
        MetricsKVClosureAdapter c = this.metricsAdapter(closure, (byte)20, 0L, 0L);
        this.rawKVStore.reverseScan(startKey, endKey, limit, readOnlySafe, returnValue, c);
    }

    @Override
    public void getSequence(byte[] seqKey, int step, KVStoreClosure closure) {
        MetricsKVClosureAdapter c = this.metricsAdapter(closure, (byte)6, 1L, 8L);
        this.rawKVStore.getSequence(seqKey, step, c);
    }

    @Override
    public void resetSequence(byte[] seqKey, KVStoreClosure closure) {
        MetricsKVClosureAdapter c = this.metricsAdapter(closure, (byte)15, 1L, 0L);
        this.rawKVStore.resetSequence(seqKey, c);
    }

    @Override
    public void put(byte[] key, byte[] value, KVStoreClosure closure) {
        MetricsKVClosureAdapter c = this.metricsAdapter(closure, (byte)1, 1L, value.length);
        this.rawKVStore.put(key, value, c);
    }

    @Override
    public void getAndPut(byte[] key, byte[] value, KVStoreClosure closure) {
        MetricsKVClosureAdapter c = this.metricsAdapter(closure, (byte)13, 1L, value.length);
        this.rawKVStore.getAndPut(key, value, c);
    }

    @Override
    public void compareAndPut(byte[] key, byte[] expect, byte[] update, KVStoreClosure closure) {
        MetricsKVClosureAdapter c = this.metricsAdapter(closure, (byte)17, 1L, update.length);
        this.rawKVStore.compareAndPut(key, expect, update, c);
    }

    @Override
    public void merge(byte[] key, byte[] value, KVStoreClosure closure) {
        MetricsKVClosureAdapter c = this.metricsAdapter(closure, (byte)14, 1L, value.length);
        this.rawKVStore.merge(key, value, c);
    }

    @Override
    public void put(List<KVEntry> entries, KVStoreClosure closure) {
        long bytesWritten = 0L;
        for (KVEntry kvEntry : entries) {
            byte[] value = kvEntry.getValue();
            bytesWritten += (long)(value == null ? 0 : value.length);
        }
        MetricsKVClosureAdapter c = this.metricsAdapter(closure, (byte)4, entries.size(), bytesWritten);
        this.rawKVStore.put(entries, c);
    }

    @Override
    public void compareAndPutAll(List<CASEntry> entries, KVStoreClosure closure) {
        long bytesWritten = 0L;
        for (CASEntry casEntry : entries) {
            byte[] value = casEntry.getUpdate();
            bytesWritten += (long)(value == null ? 0 : value.length);
        }
        MetricsKVClosureAdapter c = this.metricsAdapter(closure, (byte)21, entries.size(), bytesWritten);
        this.rawKVStore.compareAndPutAll(entries, c);
    }

    @Override
    public void putIfAbsent(byte[] key, byte[] value, KVStoreClosure closure) {
        MetricsKVClosureAdapter c = this.metricsAdapter(closure, (byte)2, 1L, value.length);
        this.rawKVStore.putIfAbsent(key, value, c);
    }

    @Override
    public void tryLockWith(byte[] key, byte[] fencingKey, boolean keepLease, DistributedLock.Acquirer acquirer, KVStoreClosure closure) {
        MetricsKVClosureAdapter c = this.metricsAdapter(closure, (byte)8, 2L, 0L);
        this.rawKVStore.tryLockWith(key, fencingKey, keepLease, acquirer, c);
    }

    @Override
    public void releaseLockWith(byte[] key, DistributedLock.Acquirer acquirer, KVStoreClosure closure) {
        MetricsKVClosureAdapter c = this.metricsAdapter(closure, (byte)9, 2L, 0L);
        this.rawKVStore.releaseLockWith(key, acquirer, c);
    }

    @Override
    public void delete(byte[] key, KVStoreClosure closure) {
        MetricsKVClosureAdapter c = this.metricsAdapter(closure, (byte)3, 1L, 0L);
        this.rawKVStore.delete(key, (KVStoreClosure)c);
    }

    @Override
    public void deleteRange(byte[] startKey, byte[] endKey, KVStoreClosure closure) {
        MetricsKVClosureAdapter c = this.metricsAdapter(closure, (byte)5, 0L, 0L);
        this.rawKVStore.deleteRange(startKey, endKey, c);
    }

    @Override
    public void delete(List<byte[]> keys, KVStoreClosure closure) {
        MetricsKVClosureAdapter c = this.metricsAdapter(closure, (byte)18, keys.size(), 0L);
        this.rawKVStore.delete(keys, (KVStoreClosure)c);
    }

    @Override
    public void execute(NodeExecutor nodeExecutor, boolean isLeader, KVStoreClosure closure) {
        MetricsKVClosureAdapter c = this.metricsAdapter(closure, (byte)7, 0L, 0L);
        this.rawKVStore.execute(nodeExecutor, isLeader, c);
    }

    private MetricsKVClosureAdapter metricsAdapter(KVStoreClosure closure, byte op, long keysCount, long bytesWritten) {
        return new MetricsKVClosureAdapter(closure, this.regionId, op, keysCount, bytesWritten, this.timeCtx());
    }

    private Timer.Context timeCtx() {
        return this.timer.time();
    }
}

