/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.util;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderImplEnum;
import com.alibaba.fastjson2.reader.ObjectReaderImplInstant;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.util.DateUtils;
import com.alibaba.fastjson2.util.DoubleToDecimal;
import com.alibaba.fastjson2.util.FDBigInteger;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.JSONObject1O;
import com.alibaba.fastjson2.util.JdbcSupport;
import com.alibaba.fastjson2.util.ParameterizedTypeImpl;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterPrimitiveImpl;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.LongFunction;
import java.util.function.ObjIntConsumer;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;

public class TypeUtils {
    public static final Class CLASS_JSON_OBJECT_1x;
    public static final Field FIELD_JSON_OBJECT_1x_map;
    public static final Class CLASS_JSON_ARRAY_1x;
    public static final Class CLASS_SINGLE_SET;
    public static final Class CLASS_SINGLE_LIST;
    public static final Class CLASS_UNMODIFIABLE_COLLECTION;
    public static final Class CLASS_UNMODIFIABLE_LIST;
    public static final Class CLASS_UNMODIFIABLE_SET;
    public static final Class CLASS_UNMODIFIABLE_SORTED_SET;
    public static final Class CLASS_UNMODIFIABLE_NAVIGABLE_SET;
    public static final ParameterizedType PARAM_TYPE_LIST_STR;
    public static final MethodType METHOD_TYPE_SUPPLIER;
    public static final MethodType METHOD_TYPE_FUNCTION;
    public static final MethodType METHOD_TYPE_TO_INT_FUNCTION;
    public static final MethodType METHOD_TYPE_TO_LONG_FUNCTION;
    public static final MethodType METHOD_TYPE_OBJECT_INT_CONSUMER;
    public static final MethodType METHOD_TYPE_INT_FUNCTION;
    public static final MethodType METHOD_TYPE_LONG_FUNCTION;
    public static final MethodType METHOD_TYPE_BI_FUNCTION;
    public static final MethodType METHOD_TYPE_BI_CONSUMER;
    public static final MethodType METHOD_TYPE_VOO;
    public static final MethodType METHOD_TYPE_OBJECT;
    public static final MethodType METHOD_TYPE_OBJECT_OBJECT;
    public static final MethodType METHOD_TYPE_INT_OBJECT;
    public static final MethodType METHOD_TYPE_LONG_OBJECT;
    public static final MethodType METHOD_TYPE_VOID_OBJECT_INT;
    public static final MethodType METHOD_TYPE_OBJECT_LONG;
    public static final MethodType METHOD_TYPE_VOID_LONG;
    public static final MethodType METHOD_TYPE_OBJECT_OBJECT_OBJECT;
    public static final MethodType METHOD_TYPE_VOID;
    public static final MethodType METHOD_TYPE_VOID_INT;
    public static final MethodType METHOD_TYPE_VOID_STRING;
    public static final MethodType METHOD_TYPE_OBJECT_INT;
    public static final BigInteger BIGINT_INT32_MIN;
    public static final BigInteger BIGINT_INT32_MAX;
    public static final BigInteger BIGINT_INT64_MIN;
    public static final BigInteger BIGINT_INT64_MAX;
    static final long LONG_JAVASCRIPT_LOW = -9007199254740991L;
    static final long LONG_JAVASCRIPT_HIGH = 0x1FFFFFFFFFFFFFL;
    static final BigDecimal DECIMAL_JAVASCRIPT_LOW;
    static final BigDecimal DECIMAL_JAVASCRIPT_HIGH;
    static final BigInteger BIGINT_JAVASCRIPT_LOW;
    static final BigInteger BIGINT_JAVASCRIPT_HIGH;
    public static final double[] SMALL_10_POW;
    static final float[] SINGLE_SMALL_10_POW;
    static final double[] BIG_10_POW;
    static final double[] TINY_10_POW;
    static volatile boolean METHOD_NEW_PROXY_INSTANCE_ERROR;
    static volatile MethodHandle METHOD_NEW_PROXY_INSTANCE;
    static final Cache CACHE;
    static final AtomicReferenceFieldUpdater<Cache, char[]> CHARS_UPDATER;
    static final Map<Class, String> NAME_MAPPINGS;
    static final Map<String, Class> TYPE_MAPPINGS;
    private static final BigInteger[] BIG_TEN_POWERS_TABLE;

    public static <T> T newProxyInstance(Class<T> objectClass, JSONObject object) {
        MethodHandle newProxyInstance = METHOD_NEW_PROXY_INSTANCE;
        try {
            if (newProxyInstance == null) {
                Class<?> proxyClass = Class.forName("java.lang.reflect.Proxy");
                MethodHandles.Lookup lookup = JDKUtils.trustedLookup(proxyClass);
                METHOD_NEW_PROXY_INSTANCE = newProxyInstance = lookup.findStatic(proxyClass, "newProxyInstance", MethodType.methodType(Object.class, ClassLoader.class, Class[].class, InvocationHandler.class));
            }
        }
        catch (Throwable ignored) {
            METHOD_NEW_PROXY_INSTANCE_ERROR = true;
        }
        try {
            return (T)newProxyInstance.invokeExact(objectClass.getClassLoader(), new Class[]{objectClass}, object);
        }
        catch (Throwable e) {
            throw new JSONException("create proxy error : " + objectClass, e);
        }
    }

    static char[] toAsciiCharArray(byte[] bytes) {
        char[] charArray = new char[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            charArray[i] = (char)bytes[i];
        }
        return charArray;
    }

    public static String toString(char ch) {
        if (ch < X2.chars.length) {
            return X2.chars[ch];
        }
        return Character.toString(ch);
    }

    public static String toString(byte ch) {
        if (ch >= 0 && ch < X2.chars.length) {
            return X2.chars[ch];
        }
        return new String(new byte[]{ch}, StandardCharsets.ISO_8859_1);
    }

    public static String toString(char c0, char c1) {
        if (c0 >= ' ' && c0 <= '~' && c1 >= ' ' && c1 <= '~') {
            int value = (c0 - 32) * 95 + (c1 - 32);
            return X2.chars2[value];
        }
        return new String(new char[]{c0, c1});
    }

    public static String toString(byte c0, byte c1) {
        if (c0 >= 32 && c0 <= 126 && c1 >= 32 && c1 <= 126) {
            int value = (c0 - 32) * 95 + (c1 - 32);
            return X2.chars2[value];
        }
        return new String(new byte[]{c0, c1}, StandardCharsets.ISO_8859_1);
    }

    public static Type intern(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            Type rawType = paramType.getRawType();
            Type[] actualTypeArguments = paramType.getActualTypeArguments();
            if (rawType == List.class && actualTypeArguments.length == 1 && actualTypeArguments[0] == String.class) {
                return PARAM_TYPE_LIST_STR;
            }
        }
        return type;
    }

    public static double parseDouble(byte[] in, int off, int len) throws NumberFormatException {
        block30: {
            boolean isNegative = false;
            boolean signSeen = false;
            int end = off + len;
            try {
                boolean isZero;
                byte c;
                if (len == 0) {
                    throw new NumberFormatException("empty String");
                }
                int i = off;
                switch (in[i]) {
                    case 45: {
                        isNegative = true;
                    }
                    case 43: {
                        ++i;
                        signSeen = true;
                    }
                }
                char[] digits = new char[len];
                int nDigits = 0;
                boolean decSeen = false;
                int decPt = 0;
                int nLeadZero = 0;
                int nTrailZero = 0;
                while (i < end) {
                    c = in[i];
                    if (c == 48) {
                        ++nLeadZero;
                    } else {
                        if (c != 46) break;
                        if (decSeen) {
                            throw new NumberFormatException("multiple points");
                        }
                        decPt = i - off;
                        if (signSeen) {
                            --decPt;
                        }
                        decSeen = true;
                    }
                    ++i;
                }
                while (i < end) {
                    c = in[i];
                    if (c >= 49 && c <= 57) {
                        digits[nDigits++] = (char)c;
                        nTrailZero = 0;
                    } else if (c == 48) {
                        digits[nDigits++] = (char)c;
                        ++nTrailZero;
                    } else {
                        if (c != 46) break;
                        if (decSeen) {
                            throw new NumberFormatException("multiple points");
                        }
                        decPt = i - off;
                        if (signSeen) {
                            --decPt;
                        }
                        decSeen = true;
                    }
                    ++i;
                }
                boolean bl = isZero = (nDigits -= nTrailZero) == 0;
                if (isZero && nLeadZero == 0) break block30;
                int decExp = decSeen ? decPt - nLeadZero : nDigits + nTrailZero;
                if (i < end && ((c = in[i]) == 101 || c == 69)) {
                    int expSign = 1;
                    int expVal = 0;
                    int reallyBig = 0xCCCCCCC;
                    boolean expOverflow = false;
                    switch (in[++i]) {
                        case 45: {
                            expSign = -1;
                        }
                        case 43: {
                            ++i;
                        }
                    }
                    int expAt = i;
                    while (i < end) {
                        if (expVal >= reallyBig) {
                            expOverflow = true;
                        }
                        if ((c = in[i++]) >= 48 && c <= 57) {
                            expVal = expVal * 10 + (c - 48);
                            continue;
                        }
                        --i;
                        break;
                    }
                    int BIG_DECIMAL_EXPONENT = 324;
                    int expLimit = 324 + nDigits + nTrailZero;
                    decExp = expOverflow || expVal > expLimit ? expSign * expLimit : (decExp += expSign * expVal);
                    if (i == expAt) break block30;
                }
                if (i >= end || i == end - 1) {
                    if (isZero) {
                        return 0.0;
                    }
                    return TypeUtils.doubleValue(isNegative, decExp, digits, nDigits);
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        throw new NumberFormatException("For input string: \"" + new String(in, off, len) + "\"");
    }

    public static double parseDouble(char[] in, int off, int len) throws NumberFormatException {
        block30: {
            boolean isNegative = false;
            boolean signSeen = false;
            int end = off + len;
            try {
                boolean isZero;
                char c;
                if (len == 0) {
                    throw new NumberFormatException("empty String");
                }
                int i = off;
                switch (in[i]) {
                    case '-': {
                        isNegative = true;
                    }
                    case '+': {
                        ++i;
                        signSeen = true;
                    }
                }
                char[] digits = new char[len];
                int nDigits = 0;
                boolean decSeen = false;
                int decPt = 0;
                int nLeadZero = 0;
                int nTrailZero = 0;
                while (i < end) {
                    c = in[i];
                    if (c == '0') {
                        ++nLeadZero;
                    } else {
                        if (c != '.') break;
                        if (decSeen) {
                            throw new NumberFormatException("multiple points");
                        }
                        decPt = i - off;
                        if (signSeen) {
                            --decPt;
                        }
                        decSeen = true;
                    }
                    ++i;
                }
                while (i < end) {
                    c = in[i];
                    if (c >= '1' && c <= '9') {
                        digits[nDigits++] = c;
                        nTrailZero = 0;
                    } else if (c == '0') {
                        digits[nDigits++] = c;
                        ++nTrailZero;
                    } else {
                        if (c != '.') break;
                        if (decSeen) {
                            throw new NumberFormatException("multiple points");
                        }
                        decPt = i - off;
                        if (signSeen) {
                            --decPt;
                        }
                        decSeen = true;
                    }
                    ++i;
                }
                boolean bl = isZero = (nDigits -= nTrailZero) == 0;
                if (isZero && nLeadZero == 0) break block30;
                int decExp = decSeen ? decPt - nLeadZero : nDigits + nTrailZero;
                if (i < end && ((c = in[i]) == 'e' || c == 'E')) {
                    int expSign = 1;
                    int expVal = 0;
                    int reallyBig = 0xCCCCCCC;
                    boolean expOverflow = false;
                    switch (in[++i]) {
                        case '-': {
                            expSign = -1;
                        }
                        case '+': {
                            ++i;
                        }
                    }
                    int expAt = i;
                    while (i < end) {
                        if (expVal >= reallyBig) {
                            expOverflow = true;
                        }
                        if ((c = in[i++]) >= '0' && c <= '9') {
                            expVal = expVal * 10 + (c - 48);
                            continue;
                        }
                        --i;
                        break;
                    }
                    int BIG_DECIMAL_EXPONENT = 324;
                    int expLimit = 324 + nDigits + nTrailZero;
                    decExp = expOverflow || expVal > expLimit ? expSign * expLimit : (decExp += expSign * expVal);
                    if (i == expAt) break block30;
                }
                if (i >= end || i == end - 1) {
                    if (isZero) {
                        return 0.0;
                    }
                    return TypeUtils.doubleValue(isNegative, decExp, digits, nDigits);
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        throw new NumberFormatException("For input string: \"" + new String(in, off, len) + "\"");
    }

    public static float parseFloat(byte[] in, int off, int len) throws NumberFormatException {
        block30: {
            boolean isNegative = false;
            boolean signSeen = false;
            int end = off + len;
            try {
                boolean isZero;
                byte c;
                if (len == 0) {
                    throw new NumberFormatException("empty String");
                }
                int i = off;
                switch (in[i]) {
                    case 45: {
                        isNegative = true;
                    }
                    case 43: {
                        ++i;
                        signSeen = true;
                    }
                }
                char[] digits = new char[len];
                int nDigits = 0;
                boolean decSeen = false;
                int decPt = 0;
                int nLeadZero = 0;
                int nTrailZero = 0;
                while (i < end) {
                    c = in[i];
                    if (c == 48) {
                        ++nLeadZero;
                    } else {
                        if (c != 46) break;
                        if (decSeen) {
                            throw new NumberFormatException("multiple points");
                        }
                        decPt = i - off;
                        if (signSeen) {
                            --decPt;
                        }
                        decSeen = true;
                    }
                    ++i;
                }
                while (i < end) {
                    c = in[i];
                    if (c >= 49 && c <= 57) {
                        digits[nDigits++] = (char)c;
                        nTrailZero = 0;
                    } else if (c == 48) {
                        digits[nDigits++] = (char)c;
                        ++nTrailZero;
                    } else {
                        if (c != 46) break;
                        if (decSeen) {
                            throw new NumberFormatException("multiple points");
                        }
                        decPt = i - off;
                        if (signSeen) {
                            --decPt;
                        }
                        decSeen = true;
                    }
                    ++i;
                }
                boolean bl = isZero = (nDigits -= nTrailZero) == 0;
                if (isZero && nLeadZero == 0) break block30;
                int decExp = decSeen ? decPt - nLeadZero : nDigits + nTrailZero;
                if (i < end && ((c = in[i]) == 101 || c == 69)) {
                    int expSign = 1;
                    int expVal = 0;
                    int reallyBig = 0xCCCCCCC;
                    boolean expOverflow = false;
                    switch (in[++i]) {
                        case 45: {
                            expSign = -1;
                        }
                        case 43: {
                            ++i;
                        }
                    }
                    int expAt = i;
                    while (i < end) {
                        if (expVal >= reallyBig) {
                            expOverflow = true;
                        }
                        if ((c = in[i++]) >= 48 && c <= 57) {
                            expVal = expVal * 10 + (c - 48);
                            continue;
                        }
                        --i;
                        break;
                    }
                    int BIG_DECIMAL_EXPONENT = 324;
                    int expLimit = 324 + nDigits + nTrailZero;
                    decExp = expOverflow || expVal > expLimit ? expSign * expLimit : (decExp += expSign * expVal);
                    if (i == expAt) break block30;
                }
                if (i >= end || i == end - 1) {
                    if (isZero) {
                        return 0.0f;
                    }
                    return TypeUtils.floatValue(isNegative, decExp, digits, nDigits);
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        throw new NumberFormatException("For input string: \"" + new String(in, off, len) + "\"");
    }

    public static float parseFloat(char[] in, int off, int len) throws NumberFormatException {
        block30: {
            boolean isNegative = false;
            boolean signSeen = false;
            int end = off + len;
            try {
                boolean isZero;
                char c;
                if (len == 0) {
                    throw new NumberFormatException("empty String");
                }
                int i = off;
                switch (in[i]) {
                    case '-': {
                        isNegative = true;
                    }
                    case '+': {
                        ++i;
                        signSeen = true;
                    }
                }
                char[] digits = new char[len];
                int nDigits = 0;
                boolean decSeen = false;
                int decPt = 0;
                int nLeadZero = 0;
                int nTrailZero = 0;
                while (i < end) {
                    c = in[i];
                    if (c == '0') {
                        ++nLeadZero;
                    } else {
                        if (c != '.') break;
                        if (decSeen) {
                            throw new NumberFormatException("multiple points");
                        }
                        decPt = i - off;
                        if (signSeen) {
                            --decPt;
                        }
                        decSeen = true;
                    }
                    ++i;
                }
                while (i < end) {
                    c = in[i];
                    if (c >= '1' && c <= '9') {
                        digits[nDigits++] = c;
                        nTrailZero = 0;
                    } else if (c == '0') {
                        digits[nDigits++] = c;
                        ++nTrailZero;
                    } else {
                        if (c != '.') break;
                        if (decSeen) {
                            throw new NumberFormatException("multiple points");
                        }
                        decPt = i - off;
                        if (signSeen) {
                            --decPt;
                        }
                        decSeen = true;
                    }
                    ++i;
                }
                boolean bl = isZero = (nDigits -= nTrailZero) == 0;
                if (isZero && nLeadZero == 0) break block30;
                int decExp = decSeen ? decPt - nLeadZero : nDigits + nTrailZero;
                if (i < end && ((c = in[i]) == 'e' || c == 'E')) {
                    int expSign = 1;
                    int expVal = 0;
                    int reallyBig = 0xCCCCCCC;
                    boolean expOverflow = false;
                    switch (in[++i]) {
                        case '-': {
                            expSign = -1;
                        }
                        case '+': {
                            ++i;
                        }
                    }
                    int expAt = i;
                    while (i < end) {
                        if (expVal >= reallyBig) {
                            expOverflow = true;
                        }
                        if ((c = in[i++]) >= '0' && c <= '9') {
                            expVal = expVal * 10 + (c - 48);
                            continue;
                        }
                        --i;
                        break;
                    }
                    int BIG_DECIMAL_EXPONENT = 324;
                    int expLimit = 324 + nDigits + nTrailZero;
                    decExp = expOverflow || expVal > expLimit ? expSign * expLimit : (decExp += expSign * expVal);
                    if (i == expAt) break block30;
                }
                if (i >= end || i == end - 1) {
                    if (isZero) {
                        return 0.0f;
                    }
                    return TypeUtils.floatValue(isNegative, decExp, digits, nDigits);
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        throw new NumberFormatException("For input string: \"" + new String(in, off, len) + "\"");
    }

    public static double doubleValue(boolean isNegative, int decExp, char[] digits, int nDigits) {
        long l;
        double t;
        int j;
        int MAX_DECIMAL_EXPONENT = 308;
        int MIN_DECIMAL_EXPONENT = -324;
        int MAX_NDIGITS = 1100;
        int INT_DECIMAL_DIGITS = 9;
        int MAX_DECIMAL_DIGITS = 15;
        int DOUBLE_EXP_BIAS = 1023;
        int EXP_SHIFT = 52;
        long FRACT_HOB = 0x10000000000000L;
        int MAX_SMALL_TEN = SMALL_10_POW.length - 1;
        int SINGLE_MAX_SMALL_TEN = SINGLE_SMALL_10_POW.length - 1;
        int kDigits = Math.min(nDigits, 16);
        int iValue = digits[0] - 48;
        int iDigits = Math.min(kDigits, 9);
        for (int i = 1; i < iDigits; ++i) {
            iValue = iValue * 10 + digits[i] - 48;
        }
        long lValue = iValue;
        for (int i = iDigits; i < kDigits; ++i) {
            lValue = lValue * 10L + (long)(digits[i] - 48);
        }
        double dValue = lValue;
        int exp = decExp - kDigits;
        if (nDigits <= 15) {
            if (exp == 0 || dValue == 0.0) {
                return isNegative ? -dValue : dValue;
            }
            if (exp >= 0) {
                if (exp <= MAX_SMALL_TEN) {
                    double rValue = dValue * SMALL_10_POW[exp];
                    return isNegative ? -rValue : rValue;
                }
                int slop = 15 - kDigits;
                if (exp <= MAX_SMALL_TEN + slop) {
                    double rValue = (dValue *= SMALL_10_POW[slop]) * SMALL_10_POW[exp - slop];
                    return isNegative ? -rValue : rValue;
                }
            } else if (exp >= -MAX_SMALL_TEN) {
                double rValue = dValue / SMALL_10_POW[-exp];
                return isNegative ? -rValue : rValue;
            }
        }
        if (exp > 0) {
            if (decExp > 309) {
                return isNegative ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            if ((exp & 0xF) != 0) {
                dValue *= SMALL_10_POW[exp & 0xF];
            }
            if ((exp >>= 4) != 0) {
                j = 0;
                while (exp > 1) {
                    if ((exp & 1) != 0) {
                        dValue *= BIG_10_POW[j];
                    }
                    ++j;
                    exp >>= 1;
                }
                t = dValue * BIG_10_POW[j];
                if (Double.isInfinite(t)) {
                    t = dValue / 2.0;
                    if (Double.isInfinite(t *= BIG_10_POW[j])) {
                        return isNegative ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
                    }
                    t = Double.MAX_VALUE;
                }
                dValue = t;
            }
        } else if (exp < 0) {
            exp = -exp;
            if (decExp < -325) {
                return isNegative ? -0.0 : 0.0;
            }
            if ((exp & 0xF) != 0) {
                dValue /= SMALL_10_POW[exp & 0xF];
            }
            if ((exp >>= 4) != 0) {
                j = 0;
                while (exp > 1) {
                    if ((exp & 1) != 0) {
                        dValue *= TINY_10_POW[j];
                    }
                    ++j;
                    exp >>= 1;
                }
                t = dValue * TINY_10_POW[j];
                if (t == 0.0) {
                    t = dValue * 2.0;
                    if ((t *= TINY_10_POW[j]) == 0.0) {
                        return isNegative ? -0.0 : 0.0;
                    }
                    t = Double.MIN_VALUE;
                }
                dValue = t;
            }
        }
        if (nDigits > 1100) {
            nDigits = 1101;
            digits[1100] = 49;
        }
        FDBigInteger bigD0 = new FDBigInteger(lValue, digits, kDigits, nDigits);
        exp = decExp - nDigits;
        long ieeeBits = Double.doubleToRawLongBits(dValue);
        int B5 = Math.max(0, -exp);
        int D5 = Math.max(0, exp);
        bigD0 = bigD0.multByPow52(D5, 0);
        bigD0.makeImmutable();
        FDBigInteger bigD = null;
        int prevD2 = 0;
        do {
            FDBigInteger diff;
            boolean overvalue;
            int cmpResult;
            int binexp = (int)(ieeeBits >>> 52);
            long DOUBLE_SIGNIF_BIT_MASK = 0xFFFFFFFFFFFFFL;
            long bigBbits = ieeeBits & 0xFFFFFFFFFFFFFL;
            if (binexp > 0) {
                bigBbits |= 0x10000000000000L;
            } else {
                assert (bigBbits != 0L) : bigBbits;
                int leadingZeros = Long.numberOfLeadingZeros(bigBbits);
                int shift = leadingZeros - 11;
                bigBbits <<= shift;
                binexp = 1 - shift;
            }
            int lowOrderZeros = Long.numberOfTrailingZeros(bigBbits);
            bigBbits >>>= lowOrderZeros;
            int bigIntExp = (binexp -= 1023) - 52 + lowOrderZeros;
            int bigIntNBits = 53 - lowOrderZeros;
            int B2 = B5;
            int D2 = D5;
            if (bigIntExp >= 0) {
                B2 += bigIntExp;
            } else {
                D2 -= bigIntExp;
            }
            int Ulp2 = B2;
            int hulpbias = binexp <= -1023 ? binexp + lowOrderZeros + 1023 : 1 + lowOrderZeros;
            int common2 = Math.min(B2 += hulpbias, Math.min(D2 += hulpbias, Ulp2));
            Ulp2 -= common2;
            FDBigInteger bigB = FDBigInteger.valueOfMulPow52(bigBbits, B5, B2 -= common2);
            if (bigD == null || prevD2 != (D2 -= common2)) {
                bigD = bigD0.leftShift(D2);
                prevD2 = D2;
            }
            if ((cmpResult = bigB.cmp(bigD)) > 0) {
                overvalue = true;
                diff = bigB.leftInplaceSub(bigD);
                if (bigIntNBits == 1 && bigIntExp > -1022 && --Ulp2 < 0) {
                    Ulp2 = 0;
                    diff = diff.leftShift(1);
                }
            } else {
                if (cmpResult >= 0) break;
                overvalue = false;
                diff = bigD.rightInplaceSub(bigB);
            }
            if ((cmpResult = diff.cmpPow52(B5, Ulp2)) < 0) break;
            if (cmpResult == 0) {
                if ((ieeeBits & 1L) == 0L) break;
                ieeeBits += overvalue ? -1L : 1L;
                break;
            }
            l = overvalue ? -1L : 1L;
            long DOUBLE_EXP_BIT_MASK = 0x7FF0000000000000L;
        } while ((ieeeBits += l) != 0L && ieeeBits != 0x7FF0000000000000L);
        if (isNegative) {
            long DOUBLE_SIGN_BIT_MASK = Long.MIN_VALUE;
            ieeeBits |= Long.MIN_VALUE;
        }
        return Double.longBitsToDouble(ieeeBits);
    }

    public static float floatValue(boolean isNegative, int decExponent, char[] digits, int nDigits) {
        int n;
        int j;
        int SINGLE_MAX_NDIGITS = 200;
        int SINGLE_MAX_DECIMAL_DIGITS = 7;
        int MAX_DECIMAL_DIGITS = 15;
        int FLOAT_EXP_BIAS = 127;
        int SINGLE_EXP_SHIFT = 23;
        int SINGLE_MAX_SMALL_TEN = SINGLE_SMALL_10_POW.length - 1;
        int kDigits = Math.min(nDigits, 8);
        int iValue = digits[0] - 48;
        for (int i = 1; i < kDigits; ++i) {
            iValue = iValue * 10 + digits[i] - 48;
        }
        float fValue = iValue;
        int exp = decExponent - kDigits;
        if (nDigits <= 7) {
            if (exp == 0 || fValue == 0.0f) {
                return isNegative ? -fValue : fValue;
            }
            if (exp >= 0) {
                if (exp <= SINGLE_MAX_SMALL_TEN) {
                    return isNegative ? -fValue : (fValue *= SINGLE_SMALL_10_POW[exp]);
                }
                int slop = 7 - kDigits;
                if (exp <= SINGLE_MAX_SMALL_TEN + slop) {
                    fValue *= SINGLE_SMALL_10_POW[slop];
                    return isNegative ? -fValue : (fValue *= SINGLE_SMALL_10_POW[exp - slop]);
                }
            } else if (exp >= -SINGLE_MAX_SMALL_TEN) {
                return isNegative ? -fValue : (fValue /= SINGLE_SMALL_10_POW[-exp]);
            }
        } else if (decExponent >= nDigits && nDigits + decExponent <= 15) {
            long lValue = iValue;
            for (int i = kDigits; i < nDigits; ++i) {
                lValue = lValue * 10L + (long)(digits[i] - 48);
            }
            double dValue = lValue;
            exp = decExponent - nDigits;
            fValue = (float)(dValue *= SMALL_10_POW[exp]);
            return isNegative ? -fValue : fValue;
        }
        double dValue = fValue;
        if (exp > 0) {
            int SINGLE_MAX_DECIMAL_EXPONENT = 38;
            if (decExponent > 39) {
                return isNegative ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY;
            }
            if ((exp & 0xF) != 0) {
                dValue *= SMALL_10_POW[exp & 0xF];
            }
            if ((exp >>= 4) != 0) {
                j = 0;
                while (exp > 0) {
                    if ((exp & 1) != 0) {
                        dValue *= BIG_10_POW[j];
                    }
                    ++j;
                    exp >>= 1;
                }
            }
        } else if (exp < 0) {
            exp = -exp;
            int SINGLE_MIN_DECIMAL_EXPONENT = -45;
            if (decExponent < -46) {
                return isNegative ? -0.0f : 0.0f;
            }
            if ((exp & 0xF) != 0) {
                dValue /= SMALL_10_POW[exp & 0xF];
            }
            if ((exp >>= 4) != 0) {
                j = 0;
                while (exp > 0) {
                    if ((exp & 1) != 0) {
                        dValue *= TINY_10_POW[j];
                    }
                    ++j;
                    exp >>= 1;
                }
            }
        }
        fValue = Math.max(Float.MIN_VALUE, Math.min(Float.MAX_VALUE, (float)dValue));
        if (nDigits > 200) {
            nDigits = 201;
            digits[200] = 49;
        }
        FDBigInteger bigD0 = new FDBigInteger(iValue, digits, kDigits, nDigits);
        exp = decExponent - nDigits;
        int ieeeBits = Float.floatToRawIntBits(fValue);
        int B5 = Math.max(0, -exp);
        int D5 = Math.max(0, exp);
        bigD0 = bigD0.multByPow52(D5, 0);
        bigD0.makeImmutable();
        FDBigInteger bigD = null;
        int prevD2 = 0;
        do {
            FDBigInteger diff;
            boolean overvalue;
            int cmpResult;
            int binexp = ieeeBits >>> 23;
            int FLOAT_SIGNIF_BIT_MASK = 0x7FFFFF;
            int bigBbits = ieeeBits & 0x7FFFFF;
            if (binexp > 0) {
                int SINGLE_FRACT_HOB = 0x800000;
                bigBbits |= 0x800000;
            } else {
                assert (bigBbits != 0) : bigBbits;
                int leadingZeros = Integer.numberOfLeadingZeros(bigBbits);
                int shift = leadingZeros - 8;
                bigBbits <<= shift;
                binexp = 1 - shift;
            }
            int lowOrderZeros = Integer.numberOfTrailingZeros(bigBbits);
            bigBbits >>>= lowOrderZeros;
            int bigIntExp = (binexp -= 127) - 23 + lowOrderZeros;
            int bigIntNBits = 24 - lowOrderZeros;
            int B2 = B5;
            int D2 = D5;
            if (bigIntExp >= 0) {
                B2 += bigIntExp;
            } else {
                D2 -= bigIntExp;
            }
            int Ulp2 = B2;
            int hulpbias = binexp <= -127 ? binexp + lowOrderZeros + 127 : 1 + lowOrderZeros;
            int common2 = Math.min(B2 += hulpbias, Math.min(D2 += hulpbias, Ulp2));
            Ulp2 -= common2;
            FDBigInteger bigB = FDBigInteger.valueOfMulPow52(bigBbits, B5, B2 -= common2);
            if (bigD == null || prevD2 != (D2 -= common2)) {
                bigD = bigD0.leftShift(D2);
                prevD2 = D2;
            }
            if ((cmpResult = bigB.cmp(bigD)) > 0) {
                overvalue = true;
                diff = bigB.leftInplaceSub(bigD);
                if (bigIntNBits == 1 && bigIntExp > -126 && --Ulp2 < 0) {
                    Ulp2 = 0;
                    diff = diff.leftShift(1);
                }
            } else {
                if (cmpResult >= 0) break;
                overvalue = false;
                diff = bigD.rightInplaceSub(bigB);
            }
            if ((cmpResult = diff.cmpPow52(B5, Ulp2)) < 0) break;
            if (cmpResult == 0) {
                if ((ieeeBits & 1) != 0) {
                    ieeeBits += overvalue ? -1 : 1;
                }
                break;
            }
            n = overvalue ? -1 : 1;
            int FLOAT_EXP_BIT_MASK = 2139095040;
        } while ((ieeeBits += n) != 0 && ieeeBits != 2139095040);
        if (isNegative) {
            int FLOAT_SIGN_BIT_MASK = Integer.MIN_VALUE;
            ieeeBits |= Integer.MIN_VALUE;
        }
        return Float.intBitsToFloat(ieeeBits);
    }

    public static Class<?> getMapping(Type type) {
        Type[] upperBounds;
        if (type == null) {
            return null;
        }
        if (type.getClass() == Class.class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return TypeUtils.getMapping(((ParameterizedType)type).getRawType());
        }
        if (type instanceof TypeVariable) {
            Type boundType = ((TypeVariable)type).getBounds()[0];
            if (boundType instanceof Class) {
                return (Class)boundType;
            }
            return TypeUtils.getMapping(boundType);
        }
        if (type instanceof WildcardType && (upperBounds = ((WildcardType)type).getUpperBounds()).length == 1) {
            return TypeUtils.getMapping(upperBounds[0]);
        }
        if (type instanceof GenericArrayType) {
            Type genericComponentType = ((GenericArrayType)type).getGenericComponentType();
            Class<?> componentClass = TypeUtils.getClass(genericComponentType);
            return TypeUtils.getArrayClass(componentClass);
        }
        return Object.class;
    }

    public static Date toDate(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Date) {
            return (Date)obj;
        }
        if (obj instanceof Instant) {
            Instant instant = (Instant)obj;
            return new Date(instant.toEpochMilli());
        }
        if (obj instanceof ZonedDateTime) {
            ZonedDateTime zdt = (ZonedDateTime)obj;
            return new Date(zdt.toInstant().toEpochMilli());
        }
        if (obj instanceof LocalDate) {
            LocalDate localDate = (LocalDate)obj;
            ZonedDateTime zdt = localDate.atStartOfDay(ZoneId.systemDefault());
            return new Date(zdt.toInstant().toEpochMilli());
        }
        if (obj instanceof LocalDateTime) {
            LocalDateTime ldt = (LocalDateTime)obj;
            ZonedDateTime zdt = ldt.atZone(ZoneId.systemDefault());
            return new Date(zdt.toInstant().toEpochMilli());
        }
        if (obj instanceof String) {
            return DateUtils.parseDate((String)obj);
        }
        if (obj instanceof Long || obj instanceof Integer) {
            return new Date(((Number)obj).longValue());
        }
        throw new JSONException("can not cast to Date from " + obj.getClass());
    }

    public static Instant toInstant(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Instant) {
            return (Instant)obj;
        }
        if (obj instanceof Date) {
            return ((Date)obj).toInstant();
        }
        if (obj instanceof ZonedDateTime) {
            ZonedDateTime zdt = (ZonedDateTime)obj;
            return zdt.toInstant();
        }
        if (obj instanceof String) {
            String str = (String)obj;
            if (str.isEmpty() || "null".equals(str)) {
                return null;
            }
            JSONReader jsonReader = str.charAt(0) != '\"' ? JSONReader.of('\"' + str + '\"') : JSONReader.of(str);
            return jsonReader.read(Instant.class);
        }
        if (obj instanceof Map) {
            return (Instant)ObjectReaderImplInstant.INSTANCE.createInstance((Map)obj, 0L);
        }
        throw new JSONException("can not cast to Date from " + obj.getClass());
    }

    public static Object[] cast(Object obj, Type[] types) {
        if (obj == null) {
            return null;
        }
        Object[] array = new Object[types.length];
        if (obj instanceof Collection) {
            int i = 0;
            for (Object item : (Collection)obj) {
                int index = i++;
                array[index] = TypeUtils.cast(item, types[index]);
            }
        } else {
            Class<?> objectClass = obj.getClass();
            if (objectClass.isArray()) {
                int length = Array.getLength(obj);
                for (int i = 0; i < array.length && i < length; ++i) {
                    Object item = Array.get(obj, i);
                    array[i] = TypeUtils.cast(item, types[i]);
                }
            } else {
                throw new JSONException("can not cast to types " + JSON.toJSONString(types) + " from " + objectClass);
            }
        }
        return array;
    }

    public static String[] toStringArray(Object object) {
        if (object == null || object instanceof String[]) {
            return (String[])object;
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            String[] array = new String[collection.size()];
            int i = 0;
            for (Object item : (Collection)object) {
                int index = i++;
                array[index] = item == null || item instanceof String ? (String)item : item.toString();
            }
            return array;
        }
        Class<?> objectClass = object.getClass();
        if (objectClass.isArray()) {
            int length = Array.getLength(object);
            String[] array = new String[length];
            for (int i = 0; i < array.length; ++i) {
                Object item = Array.get(object, i);
                array[i] = item == null || item instanceof String ? (String)item : item.toString();
            }
            return array;
        }
        return TypeUtils.cast(object, String[].class);
    }

    public static <T> T cast(Object obj, Type type) {
        return TypeUtils.cast(obj, type, JSONFactory.getDefaultObjectReaderProvider());
    }

    public static <T> T cast(Object obj, Type type, ObjectReaderProvider provider) {
        if (type instanceof Class) {
            return TypeUtils.cast(obj, (Class)type, provider);
        }
        if (obj instanceof Collection) {
            return provider.getObjectReader(type).createInstance((Collection)obj);
        }
        if (obj instanceof Map) {
            return provider.getObjectReader(type).createInstance((Map)obj, 0L);
        }
        return JSON.parseObject(JSON.toJSONString(obj), type);
    }

    public static <T> T cast(Object obj, Class<T> targetClass) {
        return TypeUtils.cast(obj, targetClass, JSONFactory.getDefaultObjectReaderProvider());
    }

    public static <T> T cast(Object obj, Class<T> targetClass, ObjectReaderProvider provider) {
        Object apply;
        Function function;
        ObjectWriter objectWriter;
        ObjectReader objectReader;
        if (obj == null) {
            return null;
        }
        if (targetClass.isInstance(obj)) {
            return (T)obj;
        }
        if (targetClass == Date.class) {
            return (T)TypeUtils.toDate(obj);
        }
        if (targetClass == Instant.class) {
            return (T)TypeUtils.toInstant(obj);
        }
        if (targetClass == String.class) {
            if (obj instanceof Character) {
                return (T)obj.toString();
            }
            return (T)JSON.toJSONString(obj);
        }
        if (targetClass == AtomicInteger.class) {
            return (T)new AtomicInteger(TypeUtils.toIntValue(obj));
        }
        if (targetClass == AtomicLong.class) {
            return (T)new AtomicLong(TypeUtils.toLongValue(obj));
        }
        if (targetClass == AtomicBoolean.class) {
            return (T)new AtomicBoolean((Boolean)obj);
        }
        if (obj instanceof Map) {
            ObjectReader objectReader2 = provider.getObjectReader(targetClass);
            return objectReader2.createInstance((Map)obj, 0L);
        }
        Function typeConvert = provider.getTypeConvert(obj.getClass(), targetClass);
        if (typeConvert != null) {
            return (T)typeConvert.apply(obj);
        }
        if (targetClass.isEnum() && (objectReader = JSONFactory.getDefaultObjectReaderProvider().getObjectReader(targetClass)) instanceof ObjectReaderImplEnum) {
            if (obj instanceof Integer) {
                int intValue = (Integer)obj;
                return (T)((ObjectReaderImplEnum)objectReader).of(intValue);
            }
            JSONReader jsonReader = JSONReader.of(JSON.toJSONString(obj));
            return objectReader.readObject(jsonReader, null, null, 0L);
        }
        if (obj instanceof String) {
            String json = (String)obj;
            if (json.isEmpty() || "null".equals(json)) {
                return null;
            }
            char first = json.trim().charAt(0);
            JSONReader jsonReader = first == '\"' || first == '{' || first == '[' ? JSONReader.of(json) : JSONReader.of(JSON.toJSONString(json));
            ObjectReader objectReader3 = JSONFactory.getDefaultObjectReaderProvider().getObjectReader(targetClass);
            return objectReader3.readObject(jsonReader, null, null, 0L);
        }
        if (obj instanceof Collection) {
            return provider.getObjectReader(targetClass).createInstance((Collection)obj);
        }
        String className = targetClass.getName();
        if (obj instanceof Integer || obj instanceof Long) {
            long millis = ((Number)obj).longValue();
            switch (className) {
                case "java.sql.Date": {
                    return (T)JdbcSupport.createDate(millis);
                }
                case "java.sql.Timestamp": {
                    return (T)JdbcSupport.createTimestamp(millis);
                }
                case "java.sql.Time": {
                    return (T)JdbcSupport.createTime(millis);
                }
            }
        }
        if ((objectWriter = JSONFactory.getDefaultObjectWriterProvider().getObjectWriter(obj.getClass())) instanceof ObjectWriterPrimitiveImpl && (function = ((ObjectWriterPrimitiveImpl)objectWriter).getFunction()) != null && targetClass.isInstance(apply = function.apply(obj))) {
            return (T)apply;
        }
        throw new JSONException("can not cast to " + className + ", from " + obj.getClass());
    }

    public static String getTypeName(Class type) {
        Class<?> superclass;
        String typeName;
        Class<?>[] interfaces;
        String mapTypeName = NAME_MAPPINGS.get(type);
        if (mapTypeName != null) {
            return mapTypeName;
        }
        if (Proxy.isProxyClass(type) && (interfaces = type.getInterfaces()).length > 0) {
            type = interfaces[0];
        }
        switch (typeName = type.getTypeName()) {
            case "com.alibaba.fastjson.JSONObject": {
                NAME_MAPPINGS.putIfAbsent(type, "JO1");
                return NAME_MAPPINGS.get(type);
            }
            case "com.alibaba.fastjson.JSONArray": {
                NAME_MAPPINGS.putIfAbsent(type, "JA1");
                return NAME_MAPPINGS.get(type);
            }
        }
        int index = typeName.indexOf(36);
        if (index != -1 && TypeUtils.isInteger(typeName.substring(index + 1)) && Map.class.isAssignableFrom(superclass = type.getSuperclass())) {
            return TypeUtils.getTypeName(superclass);
        }
        return typeName;
    }

    public static Class getMapping(String typeName) {
        return TYPE_MAPPINGS.get(typeName);
    }

    public static BigDecimal toBigDecimal(Object value) {
        if (value == null || value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
            return BigDecimal.valueOf(((Number)value).longValue());
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equals(str)) {
                return null;
            }
            return new BigDecimal(str);
        }
        return TypeUtils.cast(value, BigDecimal.class);
    }

    public static BigDecimal toBigDecimal(long i) {
        return BigDecimal.valueOf(i);
    }

    public static BigDecimal toBigDecimal(float f) {
        byte[] bytes = new byte[15];
        int size = DoubleToDecimal.toString(f, bytes, 0, true);
        return TypeUtils.parseBigDecimal(bytes, 0, size);
    }

    public static BigDecimal toBigDecimal(double d) {
        byte[] bytes = new byte[24];
        int size = DoubleToDecimal.toString(d, bytes, 0, true);
        return TypeUtils.parseBigDecimal(bytes, 0, size);
    }

    public static BigDecimal toBigDecimal(String str) {
        int code;
        if (str == null || str.isEmpty() || "null".equals(str)) {
            return null;
        }
        if (JDKUtils.STRING_CODER != null && (code = JDKUtils.STRING_CODER.applyAsInt(str)) == JDKUtils.LATIN1 && JDKUtils.STRING_VALUE != null) {
            byte[] bytes = JDKUtils.STRING_VALUE.apply(str);
            return TypeUtils.parseBigDecimal(bytes, 0, bytes.length);
        }
        char[] chars = JDKUtils.getCharArray(str);
        return TypeUtils.parseBigDecimal(chars, 0, chars.length);
    }

    public static BigDecimal toBigDecimal(char[] chars) {
        if (chars == null) {
            return null;
        }
        return TypeUtils.parseBigDecimal(chars, 0, chars.length);
    }

    public static BigDecimal toBigDecimal(byte[] strBytes) {
        if (strBytes == null) {
            return null;
        }
        return TypeUtils.parseBigDecimal(strBytes, 0, strBytes.length);
    }

    public static boolean isInt32(BigInteger value) {
        if (JDKUtils.FIELD_BIGINTEGER_MAG_OFFSET != -1L) {
            int[] mag = (int[])JDKUtils.UNSAFE.getObject(value, JDKUtils.FIELD_BIGINTEGER_MAG_OFFSET);
            return mag.length == 0 || mag.length == 1 && (mag[0] >= 0 || mag[0] == Integer.MIN_VALUE && value.signum() == -1);
        }
        return value.compareTo(BIGINT_INT32_MIN) >= 0 && value.compareTo(BIGINT_INT32_MAX) <= 0;
    }

    public static boolean isInt64(BigInteger value) {
        if (JDKUtils.FIELD_BIGINTEGER_MAG_OFFSET != -1L) {
            int[] mag = (int[])JDKUtils.UNSAFE.getObject(value, JDKUtils.FIELD_BIGINTEGER_MAG_OFFSET);
            if (mag.length <= 1) {
                return true;
            }
            if (mag.length == 2) {
                int mag0 = mag[0];
                return mag[0] >= 0 || mag0 == Integer.MIN_VALUE && mag[1] == 0 && value.signum() == -1;
            }
        }
        return value.compareTo(BIGINT_INT64_MIN) >= 0 && value.compareTo(BIGINT_INT64_MAX) <= 0;
    }

    public static boolean isInteger(BigDecimal decimal) {
        int scale = decimal.scale();
        if (scale == 0) {
            return true;
        }
        int precision = decimal.precision();
        if (precision < 20 && JDKUtils.FIELD_DECIMAL_INT_COMPACT_OFFSET != -1L) {
            long intCompact = JDKUtils.UNSAFE.getLong(decimal, JDKUtils.FIELD_DECIMAL_INT_COMPACT_OFFSET);
            switch (scale) {
                case 1: {
                    return intCompact % 10L == 0L;
                }
                case 2: {
                    return intCompact % 100L == 0L;
                }
                case 3: {
                    return intCompact % 1000L == 0L;
                }
                case 4: {
                    return intCompact % 10000L == 0L;
                }
                case 5: {
                    return intCompact % 100000L == 0L;
                }
                case 6: {
                    return intCompact % 1000000L == 0L;
                }
                case 7: {
                    return intCompact % 10000000L == 0L;
                }
                case 8: {
                    return intCompact % 100000000L == 0L;
                }
                case 9: {
                    return intCompact % 1000000000L == 0L;
                }
            }
        }
        return decimal.stripTrailingZeros().scale() == 0;
    }

    public static BigInteger toBigInteger(Object value) {
        if (value == null || value instanceof BigInteger) {
            return (BigInteger)value;
        }
        if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
            return BigInteger.valueOf(((Number)value).longValue());
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equals(str)) {
                return null;
            }
            return new BigInteger(str);
        }
        throw new JSONException("can not cast to bigint");
    }

    public static Long toLong(Object value) {
        if (value == null || value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equals(str)) {
                return null;
            }
            return Long.parseLong(str);
        }
        throw new JSONException("can not cast to long, class " + value.getClass());
    }

    public static long toLongValue(Object value) {
        if (value == null) {
            return 0L;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equals(str)) {
                return 0L;
            }
            return Long.parseLong(str);
        }
        throw new JSONException("can not cast to long from " + value.getClass());
    }

    public static Boolean parseBoolean(byte[] bytes, int off, int len) {
        switch (len) {
            case 0: {
                return null;
            }
            case 1: {
                byte b0 = bytes[off];
                if (b0 == 49 || b0 == 89) {
                    return Boolean.TRUE;
                }
                if (b0 != 48 && b0 != 78) break;
                return Boolean.FALSE;
            }
            case 4: {
                if (bytes[off] != 116 || bytes[off + 1] != 114 || bytes[off + 2] != 117 || bytes[off + 3] != 101) break;
                return Boolean.TRUE;
            }
            case 5: {
                if (bytes[off] != 102 || bytes[off + 1] != 97 || bytes[off + 2] != 108 || bytes[off + 3] != 115 || bytes[off + 4] != 101) break;
                return Boolean.FALSE;
            }
        }
        String str = new String(bytes, off, len);
        return Boolean.parseBoolean(str);
    }

    public static Boolean parseBoolean(char[] bytes, int off, int len) {
        switch (len) {
            case 0: {
                return null;
            }
            case 1: {
                char b0 = bytes[off];
                if (b0 == '1' || b0 == 'Y') {
                    return Boolean.TRUE;
                }
                if (b0 != '0' && b0 != 'N') break;
                return Boolean.FALSE;
            }
            case 4: {
                if (bytes[off] != 't' || bytes[off + 1] != 'r' || bytes[off + 2] != 'u' || bytes[off + 3] != 'e') break;
                return Boolean.TRUE;
            }
            case 5: {
                if (bytes[off] != 'f' || bytes[off + 1] != 'a' || bytes[off + 2] != 'l' || bytes[off + 3] != 's' || bytes[off + 4] != 'e') break;
                return Boolean.FALSE;
            }
        }
        String str = new String(bytes, off, len);
        return Boolean.parseBoolean(str);
    }

    public static int parseInt(byte[] bytes, int off, int len) {
        switch (len) {
            case 1: {
                byte b0 = bytes[off];
                if (b0 < 48 || b0 > 57) break;
                return b0 - 48;
            }
            case 2: {
                byte b0 = bytes[off];
                byte b1 = bytes[off + 1];
                if (b0 < 48 || b0 > 57 || b1 < 48 || b1 > 57) break;
                return (b0 - 48) * 10 + (b1 - 48);
            }
            case 3: {
                byte b0 = bytes[off];
                byte b1 = bytes[off + 1];
                byte b2 = bytes[off + 2];
                if (b0 < 48 || b0 > 57 || b1 < 48 || b1 > 57 || b2 < 48 || b2 > 57) break;
                return (b0 - 48) * 100 + (b1 - 48) * 10 + (b2 - 48);
            }
            case 4: {
                byte b0 = bytes[off];
                byte b1 = bytes[off + 1];
                byte b2 = bytes[off + 2];
                byte b3 = bytes[off + 3];
                if (b0 < 48 || b0 > 57 || b1 < 48 || b1 > 57 || b2 < 48 || b2 > 57 || b3 < 48 || b3 > 57) break;
                return (b0 - 48) * 1000 + (b1 - 48) * 100 + (b2 - 48) * 10 + (b3 - 48);
            }
            case 5: {
                byte b0 = bytes[off];
                byte b1 = bytes[off + 1];
                byte b2 = bytes[off + 2];
                byte b3 = bytes[off + 3];
                byte b4 = bytes[off + 4];
                if (b0 < 48 || b0 > 57 || b1 < 48 || b1 > 57 || b2 < 48 || b2 > 57 || b3 < 48 || b3 > 57 || b4 < 48 || b4 > 57) break;
                return (b0 - 48) * 10000 + (b1 - 48) * 1000 + (b2 - 48) * 100 + (b3 - 48) * 10 + (b4 - 48);
            }
            case 6: {
                byte b0 = bytes[off];
                byte b1 = bytes[off + 1];
                byte b2 = bytes[off + 2];
                byte b3 = bytes[off + 3];
                byte b4 = bytes[off + 4];
                byte b5 = bytes[off + 5];
                if (b0 < 48 || b0 > 57 || b1 < 48 || b1 > 57 || b2 < 48 || b2 > 57 || b3 < 48 || b3 > 57 || b4 < 48 || b4 > 57 || b5 < 48 || b5 > 57) break;
                return (b0 - 48) * 100000 + (b1 - 48) * 10000 + (b2 - 48) * 1000 + (b3 - 48) * 100 + (b4 - 48) * 10 + (b5 - 48);
            }
            case 7: {
                byte b0 = bytes[off];
                byte b1 = bytes[off + 1];
                byte b2 = bytes[off + 2];
                byte b3 = bytes[off + 3];
                byte b4 = bytes[off + 4];
                byte b5 = bytes[off + 5];
                byte b6 = bytes[off + 6];
                if (b0 < 48 || b0 > 57 || b1 < 48 || b1 > 57 || b2 < 48 || b2 > 57 || b3 < 48 || b3 > 57 || b4 < 48 || b4 > 57 || b5 < 48 || b5 > 57 || b6 < 48 || b6 > 57) break;
                return (b0 - 48) * 1000000 + (b1 - 48) * 100000 + (b2 - 48) * 10000 + (b3 - 48) * 1000 + (b4 - 48) * 100 + (b5 - 48) * 10 + (b6 - 48);
            }
            case 8: {
                byte b0 = bytes[off];
                byte b1 = bytes[off + 1];
                byte b2 = bytes[off + 2];
                byte b3 = bytes[off + 3];
                byte b4 = bytes[off + 4];
                byte b5 = bytes[off + 5];
                byte b6 = bytes[off + 6];
                byte b7 = bytes[off + 7];
                if (b0 < 48 || b0 > 57 || b1 < 48 || b1 > 57 || b2 < 48 || b2 > 57 || b3 < 48 || b3 > 57 || b4 < 48 || b4 > 57 || b5 < 48 || b5 > 57 || b6 < 48 || b6 > 57 || b7 < 48 || b7 > 57) break;
                return (b0 - 48) * 10000000 + (b1 - 48) * 1000000 + (b2 - 48) * 100000 + (b3 - 48) * 10000 + (b4 - 48) * 1000 + (b5 - 48) * 100 + (b6 - 48) * 10 + (b7 - 48);
            }
        }
        String str = new String(bytes, off, len);
        return Integer.parseInt(str);
    }

    public static int parseInt(char[] bytes, int off, int len) {
        switch (len) {
            case 1: {
                char b0 = bytes[off];
                if (b0 < '0' || b0 > '9') break;
                return b0 - 48;
            }
            case 2: {
                char b0 = bytes[off];
                char b1 = bytes[off + 1];
                if (b0 < '0' || b0 > '9' || b1 < '0' || b1 > '9') break;
                return (b0 - 48) * 10 + (b1 - 48);
            }
            case 3: {
                char b0 = bytes[off];
                char b1 = bytes[off + 1];
                char b2 = bytes[off + 2];
                if (b0 < '0' || b0 > '9' || b1 < '0' || b1 > '9' || b2 < '0' || b2 > '9') break;
                return (b0 - 48) * 100 + (b1 - 48) * 10 + (b2 - 48);
            }
            case 4: {
                char b0 = bytes[off];
                char b1 = bytes[off + 1];
                char b2 = bytes[off + 2];
                char b3 = bytes[off + 3];
                if (b0 < '0' || b0 > '9' || b1 < '0' || b1 > '9' || b2 < '0' || b2 > '9' || b3 < '0' || b3 > '9') break;
                return (b0 - 48) * 1000 + (b1 - 48) * 100 + (b2 - 48) * 10 + (b3 - 48);
            }
            case 5: {
                char b0 = bytes[off];
                char b1 = bytes[off + 1];
                char b2 = bytes[off + 2];
                char b3 = bytes[off + 3];
                char b4 = bytes[off + 4];
                if (b0 < '0' || b0 > '9' || b1 < '0' || b1 > '9' || b2 < '0' || b2 > '9' || b3 < '0' || b3 > '9' || b4 < '0' || b4 > '9') break;
                return (b0 - 48) * 10000 + (b1 - 48) * 1000 + (b2 - 48) * 100 + (b3 - 48) * 10 + (b4 - 48);
            }
            case 6: {
                char b0 = bytes[off];
                char b1 = bytes[off + 1];
                char b2 = bytes[off + 2];
                char b3 = bytes[off + 3];
                char b4 = bytes[off + 4];
                char b5 = bytes[off + 5];
                if (b0 < '0' || b0 > '9' || b1 < '0' || b1 > '9' || b2 < '0' || b2 > '9' || b3 < '0' || b3 > '9' || b4 < '0' || b4 > '9' || b5 < '0' || b5 > '9') break;
                return (b0 - 48) * 100000 + (b1 - 48) * 10000 + (b2 - 48) * 1000 + (b3 - 48) * 100 + (b4 - 48) * 10 + (b5 - 48);
            }
            case 7: {
                char b0 = bytes[off];
                char b1 = bytes[off + 1];
                char b2 = bytes[off + 2];
                char b3 = bytes[off + 3];
                char b4 = bytes[off + 4];
                char b5 = bytes[off + 5];
                char b6 = bytes[off + 6];
                if (b0 < '0' || b0 > '9' || b1 < '0' || b1 > '9' || b2 < '0' || b2 > '9' || b3 < '0' || b3 > '9' || b4 < '0' || b4 > '9' || b5 < '0' || b5 > '9' || b6 < '0' || b6 > '9') break;
                return (b0 - 48) * 1000000 + (b1 - 48) * 100000 + (b2 - 48) * 10000 + (b3 - 48) * 1000 + (b4 - 48) * 100 + (b5 - 48) * 10 + (b6 - 48);
            }
            case 8: {
                char b0 = bytes[off];
                char b1 = bytes[off + 1];
                char b2 = bytes[off + 2];
                char b3 = bytes[off + 3];
                char b4 = bytes[off + 4];
                char b5 = bytes[off + 5];
                char b6 = bytes[off + 6];
                char b7 = bytes[off + 7];
                if (b0 < '0' || b0 > '9' || b1 < '0' || b1 > '9' || b2 < '0' || b2 > '9' || b3 < '0' || b3 > '9' || b4 < '0' || b4 > '9' || b5 < '0' || b5 > '9' || b6 < '0' || b6 > '9' || b7 < '0' || b7 > '9') break;
                return (b0 - 48) * 10000000 + (b1 - 48) * 1000000 + (b2 - 48) * 100000 + (b3 - 48) * 10000 + (b4 - 48) * 1000 + (b5 - 48) * 100 + (b6 - 48) * 10 + (b7 - 48);
            }
        }
        String str = new String(bytes, off, len);
        return Integer.parseInt(str);
    }

    public static long parseLong(byte[] bytes, int off, int len) {
        switch (len) {
            case 1: {
                byte b0 = bytes[off];
                if (b0 < 48 || b0 > 57) break;
                return b0 - 48;
            }
            case 2: {
                byte b0 = bytes[off];
                byte b1 = bytes[off + 1];
                if (b0 < 48 || b0 > 57 || b1 < 48 || b1 > 57) break;
                return (long)(b0 - 48) * 10L + (long)(b1 - 48);
            }
            case 3: {
                byte b0 = bytes[off];
                byte b1 = bytes[off + 1];
                byte b2 = bytes[off + 2];
                if (b0 < 48 || b0 > 57 || b1 < 48 || b1 > 57 || b2 < 48 || b2 > 57) break;
                return (long)(b0 - 48) * 100L + (long)((b1 - 48) * 10) + (long)(b2 - 48);
            }
            case 4: {
                byte b0 = bytes[off];
                byte b1 = bytes[off + 1];
                byte b2 = bytes[off + 2];
                byte b3 = bytes[off + 3];
                if (b0 < 48 || b0 > 57 || b1 < 48 || b1 > 57 || b2 < 48 || b2 > 57 || b3 < 48 || b3 > 57) break;
                return (long)(b0 - 48) * 1000L + (long)((b1 - 48) * 100) + (long)((b2 - 48) * 10) + (long)(b3 - 48);
            }
            case 5: {
                byte b0 = bytes[off];
                byte b1 = bytes[off + 1];
                byte b2 = bytes[off + 2];
                byte b3 = bytes[off + 3];
                byte b4 = bytes[off + 4];
                if (b0 < 48 || b0 > 57 || b1 < 48 || b1 > 57 || b2 < 48 || b2 > 57 || b3 < 48 || b3 > 57 || b4 < 48 || b4 > 57) break;
                return (long)(b0 - 48) * 10000L + (long)((b1 - 48) * 1000) + (long)((b2 - 48) * 100) + (long)((b3 - 48) * 10) + (long)(b4 - 48);
            }
            case 6: {
                byte b0 = bytes[off];
                byte b1 = bytes[off + 1];
                byte b2 = bytes[off + 2];
                byte b3 = bytes[off + 3];
                byte b4 = bytes[off + 4];
                byte b5 = bytes[off + 5];
                if (b0 < 48 || b0 > 57 || b1 < 48 || b1 > 57 || b2 < 48 || b2 > 57 || b3 < 48 || b3 > 57 || b4 < 48 || b4 > 57 || b5 < 48 || b5 > 57) break;
                return (long)(b0 - 48) * 100000L + (long)((b1 - 48) * 10000) + (long)((b2 - 48) * 1000) + (long)((b3 - 48) * 100) + (long)((b4 - 48) * 10) + (long)(b5 - 48);
            }
            case 7: {
                byte b0 = bytes[off];
                byte b1 = bytes[off + 1];
                byte b2 = bytes[off + 2];
                byte b3 = bytes[off + 3];
                byte b4 = bytes[off + 4];
                byte b5 = bytes[off + 5];
                byte b6 = bytes[off + 6];
                if (b0 < 48 || b0 > 57 || b1 < 48 || b1 > 57 || b2 < 48 || b2 > 57 || b3 < 48 || b3 > 57 || b4 < 48 || b4 > 57 || b5 < 48 || b5 > 57 || b6 < 48 || b6 > 57) break;
                return (long)(b0 - 48) * 1000000L + (long)((b1 - 48) * 100000) + (long)((b2 - 48) * 10000) + (long)((b3 - 48) * 1000) + (long)((b4 - 48) * 100) + (long)((b5 - 48) * 10) + (long)(b6 - 48);
            }
            case 8: {
                byte b0 = bytes[off];
                byte b1 = bytes[off + 1];
                byte b2 = bytes[off + 2];
                byte b3 = bytes[off + 3];
                byte b4 = bytes[off + 4];
                byte b5 = bytes[off + 5];
                byte b6 = bytes[off + 6];
                byte b7 = bytes[off + 7];
                if (b0 < 48 || b0 > 57 || b1 < 48 || b1 > 57 || b2 < 48 || b2 > 57 || b3 < 48 || b3 > 57 || b4 < 48 || b4 > 57 || b5 < 48 || b5 > 57 || b6 < 48 || b6 > 57 || b7 < 48 || b7 > 57) break;
                return (long)(b0 - 48) * 10000000L + (long)((b1 - 48) * 1000000) + (long)((b2 - 48) * 100000) + (long)((b3 - 48) * 10000) + (long)((b4 - 48) * 1000) + (long)((b5 - 48) * 100) + (long)((b6 - 48) * 10) + (long)(b7 - 48);
            }
        }
        String str = new String(bytes, off, len);
        return Long.parseLong(str);
    }

    public static long parseLong(char[] bytes, int off, int len) {
        switch (len) {
            case 1: {
                char b0 = bytes[off];
                if (b0 < '0' || b0 > '9') break;
                return b0 - 48;
            }
            case 2: {
                char b0 = bytes[off];
                char b1 = bytes[off + 1];
                if (b0 < '0' || b0 > '9' || b1 < '0' || b1 > '9') break;
                return (long)(b0 - 48) * 10L + (long)(b1 - 48);
            }
            case 3: {
                char b0 = bytes[off];
                char b1 = bytes[off + 1];
                char b2 = bytes[off + 2];
                if (b0 < '0' || b0 > '9' || b1 < '0' || b1 > '9' || b2 < '0' || b2 > '9') break;
                return (long)(b0 - 48) * 100L + (long)((b1 - 48) * 10) + (long)(b2 - 48);
            }
            case 4: {
                char b0 = bytes[off];
                char b1 = bytes[off + 1];
                char b2 = bytes[off + 2];
                char b3 = bytes[off + 3];
                if (b0 < '0' || b0 > '9' || b1 < '0' || b1 > '9' || b2 < '0' || b2 > '9' || b3 < '0' || b3 > '9') break;
                return (long)(b0 - 48) * 1000L + (long)((b1 - 48) * 100) + (long)((b2 - 48) * 10) + (long)(b3 - 48);
            }
            case 5: {
                char b0 = bytes[off];
                char b1 = bytes[off + 1];
                char b2 = bytes[off + 2];
                char b3 = bytes[off + 3];
                char b4 = bytes[off + 4];
                if (b0 < '0' || b0 > '9' || b1 < '0' || b1 > '9' || b2 < '0' || b2 > '9' || b3 < '0' || b3 > '9' || b4 < '0' || b4 > '9') break;
                return (long)(b0 - 48) * 10000L + (long)((b1 - 48) * 1000) + (long)((b2 - 48) * 100) + (long)((b3 - 48) * 10) + (long)(b4 - 48);
            }
            case 6: {
                char b0 = bytes[off];
                char b1 = bytes[off + 1];
                char b2 = bytes[off + 2];
                char b3 = bytes[off + 3];
                char b4 = bytes[off + 4];
                char b5 = bytes[off + 5];
                if (b0 < '0' || b0 > '9' || b1 < '0' || b1 > '9' || b2 < '0' || b2 > '9' || b3 < '0' || b3 > '9' || b4 < '0' || b4 > '9' || b5 < '0' || b5 > '9') break;
                return (long)(b0 - 48) * 100000L + (long)((b1 - 48) * 10000) + (long)((b2 - 48) * 1000) + (long)((b3 - 48) * 100) + (long)((b4 - 48) * 10) + (long)(b5 - 48);
            }
            case 7: {
                char b0 = bytes[off];
                char b1 = bytes[off + 1];
                char b2 = bytes[off + 2];
                char b3 = bytes[off + 3];
                char b4 = bytes[off + 4];
                char b5 = bytes[off + 5];
                char b6 = bytes[off + 6];
                if (b0 < '0' || b0 > '9' || b1 < '0' || b1 > '9' || b2 < '0' || b2 > '9' || b3 < '0' || b3 > '9' || b4 < '0' || b4 > '9' || b5 < '0' || b5 > '9' || b6 < '0' || b6 > '9') break;
                return (long)(b0 - 48) * 1000000L + (long)((b1 - 48) * 100000) + (long)((b2 - 48) * 10000) + (long)((b3 - 48) * 1000) + (long)((b4 - 48) * 100) + (long)((b5 - 48) * 10) + (long)(b6 - 48);
            }
            case 8: {
                char b0 = bytes[off];
                char b1 = bytes[off + 1];
                char b2 = bytes[off + 2];
                char b3 = bytes[off + 3];
                char b4 = bytes[off + 4];
                char b5 = bytes[off + 5];
                char b6 = bytes[off + 6];
                char b7 = bytes[off + 7];
                if (b0 < '0' || b0 > '9' || b1 < '0' || b1 > '9' || b2 < '0' || b2 > '9' || b3 < '0' || b3 > '9' || b4 < '0' || b4 > '9' || b5 < '0' || b5 > '9' || b6 < '0' || b6 > '9' || b7 < '0' || b7 > '9') break;
                return (long)(b0 - 48) * 10000000L + (long)((b1 - 48) * 1000000) + (long)((b2 - 48) * 100000) + (long)((b3 - 48) * 10000) + (long)((b4 - 48) * 1000) + (long)((b5 - 48) * 100) + (long)((b6 - 48) * 10) + (long)(b7 - 48);
            }
        }
        String str = new String(bytes, off, len);
        return Long.parseLong(str);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static BigDecimal parseBigDecimal(char[] bytes, int off, int len) {
        if (bytes == null || len == 0) {
            return null;
        }
        boolean negative = false;
        int j = off;
        if (bytes[off] == '-') {
            negative = true;
            ++j;
        }
        if (len <= 20 || negative && len == 21) {
            int end = off + len;
            int dot = 0;
            int dotIndex = -1;
            long unscaleValue = 0L;
            while (j < end) {
                block12: {
                    char b = bytes[j];
                    if (b == '.') {
                        if (++dot > 1) break;
                        dotIndex = j;
                    } else {
                        if (b >= '0' && b <= '9') {
                            long r = unscaleValue * 10L;
                            if ((unscaleValue | 0xAL) >>> 31 == 0L || r / 10L == unscaleValue) {
                                unscaleValue = r + (long)(b - 48);
                                break block12;
                            } else {
                                unscaleValue = -1L;
                                break;
                            }
                        }
                        unscaleValue = -1L;
                        break;
                    }
                }
                ++j;
            }
            int scale = 0;
            if (unscaleValue >= 0L && dot <= 1) {
                if (negative) {
                    unscaleValue = -unscaleValue;
                }
                if (dotIndex != -1) {
                    scale = len - (dotIndex - off) - 1;
                }
                return BigDecimal.valueOf(unscaleValue, scale);
            }
        }
        return new BigDecimal(bytes, off, len);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static BigDecimal parseBigDecimal(byte[] bytes, int off, int len) {
        char[] chars;
        if (bytes == null) return null;
        if (len == 0) {
            return null;
        }
        boolean negative = false;
        int j = off;
        if (bytes[off] == 45) {
            negative = true;
            ++j;
        }
        if (len <= 20 || negative && len == 21) {
            int end = off + len;
            int dot = 0;
            int dotIndex = -1;
            long unscaleValue = 0L;
            while (j < end) {
                block13: {
                    byte b = bytes[j];
                    if (b == 46) {
                        if (++dot > 1) break;
                        dotIndex = j;
                    } else {
                        if (b >= 48 && b <= 57) {
                            long r = unscaleValue * 10L;
                            if ((unscaleValue | 0xAL) >>> 31 == 0L || r / 10L == unscaleValue) {
                                unscaleValue = r + (long)(b - 48);
                                break block13;
                            } else {
                                unscaleValue = -1L;
                                break;
                            }
                        }
                        unscaleValue = -1L;
                        break;
                    }
                }
                ++j;
            }
            int scale = 0;
            if (unscaleValue >= 0L && dot <= 1) {
                if (negative) {
                    unscaleValue = -unscaleValue;
                }
                if (dotIndex == -1) return BigDecimal.valueOf(unscaleValue, scale);
                scale = len - (dotIndex - off) - 1;
                return BigDecimal.valueOf(unscaleValue, scale);
            }
        }
        if (off == 0 && len == bytes.length) {
            chars = X1.TO_CHARS.apply(bytes);
            return new BigDecimal(chars, 0, chars.length);
        }
        chars = new char[len];
        int i = 0;
        while (i < len) {
            chars[i] = (char)bytes[off + i];
            ++i;
        }
        return new BigDecimal(chars, 0, chars.length);
    }

    public static Integer toInteger(Object value) {
        if (value == null || value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equals(str)) {
                return null;
            }
            return Integer.parseInt(str);
        }
        if (value instanceof Map && ((Map)value).isEmpty()) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1 : 0;
        }
        throw new JSONException("can not cast to integer");
    }

    public static Byte toByte(Object value) {
        if (value == null || value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equals(str)) {
                return null;
            }
            return Byte.parseByte(str);
        }
        throw new JSONException("can not cast to byte");
    }

    public static byte toByteValue(Object value) {
        if (value == null) {
            return 0;
        }
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equals(str)) {
                return 0;
            }
            return Byte.parseByte(str);
        }
        throw new JSONException("can not cast to byte");
    }

    public static Short toShort(Object value) {
        if (value == null || value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equals(str)) {
                return null;
            }
            return Short.parseShort(str);
        }
        throw new JSONException("can not cast to byte");
    }

    public static short toShortValue(Object value) {
        if (value == null) {
            return 0;
        }
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof Number) {
            return (byte)((Number)value).shortValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equals(str)) {
                return 0;
            }
            return Short.parseShort(str);
        }
        throw new JSONException("can not cast to byte");
    }

    public static int toIntValue(Object value) {
        if (value == null) {
            return 0;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equals(str)) {
                return 0;
            }
            if (str.indexOf(46) != -1) {
                return new BigDecimal(str).intValueExact();
            }
            return Integer.parseInt(str);
        }
        throw new JSONException("can not cast to decimal");
    }

    public static boolean toBooleanValue(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equals(str)) {
                return false;
            }
            return Boolean.parseBoolean(str);
        }
        if (value instanceof Number) {
            int intValue = ((Number)value).intValue();
            if (intValue == 1) {
                return true;
            }
            if (intValue == 0) {
                return false;
            }
        }
        throw new JSONException("can not cast to boolean");
    }

    public static Boolean toBoolean(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equals(str)) {
                return null;
            }
            return Boolean.parseBoolean(str);
        }
        if (value instanceof Number) {
            int intValue = ((Number)value).intValue();
            if (intValue == 1) {
                return true;
            }
            if (intValue == 0) {
                return false;
            }
        }
        throw new JSONException("can not cast to boolean");
    }

    public static float toFloatValue(Object value) {
        if (value == null) {
            return 0.0f;
        }
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        if (value instanceof Number) {
            return ((Number)value).floatValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equals(str)) {
                return 0.0f;
            }
            return Float.parseFloat(str);
        }
        throw new JSONException("can not cast to decimal");
    }

    public static Float toFloat(Object value) {
        if (value == null || value instanceof Float) {
            return (Float)value;
        }
        if (value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equals(str)) {
                return null;
            }
            return Float.valueOf(Float.parseFloat(str));
        }
        throw new JSONException("can not cast to decimal");
    }

    public static double toDoubleValue(Object value) {
        if (value == null) {
            return 0.0;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equals(str)) {
                return 0.0;
            }
            return Double.parseDouble(str);
        }
        throw new JSONException("can not cast to decimal");
    }

    public static Double toDouble(Object value) {
        if (value == null || value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equals(str)) {
                return null;
            }
            return Double.parseDouble(str);
        }
        throw new JSONException("can not cast to decimal");
    }

    public static int compare(Object a, Object b) {
        Class<?> typeB;
        Class<?> typeA = a.getClass();
        if (typeA == (typeB = b.getClass())) {
            return ((Comparable)a).compareTo(b);
        }
        if (typeA == BigDecimal.class) {
            if (typeB == Integer.class || typeB == Long.class) {
                b = BigDecimal.valueOf(((Number)b).longValue());
            } else if (typeB == Float.class || typeB == Double.class) {
                b = BigDecimal.valueOf(((Number)b).doubleValue());
            } else if (typeB == BigInteger.class) {
                b = new BigDecimal((BigInteger)b);
            }
        } else if (typeA == BigInteger.class) {
            if (typeB == Integer.class || typeB == Long.class) {
                b = BigInteger.valueOf(((Number)b).longValue());
            } else if (typeB == Float.class || typeB == Double.class) {
                b = BigDecimal.valueOf(((Number)b).doubleValue());
                a = new BigDecimal((BigInteger)a);
            } else if (typeB == BigDecimal.class) {
                a = new BigDecimal((BigInteger)a);
            }
        } else if (typeA == Long.class) {
            if (typeB == Integer.class) {
                return Long.compare((Long)a, ((Integer)b).intValue());
            }
            if (typeB == BigDecimal.class) {
                a = BigDecimal.valueOf((Long)a);
            } else {
                if (typeB == Float.class || typeB == Double.class) {
                    return Double.compare(((Long)a).longValue(), ((Number)b).doubleValue());
                }
                if (typeB == BigInteger.class) {
                    a = BigInteger.valueOf((Long)a);
                } else if (typeB == String.class) {
                    a = BigDecimal.valueOf((Long)a);
                    b = new BigDecimal((String)b);
                }
            }
        } else if (typeA == Integer.class) {
            if (typeB == Long.class) {
                return Long.compare(((Integer)a).intValue(), (Long)b);
            }
            if (typeB == BigDecimal.class) {
                a = BigDecimal.valueOf(((Integer)a).intValue());
            } else if (typeB == BigInteger.class) {
                a = BigInteger.valueOf(((Integer)a).intValue());
            } else {
                if (typeB == Float.class || typeB == Double.class) {
                    return Double.compare(((Integer)a).intValue(), ((Number)b).doubleValue());
                }
                if (typeB == String.class) {
                    a = BigDecimal.valueOf(((Integer)a).intValue());
                    b = new BigDecimal((String)b);
                }
            }
        } else if (typeA == Double.class) {
            if (typeB == Integer.class || typeB == Long.class || typeB == Float.class) {
                return Double.compare((Double)a, ((Number)b).doubleValue());
            }
            if (typeB == BigDecimal.class) {
                a = BigDecimal.valueOf((Double)a);
            } else if (typeB == String.class) {
                a = BigDecimal.valueOf((Double)a);
                b = new BigDecimal((String)b);
            } else if (typeB == BigInteger.class) {
                a = BigDecimal.valueOf((Double)a);
                b = new BigDecimal((BigInteger)b);
            }
        } else if (typeA == Float.class) {
            if (typeB == Integer.class || typeB == Long.class || typeB == Double.class) {
                return Double.compare(((Float)a).floatValue(), ((Number)b).doubleValue());
            }
            if (typeB == BigDecimal.class) {
                a = BigDecimal.valueOf(((Float)a).floatValue());
            } else if (typeB == String.class) {
                a = BigDecimal.valueOf(((Float)a).floatValue());
                b = new BigDecimal((String)b);
            } else if (typeB == BigInteger.class) {
                a = BigDecimal.valueOf(((Float)a).floatValue());
                b = new BigDecimal((BigInteger)b);
            }
        } else if (typeA == String.class) {
            String strA = (String)a;
            if (typeB == Integer.class || typeB == Long.class) {
                try {
                    long aVal = Long.parseLong(strA);
                    return Long.compare(aVal, ((Number)b).longValue());
                }
                catch (NumberFormatException ex) {
                    a = new BigDecimal(strA);
                    b = BigDecimal.valueOf(((Number)b).longValue());
                }
            } else {
                if (typeB == Float.class || typeB == Double.class) {
                    return Double.compare(Double.parseDouble(strA), ((Number)b).doubleValue());
                }
                if (typeB == BigInteger.class) {
                    a = new BigInteger(strA);
                } else if (typeB == BigDecimal.class) {
                    a = new BigDecimal(strA);
                }
            }
        }
        return ((Comparable)a).compareTo(b);
    }

    public static Object getDefaultValue(Type paramType) {
        if (paramType == Integer.TYPE) {
            return 0;
        }
        if (paramType == Long.TYPE) {
            return 0L;
        }
        if (paramType == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (paramType == Double.TYPE) {
            return 0.0;
        }
        if (paramType == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (paramType == Short.TYPE) {
            return (short)0;
        }
        if (paramType == Byte.TYPE) {
            return (byte)0;
        }
        if (paramType == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        if (paramType == Optional.class) {
            return Optional.empty();
        }
        if (paramType == OptionalInt.class) {
            return OptionalInt.empty();
        }
        if (paramType == OptionalLong.class) {
            return OptionalLong.empty();
        }
        if (paramType == OptionalDouble.class) {
            return OptionalDouble.empty();
        }
        return null;
    }

    public static Class loadClass(String className) {
        if (className.length() >= 192) {
            return null;
        }
        switch (className) {
            case "O": 
            case "Object": 
            case "java.lang.Object": {
                return Object.class;
            }
            case "java.util.Collections$EmptyMap": {
                return Collections.emptyMap().getClass();
            }
            case "java.util.Collections$EmptyList": {
                return Collections.emptyList().getClass();
            }
            case "java.util.Collections$EmptySet": {
                return Collections.emptySet().getClass();
            }
            case "java.util.Optional": {
                return Optional.class;
            }
            case "java.util.OptionalInt": {
                return OptionalInt.class;
            }
            case "java.util.OptionalLong": {
                return OptionalLong.class;
            }
            case "List": 
            case "java.util.List": {
                return List.class;
            }
            case "A": 
            case "ArrayList": 
            case "java.util.ArrayList": {
                return ArrayList.class;
            }
            case "LA": 
            case "LinkedList": 
            case "java.util.LinkedList": {
                return LinkedList.class;
            }
            case "Map": 
            case "java.util.Map": {
                return Map.class;
            }
            case "M": 
            case "HashMap": 
            case "java.util.HashMap": {
                return HashMap.class;
            }
            case "LM": 
            case "LinkedHashMap": 
            case "java.util.LinkedHashMap": {
                return LinkedHashMap.class;
            }
            case "ConcurrentHashMap": {
                return ConcurrentHashMap.class;
            }
            case "ConcurrentLinkedQueue": {
                return ConcurrentLinkedQueue.class;
            }
            case "ConcurrentLinkedDeque": {
                return ConcurrentLinkedDeque.class;
            }
            case "JSONObject": {
                return JSONObject.class;
            }
            case "JO1": {
                className = "com.alibaba.fastjson.JSONObject";
                break;
            }
            case "Set": 
            case "java.util.Set": {
                return Set.class;
            }
            case "HashSet": 
            case "java.util.HashSet": {
                return HashSet.class;
            }
            case "LinkedHashSet": 
            case "java.util.LinkedHashSet": {
                return LinkedHashSet.class;
            }
            case "TreeSet": 
            case "java.util.TreeSet": {
                return TreeSet.class;
            }
            case "java.lang.Class": {
                return Class.class;
            }
            case "java.lang.Integer": {
                return Integer.class;
            }
            case "java.lang.Long": {
                return Long.class;
            }
            case "String": 
            case "java.lang.String": {
                return String.class;
            }
            case "[String": {
                return String[].class;
            }
            case "I": 
            case "int": {
                return Integer.TYPE;
            }
            case "S": 
            case "short": {
                return Short.TYPE;
            }
            case "J": 
            case "long": {
                return Long.TYPE;
            }
            case "Z": 
            case "boolean": {
                return Boolean.TYPE;
            }
            case "B": 
            case "byte": {
                return Byte.TYPE;
            }
            case "F": 
            case "float": {
                return Float.TYPE;
            }
            case "D": 
            case "double": {
                return Double.TYPE;
            }
            case "C": 
            case "char": {
                return Character.TYPE;
            }
            case "[B": 
            case "byte[]": {
                return byte[].class;
            }
            case "[S": 
            case "short[]": {
                return short[].class;
            }
            case "[I": 
            case "int[]": {
                return int[].class;
            }
            case "[J": 
            case "long[]": {
                return long[].class;
            }
            case "[F": 
            case "float[]": {
                return float[].class;
            }
            case "[D": 
            case "double[]": {
                return double[].class;
            }
            case "[C": 
            case "char[]": {
                return char[].class;
            }
            case "[Z": 
            case "boolean[]": {
                return boolean[].class;
            }
            case "[O": {
                return Object[].class;
            }
            case "UUID": {
                return UUID.class;
            }
            case "Date": {
                return Date.class;
            }
            case "Calendar": {
                return Calendar.class;
            }
            case "java.io.IOException": {
                return IOException.class;
            }
            case "java.util.Collections$UnmodifiableRandomAccessList": {
                return CLASS_UNMODIFIABLE_LIST;
            }
            case "java.util.Arrays$ArrayList": {
                return Arrays.asList(1).getClass();
            }
            case "java.util.Collections$SingletonList": {
                return CLASS_SINGLE_LIST;
            }
            case "java.util.Collections$SingletonSet": {
                return CLASS_SINGLE_SET;
            }
        }
        Class mapping = TYPE_MAPPINGS.get(className);
        if (mapping != null) {
            return mapping;
        }
        if (className.startsWith("java.util.ImmutableCollections$")) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                return CLASS_UNMODIFIABLE_LIST;
            }
        }
        if (className.charAt(0) == 'L' && className.charAt(className.length() - 1) == ';') {
            className = className.substring(1, className.length() - 1);
        }
        if (className.charAt(0) == '[' || className.endsWith("[]")) {
            String itemClassName = className.charAt(0) == '[' ? className.substring(1) : className.substring(0, className.length() - 2);
            Class itemClass = TypeUtils.loadClass(itemClassName);
            if (itemClass == null) {
                throw new JSONException("load class error " + className);
            }
            return Array.newInstance(itemClass, 0).getClass();
        }
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null) {
            try {
                return contextClassLoader.loadClass(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        try {
            return JSON.class.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                return null;
            }
        }
    }

    public static Class<?> getArrayClass(Class componentClass) {
        if (componentClass == Integer.TYPE) {
            return int[].class;
        }
        if (componentClass == Byte.TYPE) {
            return byte[].class;
        }
        if (componentClass == Short.TYPE) {
            return short[].class;
        }
        if (componentClass == Long.TYPE) {
            return long[].class;
        }
        if (componentClass == String.class) {
            return String[].class;
        }
        if (componentClass == Object.class) {
            return Object[].class;
        }
        return Array.newInstance(componentClass, 1).getClass();
    }

    public static Class nonePrimitive(Class type) {
        if (type.isPrimitive()) {
            String name;
            switch (name = type.getName()) {
                case "byte": {
                    return Byte.class;
                }
                case "short": {
                    return Short.class;
                }
                case "int": {
                    return Integer.class;
                }
                case "long": {
                    return Long.class;
                }
                case "float": {
                    return Float.class;
                }
                case "double": {
                    return Double.class;
                }
                case "char": {
                    return Character.class;
                }
                case "boolean": {
                    return Boolean.class;
                }
            }
        }
        return type;
    }

    public static Class<?> getClass(Type type) {
        Type[] upperBounds;
        if (type == null) {
            return null;
        }
        if (type.getClass() == Class.class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return TypeUtils.getClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof TypeVariable) {
            Type boundType = ((TypeVariable)type).getBounds()[0];
            if (boundType instanceof Class) {
                return (Class)boundType;
            }
            return TypeUtils.getClass(boundType);
        }
        if (type instanceof WildcardType && (upperBounds = ((WildcardType)type).getUpperBounds()).length == 1) {
            return TypeUtils.getClass(upperBounds[0]);
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            Type componentType = genericArrayType.getGenericComponentType();
            Class<?> componentClass = TypeUtils.getClass(componentType);
            return TypeUtils.getArrayClass(componentClass);
        }
        return Object.class;
    }

    public static boolean isProxy(Class<?> clazz) {
        for (Class<?> item : clazz.getInterfaces()) {
            String interfaceName;
            switch (interfaceName = item.getName()) {
                case "org.springframework.cglib.proxy.Factory": 
                case "javassist.util.proxy.ProxyObject": 
                case "org.apache.ibatis.javassist.util.proxy.ProxyObject": 
                case "org.hibernate.proxy.HibernateProxy": 
                case "org.springframework.context.annotation.ConfigurationClassEnhancer$EnhancedConfiguration": 
                case "org.mockito.cglib.proxy.Factory": 
                case "net.sf.cglib.proxy.Factory": {
                    return true;
                }
            }
        }
        return false;
    }

    public static Map getInnerMap(Map object) {
        if (CLASS_JSON_OBJECT_1x == null || !CLASS_JSON_OBJECT_1x.isInstance(object) || FIELD_JSON_OBJECT_1x_map == null) {
            return object;
        }
        try {
            object = (Map)FIELD_JSON_OBJECT_1x_map.get(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return object;
    }

    public static boolean isFunction(Class type) {
        if (type.isInterface()) {
            String typeName = type.getName();
            if (typeName.startsWith("java.util.function.")) {
                return true;
            }
            return type.isAnnotationPresent(FunctionalInterface.class);
        }
        return false;
    }

    public static boolean isInteger(String str) {
        boolean sign;
        if (str == null || str.isEmpty()) {
            return false;
        }
        char ch = str.charAt(0);
        boolean bl = sign = ch == '-' || ch == '+';
        if (sign ? str.length() == 1 : ch < '0' || ch > '9') {
            return false;
        }
        for (int i = 1; i < str.length(); ++i) {
            ch = str.charAt(i);
            if (ch >= '0' && ch <= '9') continue;
            return false;
        }
        return true;
    }

    public static boolean isInteger(byte[] str, int off, int len) {
        boolean sign;
        if (str == null || len == 0) {
            return false;
        }
        char ch = (char)str[off];
        boolean bl = sign = ch == '-' || ch == '+';
        if (sign ? len == 1 : ch < '0' || ch > '9') {
            return false;
        }
        int end = off + len;
        for (int i = off + 1; i < end; ++i) {
            ch = (char)str[i];
            if (ch >= '0' && ch <= '9') continue;
            return false;
        }
        return true;
    }

    public static boolean isInteger(char[] str, int off, int len) {
        boolean sign;
        if (str == null || len == 0) {
            return false;
        }
        char ch = str[off];
        boolean bl = sign = ch == '-' || ch == '+';
        if (sign ? len == 1 : ch < '0' || ch > '9') {
            return false;
        }
        int end = off + len;
        for (int i = off + 1; i < end; ++i) {
            ch = str[i];
            if (ch >= '0' && ch <= '9') continue;
            return false;
        }
        return true;
    }

    public static boolean isNumber(String str) {
        int offset;
        boolean sign;
        if (str == null || str.isEmpty()) {
            return false;
        }
        char ch = str.charAt(0);
        boolean bl = sign = ch == '-' || ch == '+';
        if (sign) {
            if (str.length() == 1) {
                return false;
            }
            ch = str.charAt(1);
            offset = 1;
        } else if (ch == '.') {
            if (str.length() == 1) {
                return false;
            }
            offset = 1;
        } else {
            offset = 0;
        }
        int end = str.length();
        boolean dot = ch == '.';
        boolean space = false;
        boolean num = false;
        if (!dot && ch >= '0' && ch <= '9') {
            num = true;
            do {
                if (offset >= end) {
                    return true;
                }
                ch = str.charAt(offset++);
            } while (!space && ch >= '0' && ch <= '9');
        }
        boolean small = false;
        if (ch == '.') {
            small = true;
            if (offset >= end) {
                return true;
            }
            ch = str.charAt(offset++);
            if (ch >= '0' && ch <= '9') {
                do {
                    if (offset >= end) {
                        return true;
                    }
                    ch = str.charAt(offset++);
                } while (!space && ch >= '0' && ch <= '9');
            }
        }
        if (!num && !small) {
            return false;
        }
        if (ch == 'e' || ch == 'E') {
            if (offset == end) {
                return true;
            }
            ch = str.charAt(offset++);
            boolean eSign = false;
            if (ch == '+' || ch == '-') {
                eSign = true;
                if (offset < end) {
                    ch = str.charAt(offset++);
                } else {
                    return false;
                }
            }
            if (ch >= '0' && ch <= '9') {
                do {
                    if (offset >= end) {
                        return true;
                    }
                    ch = str.charAt(offset++);
                } while (ch >= '0' && ch <= '9');
            } else if (eSign) {
                return false;
            }
        }
        return false;
    }

    public static boolean isNumber(byte[] str, int off, int len) {
        int offset;
        boolean sign;
        if (str == null || len == 0) {
            return false;
        }
        char ch = (char)str[off];
        boolean bl = sign = ch == '-' || ch == '+';
        if (sign) {
            if (len == 1) {
                return false;
            }
            ch = (char)str[off + 1];
            offset = off + 1;
        } else if (ch == '.') {
            if (len == 1) {
                return false;
            }
            offset = off + 1;
        } else {
            offset = off;
        }
        int end = off + len;
        boolean dot = ch == '.';
        boolean num = false;
        if (!dot && ch >= '0' && ch <= '9') {
            num = true;
            do {
                if (offset >= end) {
                    return true;
                }
                ch = (char)str[offset++];
            } while (ch >= '0' && ch <= '9');
        }
        boolean small = false;
        if (ch == '.') {
            small = true;
            if (offset >= end) {
                return true;
            }
            ch = (char)str[offset++];
            if (ch >= '0' && ch <= '9') {
                do {
                    if (offset >= end) {
                        return true;
                    }
                    ch = (char)str[offset++];
                } while (ch >= '0' && ch <= '9');
            }
        }
        if (!num && !small) {
            return false;
        }
        if (ch == 'e' || ch == 'E') {
            if (offset == end) {
                return true;
            }
            ch = (char)str[offset++];
            boolean eSign = false;
            if (ch == '+' || ch == '-') {
                eSign = true;
                if (offset < end) {
                    ch = (char)str[offset++];
                } else {
                    return false;
                }
            }
            if (ch >= '0' && ch <= '9') {
                do {
                    if (offset >= end) {
                        return true;
                    }
                    ch = (char)str[offset++];
                } while (ch >= '0' && ch <= '9');
            } else if (eSign) {
                return false;
            }
        }
        return false;
    }

    public static boolean isNumber(char[] str, int off, int len) {
        int offset;
        boolean sign;
        if (str == null || len == 0) {
            return false;
        }
        char ch = str[off];
        boolean bl = sign = ch == '-' || ch == '+';
        if (sign) {
            if (len == 1) {
                return false;
            }
            ch = str[off + 1];
            offset = off + 1;
        } else if (ch == '.') {
            if (len == 1) {
                return false;
            }
            offset = off + 1;
        } else {
            offset = off;
        }
        int end = off + len;
        boolean dot = ch == '.';
        boolean space = false;
        boolean num = false;
        if (!dot && ch >= '0' && ch <= '9') {
            num = true;
            do {
                if (offset >= end) {
                    return true;
                }
                ch = str[offset++];
            } while (!space && ch >= '0' && ch <= '9');
        }
        boolean small = false;
        if (ch == '.') {
            small = true;
            if (offset >= end) {
                return true;
            }
            ch = str[offset++];
            if (ch >= '0' && ch <= '9') {
                do {
                    if (offset >= end) {
                        return true;
                    }
                    ch = str[offset++];
                } while (!space && ch >= '0' && ch <= '9');
            }
        }
        if (!num && !small) {
            return false;
        }
        if (ch == 'e' || ch == 'E') {
            if (offset == end) {
                return true;
            }
            ch = str[offset++];
            boolean eSign = false;
            if (ch == '+' || ch == '-') {
                eSign = true;
                if (offset < end) {
                    ch = str[offset++];
                } else {
                    return false;
                }
            }
            if (ch >= '0' && ch <= '9') {
                do {
                    if (offset >= end) {
                        return true;
                    }
                    ch = str[offset++];
                } while (ch >= '0' && ch <= '9');
            } else if (eSign) {
                return false;
            }
        }
        return false;
    }

    public static boolean isUUID(String str) {
        if (str == null) {
            return false;
        }
        if (str.length() == 32) {
            for (int i = 0; i < 32; ++i) {
                boolean valid;
                char ch = str.charAt(i);
                boolean bl = valid = ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'F' || ch >= 'a' && ch <= 'f';
                if (valid) continue;
                return false;
            }
            return true;
        }
        if (str.length() == 36) {
            for (int i = 0; i < 36; ++i) {
                boolean valid;
                char ch = str.charAt(i);
                if (i == 8 || i == 13 || i == 18 || i == 23) {
                    if (ch == '-') continue;
                    return false;
                }
                boolean bl = valid = ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'F' || ch >= 'a' && ch <= 'f';
                if (valid) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean validateIPv4(String str) {
        return TypeUtils.validateIPv4(str, 0);
    }

    static boolean validateIPv4(String str, int off) {
        if (str == null) {
            return false;
        }
        int strlen = str.length();
        int len = strlen - off;
        if (len < 7 || len > 25) {
            return false;
        }
        int start = off;
        int dotCount = 0;
        for (int i = off; i < strlen; ++i) {
            char ch = str.charAt(i);
            if (ch != '.' && i != strlen - 1) continue;
            int end = ch == '.' ? i : i + 1;
            int n = end - start;
            switch (n) {
                case 1: {
                    char c0 = str.charAt(end - 1);
                    if (c0 >= '0' && c0 <= '9') break;
                    return false;
                }
                case 2: {
                    char c0 = str.charAt(end - 2);
                    char c1 = str.charAt(end - 1);
                    if (c0 < '0' || c0 > '9') {
                        return false;
                    }
                    if (c1 >= '0' && c1 <= '9') break;
                    return false;
                }
                case 3: {
                    char c0 = str.charAt(end - 3);
                    char c1 = str.charAt(end - 2);
                    char c2 = str.charAt(end - 1);
                    if (c0 < '0' || c0 > '2') {
                        return false;
                    }
                    if (c1 < '0' || c1 > '9') {
                        return false;
                    }
                    if (c2 < '0' || c2 > '9') {
                        return false;
                    }
                    int value = (c0 - 48) * 100 + (c1 - 48) * 10 + (c2 - 48);
                    if (value <= 255) break;
                    return false;
                }
                default: {
                    return false;
                }
            }
            if (ch != '.') continue;
            ++dotCount;
            start = i + 1;
        }
        return dotCount == 3;
    }

    public static boolean validateIPv6(String str) {
        if (str == null) {
            return false;
        }
        int len = str.length();
        if (len < 2 || len > 39) {
            return false;
        }
        int start = 0;
        int colonCount = 0;
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch == '.') {
                boolean ipV4 = TypeUtils.validateIPv4(str, start);
                if (ipV4) break;
                return false;
            }
            if (ch != ':' && i != len - 1) continue;
            int end = ch == ':' ? i : i + 1;
            int n = end - start;
            switch (n) {
                case 0: {
                    break;
                }
                case 1: {
                    char c0 = str.charAt(end - 1);
                    if (c0 >= '0' && c0 <= '9' || c0 >= 'A' && c0 <= 'F' || c0 >= 'a' && c0 <= 'f') break;
                    return false;
                }
                case 2: {
                    char c0 = str.charAt(end - 2);
                    char c1 = str.charAt(end - 1);
                    if (!(c0 >= '0' && c0 <= '9' || c0 >= 'A' && c0 <= 'F' || c0 >= 'a' && c0 <= 'f')) {
                        return false;
                    }
                    if (c1 >= '0' && c1 <= '9' || c1 >= 'A' && c1 <= 'F' || c1 >= 'a' && c1 <= 'f') break;
                    return false;
                }
                case 3: {
                    char c0 = str.charAt(end - 3);
                    char c1 = str.charAt(end - 2);
                    char c2 = str.charAt(end - 1);
                    if (!(c0 >= '0' && c0 <= '9' || c0 >= 'A' && c0 <= 'F' || c0 >= 'a' && c0 <= 'f')) {
                        return false;
                    }
                    if (!(c1 >= '0' && c1 <= '9' || c1 >= 'A' && c1 <= 'F' || c1 >= 'a' && c1 <= 'f')) {
                        return false;
                    }
                    if (c2 >= '0' && c2 <= '9' || c2 >= 'A' && c2 <= 'F' || c2 >= 'a' && c2 <= 'f') break;
                    return false;
                }
                case 4: {
                    char c0 = str.charAt(end - 4);
                    char c1 = str.charAt(end - 3);
                    char c2 = str.charAt(end - 2);
                    char c3 = str.charAt(end - 1);
                    if (!(c0 >= '0' && c0 <= '9' || c0 >= 'A' && c0 <= 'F' || c0 >= 'a' && c0 <= 'f')) {
                        return false;
                    }
                    if (!(c1 >= '0' && c1 <= '9' || c1 >= 'A' && c1 <= 'F' || c1 >= 'a' && c1 <= 'f')) {
                        return false;
                    }
                    if (!(c2 >= '0' && c2 <= '9' || c2 >= 'A' && c2 <= 'F' || c2 >= 'a' && c2 <= 'f')) {
                        return false;
                    }
                    if (c3 >= '0' && c3 <= '9' || c3 >= 'A' && c3 <= 'F' || c3 >= 'a' && c3 <= 'f') break;
                    return false;
                }
                default: {
                    return false;
                }
            }
            if (ch != ':') continue;
            ++colonCount;
            start = i + 1;
        }
        return colonCount > 0 && colonCount < 8;
    }

    public static double doubleValue(int signNum, long intCompact, int scale) {
        BigInteger n;
        BigInteger m;
        int P_D = 53;
        int Q_MIN_D = -1074;
        int Q_MAX_D = 971;
        double L = 3.321928094887362;
        int bitLength = 64 - Long.numberOfLeadingZeros(intCompact);
        long qb = (long)bitLength - (long)Math.ceil((double)scale * 3.321928094887362);
        if (qb < -1076L) {
            return (double)signNum * 0.0;
        }
        if (qb > 1025L) {
            return (double)signNum * Double.POSITIVE_INFINITY;
        }
        if (scale < 0) {
            BigInteger pow10 = BIG_TEN_POWERS_TABLE[-scale];
            BigInteger w = BigInteger.valueOf(intCompact);
            return (double)signNum * w.multiply(pow10).doubleValue();
        }
        if (scale == 0) {
            return (double)signNum * (double)intCompact;
        }
        BigInteger w = BigInteger.valueOf(intCompact);
        int ql = (int)qb - 56;
        BigInteger pow10 = BIG_TEN_POWERS_TABLE[scale];
        if (ql <= 0) {
            m = w.shiftLeft(-ql);
            n = pow10;
        } else {
            m = w;
            n = pow10.shiftLeft(ql);
        }
        BigInteger[] qr = m.divideAndRemainder(n);
        long i = qr[0].longValue();
        int sb = qr[1].signum();
        int dq = 9 - Long.numberOfLeadingZeros(i);
        int eq = -1076 - ql;
        if (dq >= eq) {
            return (double)signNum * Math.scalb((double)(i | (long)sb), ql);
        }
        long mask = (1L << eq) - 1L;
        long j = i >> eq | (long)Long.signum(i & mask) | (long)sb;
        return (double)signNum * Math.scalb((double)j, -1076);
    }

    public static float floatValue(int signNum, long intCompact, int scale) {
        BigInteger n;
        BigInteger m;
        int P_F = 24;
        int Q_MIN_F = -149;
        int Q_MAX_F = 104;
        double L = 3.321928094887362;
        int bitLength = 64 - Long.numberOfLeadingZeros(intCompact);
        long qb = (long)bitLength - (long)Math.ceil((double)scale * 3.321928094887362);
        if (qb < -151L) {
            return (float)signNum * 0.0f;
        }
        if (qb > 129L) {
            return (float)signNum * Float.POSITIVE_INFINITY;
        }
        if (scale < 0) {
            BigInteger w = BigInteger.valueOf(intCompact);
            return (float)signNum * w.multiply(BIG_TEN_POWERS_TABLE[-scale]).floatValue();
        }
        BigInteger w = BigInteger.valueOf(intCompact);
        int ql = (int)qb - 27;
        BigInteger pow10 = BIG_TEN_POWERS_TABLE[scale];
        if (ql <= 0) {
            m = w.shiftLeft(-ql);
            n = pow10;
        } else {
            m = w;
            n = pow10.shiftLeft(ql);
        }
        BigInteger[] qr = m.divideAndRemainder(n);
        int i = qr[0].intValue();
        int sb = qr[1].signum();
        int dq = 6 - Integer.numberOfLeadingZeros(i);
        int eq = -151 - ql;
        if (dq >= eq) {
            return (float)signNum * Math.scalb(i | sb, ql);
        }
        int mask = (1 << eq) - 1;
        int j = i >> eq | Integer.signum(i & mask) | sb;
        return (float)signNum * Math.scalb(j, -151);
    }

    public static boolean isJavaScriptSupport(long i) {
        return i >= -9007199254740991L && i <= 0x1FFFFFFFFFFFFFL;
    }

    public static boolean isJavaScriptSupport(BigDecimal i) {
        return i.compareTo(DECIMAL_JAVASCRIPT_LOW) >= 0 && i.compareTo(DECIMAL_JAVASCRIPT_HIGH) <= 0;
    }

    public static boolean isJavaScriptSupport(BigInteger i) {
        return i.compareTo(BIGINT_JAVASCRIPT_LOW) >= 0 && i.compareTo(BIGINT_JAVASCRIPT_HIGH) <= 0;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_11;
        void var3_7;
        Class[] classes;
        CLASS_SINGLE_SET = Collections.singleton(1).getClass();
        CLASS_SINGLE_LIST = Collections.singletonList(1).getClass();
        CLASS_UNMODIFIABLE_COLLECTION = Collections.unmodifiableCollection(new ArrayList()).getClass();
        CLASS_UNMODIFIABLE_LIST = Collections.unmodifiableList(new ArrayList()).getClass();
        CLASS_UNMODIFIABLE_SET = Collections.unmodifiableSet(new HashSet()).getClass();
        CLASS_UNMODIFIABLE_SORTED_SET = Collections.unmodifiableSortedSet(new TreeSet()).getClass();
        CLASS_UNMODIFIABLE_NAVIGABLE_SET = Collections.unmodifiableNavigableSet(new TreeSet()).getClass();
        PARAM_TYPE_LIST_STR = new ParameterizedTypeImpl((Type)((Object)List.class), new Type[]{String.class});
        METHOD_TYPE_SUPPLIER = MethodType.methodType(Supplier.class);
        METHOD_TYPE_FUNCTION = MethodType.methodType(Function.class);
        METHOD_TYPE_TO_INT_FUNCTION = MethodType.methodType(ToIntFunction.class);
        METHOD_TYPE_TO_LONG_FUNCTION = MethodType.methodType(ToLongFunction.class);
        METHOD_TYPE_OBJECT_INT_CONSUMER = MethodType.methodType(ObjIntConsumer.class);
        METHOD_TYPE_INT_FUNCTION = MethodType.methodType(IntFunction.class);
        METHOD_TYPE_LONG_FUNCTION = MethodType.methodType(LongFunction.class);
        METHOD_TYPE_BI_FUNCTION = MethodType.methodType(BiFunction.class);
        METHOD_TYPE_BI_CONSUMER = MethodType.methodType(BiConsumer.class);
        METHOD_TYPE_VOO = MethodType.methodType(Void.TYPE, Object.class, Object.class);
        METHOD_TYPE_OBJECT = MethodType.methodType(Object.class);
        METHOD_TYPE_OBJECT_OBJECT = MethodType.methodType(Object.class, Object.class);
        METHOD_TYPE_INT_OBJECT = MethodType.methodType(Integer.TYPE, Object.class);
        METHOD_TYPE_LONG_OBJECT = MethodType.methodType(Long.TYPE, Object.class);
        METHOD_TYPE_VOID_OBJECT_INT = MethodType.methodType(Void.TYPE, Object.class, Integer.TYPE);
        METHOD_TYPE_OBJECT_LONG = MethodType.methodType(Object.class, Long.TYPE);
        METHOD_TYPE_VOID_LONG = MethodType.methodType(Void.TYPE, Long.TYPE);
        METHOD_TYPE_OBJECT_OBJECT_OBJECT = MethodType.methodType(Object.class, Object.class, Object.class);
        METHOD_TYPE_VOID = MethodType.methodType(Void.TYPE);
        METHOD_TYPE_VOID_INT = MethodType.methodType(Void.TYPE, Integer.TYPE);
        METHOD_TYPE_VOID_STRING = MethodType.methodType(Void.TYPE, String.class);
        METHOD_TYPE_OBJECT_INT = MethodType.methodType(Object.class, Integer.TYPE);
        BIGINT_INT32_MIN = BigInteger.valueOf(Integer.MIN_VALUE);
        BIGINT_INT32_MAX = BigInteger.valueOf(Integer.MAX_VALUE);
        BIGINT_INT64_MIN = BigInteger.valueOf(Long.MIN_VALUE);
        BIGINT_INT64_MAX = BigInteger.valueOf(Long.MAX_VALUE);
        DECIMAL_JAVASCRIPT_LOW = BigDecimal.valueOf(-9007199254740991L);
        DECIMAL_JAVASCRIPT_HIGH = BigDecimal.valueOf(0x1FFFFFFFFFFFFFL);
        BIGINT_JAVASCRIPT_LOW = BigInteger.valueOf(-9007199254740991L);
        BIGINT_JAVASCRIPT_HIGH = BigInteger.valueOf(0x1FFFFFFFFFFFFFL);
        SMALL_10_POW = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15, 1.0E16, 1.0E17, 1.0E18, 1.0E19, 1.0E20, 1.0E21, 1.0E22};
        SINGLE_SMALL_10_POW = new float[]{1.0f, 10.0f, 100.0f, 1000.0f, 10000.0f, 100000.0f, 1000000.0f, 1.0E7f, 1.0E8f, 1.0E9f, 1.0E10f};
        BIG_10_POW = new double[]{1.0E16, 1.0E32, 1.0E64, 1.0E128, 1.0E256};
        TINY_10_POW = new double[]{1.0E-16, 1.0E-32, 1.0E-64, 1.0E-128, 1.0E-256};
        CACHE = new Cache();
        CHARS_UPDATER = AtomicReferenceFieldUpdater.newUpdater(Cache.class, char[].class, "chars");
        NAME_MAPPINGS = new IdentityHashMap<Class, String>();
        TYPE_MAPPINGS = new ConcurrentHashMap<String, Class>();
        CLASS_JSON_OBJECT_1x = TypeUtils.loadClass("com.alibaba.fastjson.JSONObject");
        Field field = null;
        if (CLASS_JSON_OBJECT_1x != null) {
            try {
                field = CLASS_JSON_OBJECT_1x.getDeclaredField("map");
                field.setAccessible(true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        FIELD_JSON_OBJECT_1x_map = field;
        CLASS_JSON_ARRAY_1x = TypeUtils.loadClass("com.alibaba.fastjson.JSONArray");
        NAME_MAPPINGS.put(Byte.TYPE, "B");
        NAME_MAPPINGS.put(Short.TYPE, "S");
        NAME_MAPPINGS.put(Integer.TYPE, "I");
        NAME_MAPPINGS.put(Long.TYPE, "J");
        NAME_MAPPINGS.put(Float.TYPE, "F");
        NAME_MAPPINGS.put(Double.TYPE, "D");
        NAME_MAPPINGS.put(Character.TYPE, "C");
        NAME_MAPPINGS.put(Boolean.TYPE, "Z");
        NAME_MAPPINGS.put(Object[].class, "[O");
        NAME_MAPPINGS.put(Object[][].class, "[[O");
        NAME_MAPPINGS.put(byte[].class, "[B");
        NAME_MAPPINGS.put(byte[][].class, "[[B");
        NAME_MAPPINGS.put(short[].class, "[S");
        NAME_MAPPINGS.put(short[][].class, "[[S");
        NAME_MAPPINGS.put(int[].class, "[I");
        NAME_MAPPINGS.put(int[][].class, "[[I");
        NAME_MAPPINGS.put(long[].class, "[J");
        NAME_MAPPINGS.put(long[][].class, "[[J");
        NAME_MAPPINGS.put(float[].class, "[F");
        NAME_MAPPINGS.put(float[][].class, "[[F");
        NAME_MAPPINGS.put(double[].class, "[D");
        NAME_MAPPINGS.put(double[][].class, "[[D");
        NAME_MAPPINGS.put(char[].class, "[C");
        NAME_MAPPINGS.put(char[][].class, "[[C");
        NAME_MAPPINGS.put(boolean[].class, "[Z");
        NAME_MAPPINGS.put(boolean[][].class, "[[Z");
        NAME_MAPPINGS.put(Byte[].class, "[Byte");
        NAME_MAPPINGS.put(Byte[][].class, "[[Byte");
        NAME_MAPPINGS.put(Short[].class, "[Short");
        NAME_MAPPINGS.put(Short[][].class, "[[Short");
        NAME_MAPPINGS.put(Integer[].class, "[Integer");
        NAME_MAPPINGS.put(Integer[][].class, "[[Integer");
        NAME_MAPPINGS.put(Long[].class, "[Long");
        NAME_MAPPINGS.put(Long[][].class, "[[Long");
        NAME_MAPPINGS.put(Float[].class, "[Float");
        NAME_MAPPINGS.put(Float[][].class, "[[Float");
        NAME_MAPPINGS.put(Double[].class, "[Double");
        NAME_MAPPINGS.put(Double[][].class, "[[Double");
        NAME_MAPPINGS.put(Character[].class, "[Character");
        NAME_MAPPINGS.put(Character[][].class, "[[Character");
        NAME_MAPPINGS.put(Boolean[].class, "[Boolean");
        NAME_MAPPINGS.put(Boolean[][].class, "[[Boolean");
        NAME_MAPPINGS.put(String[].class, "[String");
        NAME_MAPPINGS.put(String[][].class, "[[String");
        NAME_MAPPINGS.put(BigDecimal[].class, "[BigDecimal");
        NAME_MAPPINGS.put(BigDecimal[][].class, "[[BigDecimal");
        NAME_MAPPINGS.put(BigInteger[].class, "[BigInteger");
        NAME_MAPPINGS.put(BigInteger[][].class, "[[BigInteger");
        NAME_MAPPINGS.put(UUID[].class, "[UUID");
        NAME_MAPPINGS.put(UUID[][].class, "[[UUID");
        NAME_MAPPINGS.put(Object.class, "Object");
        NAME_MAPPINGS.put(HashMap.class, "M");
        TYPE_MAPPINGS.put("HashMap", HashMap.class);
        TYPE_MAPPINGS.put("java.util.HashMap", HashMap.class);
        NAME_MAPPINGS.put(LinkedHashMap.class, "LM");
        TYPE_MAPPINGS.put("LinkedHashMap", LinkedHashMap.class);
        TYPE_MAPPINGS.put("java.util.LinkedHashMap", LinkedHashMap.class);
        NAME_MAPPINGS.put(TreeMap.class, "TM");
        TYPE_MAPPINGS.put("TreeMap", TreeMap.class);
        NAME_MAPPINGS.put(ArrayList.class, "A");
        TYPE_MAPPINGS.put("ArrayList", ArrayList.class);
        TYPE_MAPPINGS.put("java.util.ArrayList", ArrayList.class);
        NAME_MAPPINGS.put(LinkedList.class, "LA");
        TYPE_MAPPINGS.put("LA", LinkedList.class);
        TYPE_MAPPINGS.put("LinkedList", LinkedList.class);
        TYPE_MAPPINGS.put("java.util.LinkedList", LinkedList.class);
        TYPE_MAPPINGS.put("java.util.concurrent.ConcurrentLinkedQueue", ConcurrentLinkedQueue.class);
        TYPE_MAPPINGS.put("java.util.concurrent.ConcurrentLinkedDeque", ConcurrentLinkedDeque.class);
        NAME_MAPPINGS.put(HashSet.class, "HashSet");
        NAME_MAPPINGS.put(TreeSet.class, "TreeSet");
        NAME_MAPPINGS.put(LinkedHashSet.class, "LinkedHashSet");
        NAME_MAPPINGS.put(ConcurrentHashMap.class, "ConcurrentHashMap");
        NAME_MAPPINGS.put(ConcurrentLinkedQueue.class, "ConcurrentLinkedQueue");
        NAME_MAPPINGS.put(ConcurrentLinkedDeque.class, "ConcurrentLinkedDeque");
        NAME_MAPPINGS.put(JSONObject.class, "JSONObject");
        NAME_MAPPINGS.put(JSONArray.class, "JSONArray");
        NAME_MAPPINGS.put(Currency.class, "Currency");
        NAME_MAPPINGS.put(TimeUnit.class, "TimeUnit");
        Class[] classArray = classes = new Class[]{Object.class, Cloneable.class, AutoCloseable.class, Exception.class, RuntimeException.class, IllegalAccessError.class, IllegalAccessException.class, IllegalArgumentException.class, IllegalMonitorStateException.class, IllegalStateException.class, IllegalThreadStateException.class, IndexOutOfBoundsException.class, InstantiationError.class, InstantiationException.class, InternalError.class, InterruptedException.class, LinkageError.class, NegativeArraySizeException.class, NoClassDefFoundError.class, NoSuchFieldError.class, NoSuchFieldException.class, NoSuchMethodError.class, NoSuchMethodException.class, NullPointerException.class, NumberFormatException.class, OutOfMemoryError.class, SecurityException.class, StackOverflowError.class, StringIndexOutOfBoundsException.class, TypeNotPresentException.class, VerifyError.class, StackTraceElement.class, Hashtable.class, TreeMap.class, IdentityHashMap.class, WeakHashMap.class, HashSet.class, LinkedHashSet.class, TreeSet.class, LinkedList.class, TimeUnit.class, ConcurrentHashMap.class, AtomicInteger.class, AtomicLong.class, Collections.EMPTY_MAP.getClass(), Boolean.class, Character.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Number.class, String.class, BigDecimal.class, BigInteger.class, BitSet.class, Calendar.class, Date.class, Locale.class, UUID.class, Currency.class, SimpleDateFormat.class, JSONObject.class, JSONArray.class, ConcurrentSkipListMap.class, ConcurrentSkipListSet.class};
        int n = classArray.length;
        boolean bl = false;
        while (var3_7 < n) {
            Class clazz = classArray[var3_7];
            TYPE_MAPPINGS.put(clazz.getSimpleName(), clazz);
            TYPE_MAPPINGS.put(clazz.getName(), clazz);
            NAME_MAPPINGS.put(clazz, clazz.getSimpleName());
            ++var3_7;
        }
        TYPE_MAPPINGS.put("JO10", JSONObject1O.class);
        TYPE_MAPPINGS.put("[O", Object[].class);
        TYPE_MAPPINGS.put("[Ljava.lang.Object;", Object[].class);
        TYPE_MAPPINGS.put("[java.lang.Object", Object[].class);
        TYPE_MAPPINGS.put("[Object", Object[].class);
        TYPE_MAPPINGS.put("StackTraceElement", StackTraceElement.class);
        TYPE_MAPPINGS.put("[StackTraceElement", StackTraceElement[].class);
        String[] items = new String[]{"java.util.Collections$UnmodifiableMap", "java.util.Collections$UnmodifiableCollection"};
        for (String className : items) {
            Class clazz = TypeUtils.loadClass(className);
            TYPE_MAPPINGS.put(clazz.getName(), clazz);
        }
        if (CLASS_JSON_OBJECT_1x != null) {
            TYPE_MAPPINGS.putIfAbsent("JO1", CLASS_JSON_OBJECT_1x);
            TYPE_MAPPINGS.putIfAbsent(CLASS_JSON_OBJECT_1x.getName(), CLASS_JSON_OBJECT_1x);
        }
        if (CLASS_JSON_ARRAY_1x != null) {
            TYPE_MAPPINGS.putIfAbsent("JA1", CLASS_JSON_ARRAY_1x);
            TYPE_MAPPINGS.putIfAbsent(CLASS_JSON_ARRAY_1x.getName(), CLASS_JSON_ARRAY_1x);
        }
        NAME_MAPPINGS.put(new HashMap().keySet().getClass(), "Set");
        NAME_MAPPINGS.put(new LinkedHashMap().keySet().getClass(), "Set");
        NAME_MAPPINGS.put(new TreeMap().keySet().getClass(), "Set");
        NAME_MAPPINGS.put(new ConcurrentHashMap().keySet().getClass(), "Set");
        NAME_MAPPINGS.put(new ConcurrentSkipListMap().keySet().getClass(), "Set");
        TYPE_MAPPINGS.put("Set", HashSet.class);
        NAME_MAPPINGS.put(new HashMap().values().getClass(), "List");
        NAME_MAPPINGS.put(new LinkedHashMap().values().getClass(), "List");
        NAME_MAPPINGS.put(new TreeMap().values().getClass(), "List");
        NAME_MAPPINGS.put(new ConcurrentHashMap().values().getClass(), "List");
        NAME_MAPPINGS.put(new ConcurrentSkipListMap().values().getClass(), "List");
        TYPE_MAPPINGS.put("List", ArrayList.class);
        TYPE_MAPPINGS.put("java.util.ImmutableCollections$Map1", HashMap.class);
        TYPE_MAPPINGS.put("java.util.ImmutableCollections$MapN", LinkedHashMap.class);
        TYPE_MAPPINGS.put("java.util.ImmutableCollections$Set12", LinkedHashSet.class);
        TYPE_MAPPINGS.put("java.util.ImmutableCollections$SetN", LinkedHashSet.class);
        TYPE_MAPPINGS.put("java.util.ImmutableCollections$List12", ArrayList.class);
        TYPE_MAPPINGS.put("java.util.ImmutableCollections$ListN", ArrayList.class);
        TYPE_MAPPINGS.put("java.util.ImmutableCollections$SubList", ArrayList.class);
        for (Map.Entry entry : NAME_MAPPINGS.entrySet()) {
            TYPE_MAPPINGS.putIfAbsent((String)entry.getValue(), (Class)entry.getKey());
        }
        BigInteger[] bigInts = new BigInteger[128];
        bigInts[0] = BigInteger.ONE;
        bigInts[1] = BigInteger.TEN;
        long longValue = 10L;
        int n2 = 2;
        while (var3_11 < 19) {
            bigInts[var3_11] = BigInteger.valueOf(longValue *= 10L);
            ++var3_11;
        }
        BigInteger bigInteger = bigInts[18];
        for (int i = 19; i < 128; ++i) {
            void var3_13;
            BigInteger bigInteger2;
            bigInts[i] = bigInteger2 = var3_13.multiply(BigInteger.TEN);
        }
        BIG_TEN_POWERS_TABLE = bigInts;
    }

    static class X2 {
        static final String[] chars;
        static final String[] chars2;
        static final char START = ' ';
        static final char END = '~';
        static final int SIZE2 = 95;

        X2() {
        }

        static {
            String[] array0 = new String[128];
            for (char i = '\u0000'; i < array0.length; i = (char)(i + '\u0001')) {
                array0[i] = Character.toString(i);
            }
            chars = array0;
            String[] array1 = new String[9025];
            char[] c2 = new char[2];
            for (int i = 32; i <= 126; i = (int)((char)(i + 1))) {
                for (int j = 32; j <= 126; j = (int)((char)(j + 1))) {
                    int value = (i - 32) * 95 + (j - 32);
                    c2[0] = i;
                    c2[1] = j;
                    array1[value] = new String(c2);
                }
            }
            chars2 = array1;
        }
    }

    static class X1 {
        static final Function<byte[], char[]> TO_CHARS;

        X1() {
        }

        static {
            Function toChars = null;
            if (JDKUtils.JVM_VERSION > 9) {
                try {
                    Class<?> latin1Class = Class.forName("java.lang.StringLatin1");
                    MethodHandles.Lookup lookup = JDKUtils.trustedLookup(latin1Class);
                    MethodHandle handle = lookup.findStatic(latin1Class, "toChars", MethodType.methodType(char[].class, byte[].class));
                    CallSite callSite = LambdaMetafactory.metafactory(lookup, "apply", MethodType.methodType(Function.class), MethodType.methodType(Object.class, Object.class), handle, MethodType.methodType(char[].class, byte[].class));
                    toChars = callSite.getTarget().invokeExact();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (toChars == null) {
                toChars = TypeUtils::toAsciiCharArray;
            }
            TO_CHARS = toChars;
        }
    }

    static class Cache {
        volatile char[] chars;

        Cache() {
        }
    }
}

