/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.controller.impl.task;

import org.apache.rocketmq.controller.impl.heartbeat.BrokerIdentityInfo;
import org.apache.rocketmq.controller.impl.heartbeat.BrokerLiveInfo;
import org.apache.rocketmq.remoting.CommandCustomHeader;
import org.apache.rocketmq.remoting.exception.RemotingCommandException;

public class RaftBrokerHeartBeatEventRequest
implements CommandCustomHeader {
    private String clusterNameIdentityInfo;
    private String brokerNameIdentityInfo;
    private Long brokerIdIdentityInfo;
    private String brokerName;
    private String brokerAddr;
    private Long heartbeatTimeoutMillis;
    private Long brokerId;
    private Long lastUpdateTimestamp;
    private Integer epoch;
    private Long maxOffset;
    private Long confirmOffset;
    private Integer electionPriority;

    public RaftBrokerHeartBeatEventRequest() {
    }

    public RaftBrokerHeartBeatEventRequest(BrokerIdentityInfo brokerIdentityInfo, BrokerLiveInfo brokerLiveInfo) {
        this.clusterNameIdentityInfo = brokerIdentityInfo.getClusterName();
        this.brokerNameIdentityInfo = brokerIdentityInfo.getBrokerName();
        this.brokerIdIdentityInfo = brokerIdentityInfo.getBrokerId();
        this.brokerName = brokerLiveInfo.getBrokerName();
        this.brokerAddr = brokerLiveInfo.getBrokerAddr();
        this.heartbeatTimeoutMillis = brokerLiveInfo.getHeartbeatTimeoutMillis();
        this.brokerId = brokerLiveInfo.getBrokerId();
        this.lastUpdateTimestamp = brokerLiveInfo.getLastUpdateTimestamp();
        this.epoch = brokerLiveInfo.getEpoch();
        this.maxOffset = brokerLiveInfo.getMaxOffset();
        this.confirmOffset = brokerLiveInfo.getConfirmOffset();
        this.electionPriority = brokerLiveInfo.getElectionPriority();
    }

    public BrokerIdentityInfo getBrokerIdentityInfo() {
        return new BrokerIdentityInfo(this.clusterNameIdentityInfo, this.brokerNameIdentityInfo, this.brokerIdIdentityInfo);
    }

    public void setBrokerIdentityInfo(BrokerIdentityInfo brokerIdentityInfo) {
        this.clusterNameIdentityInfo = brokerIdentityInfo.getClusterName();
        this.brokerNameIdentityInfo = brokerIdentityInfo.getBrokerName();
        this.brokerIdIdentityInfo = brokerIdentityInfo.getBrokerId();
    }

    public BrokerLiveInfo getBrokerLiveInfo() {
        return new BrokerLiveInfo(this.brokerName, this.brokerAddr, this.brokerId, this.lastUpdateTimestamp, this.heartbeatTimeoutMillis, null, this.epoch, this.maxOffset, this.electionPriority, this.confirmOffset);
    }

    public void setBrokerLiveInfo(BrokerLiveInfo brokerLiveInfo) {
        this.brokerName = brokerLiveInfo.getBrokerName();
        this.brokerAddr = brokerLiveInfo.getBrokerAddr();
        this.heartbeatTimeoutMillis = brokerLiveInfo.getHeartbeatTimeoutMillis();
        this.brokerId = brokerLiveInfo.getBrokerId();
        this.lastUpdateTimestamp = brokerLiveInfo.getLastUpdateTimestamp();
        this.epoch = brokerLiveInfo.getEpoch();
        this.maxOffset = brokerLiveInfo.getMaxOffset();
        this.confirmOffset = brokerLiveInfo.getConfirmOffset();
        this.electionPriority = brokerLiveInfo.getElectionPriority();
    }

    public void checkFields() throws RemotingCommandException {
    }

    public String toString() {
        return "RaftBrokerHeartBeatEventRequest{brokerIdentityInfo=" + this.getBrokerIdentityInfo() + ", brokerLiveInfo=" + this.getBrokerLiveInfo() + "}";
    }
}

