/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.out;

import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.consumer.PullResult;
import org.apache.rocketmq.client.consumer.PullStatus;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.impl.consumer.PullResultExt;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.SendStatus;
import org.apache.rocketmq.common.AbstractBrokerRunnable;
import org.apache.rocketmq.common.BrokerIdentity;
import org.apache.rocketmq.common.LockCallback;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.Pair;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.common.UnlockCallback;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageAccessor;
import org.apache.rocketmq.common.message.MessageBatch;
import org.apache.rocketmq.common.message.MessageClientIDSetter;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.common.namesrv.DefaultTopAddressing;
import org.apache.rocketmq.common.namesrv.TopAddressing;
import org.apache.rocketmq.common.sysflag.PullSysFlag;
import org.apache.rocketmq.common.utils.ThreadUtils;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.CommandCustomHeader;
import org.apache.rocketmq.remoting.InvokeCallback;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.remoting.RemotingClient;
import org.apache.rocketmq.remoting.exception.RemotingCommandException;
import org.apache.rocketmq.remoting.exception.RemotingConnectException;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.apache.rocketmq.remoting.exception.RemotingSendRequestException;
import org.apache.rocketmq.remoting.exception.RemotingTimeoutException;
import org.apache.rocketmq.remoting.exception.RemotingTooMuchRequestException;
import org.apache.rocketmq.remoting.netty.NettyClientConfig;
import org.apache.rocketmq.remoting.netty.NettyRemotingClient;
import org.apache.rocketmq.remoting.netty.ResponseFuture;
import org.apache.rocketmq.remoting.protocol.BrokerSyncInfo;
import org.apache.rocketmq.remoting.protocol.DataVersion;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.remoting.protocol.RemotingSerializable;
import org.apache.rocketmq.remoting.protocol.body.BrokerMemberGroup;
import org.apache.rocketmq.remoting.protocol.body.ClusterInfo;
import org.apache.rocketmq.remoting.protocol.body.ConsumerOffsetSerializeWrapper;
import org.apache.rocketmq.remoting.protocol.body.ElectMasterResponseBody;
import org.apache.rocketmq.remoting.protocol.body.GetBrokerMemberGroupResponseBody;
import org.apache.rocketmq.remoting.protocol.body.KVTable;
import org.apache.rocketmq.remoting.protocol.body.LockBatchRequestBody;
import org.apache.rocketmq.remoting.protocol.body.LockBatchResponseBody;
import org.apache.rocketmq.remoting.protocol.body.MessageRequestModeSerializeWrapper;
import org.apache.rocketmq.remoting.protocol.body.RegisterBrokerBody;
import org.apache.rocketmq.remoting.protocol.body.SubscriptionGroupWrapper;
import org.apache.rocketmq.remoting.protocol.body.SyncStateSet;
import org.apache.rocketmq.remoting.protocol.body.TopicConfigAndMappingSerializeWrapper;
import org.apache.rocketmq.remoting.protocol.body.TopicConfigSerializeWrapper;
import org.apache.rocketmq.remoting.protocol.body.UnlockBatchRequestBody;
import org.apache.rocketmq.remoting.protocol.header.ExchangeHAInfoRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.ExchangeHAInfoResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.GetBrokerMemberGroupRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.GetMaxOffsetRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.GetMaxOffsetResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.GetMinOffsetRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.GetMinOffsetResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.LockBatchMqRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.PullMessageRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.PullMessageResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.SendMessageRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.SendMessageRequestHeaderV2;
import org.apache.rocketmq.remoting.protocol.header.SendMessageResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.UnlockBatchMqRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.AlterSyncStateSetRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.ElectMasterRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.ElectMasterResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.GetMetaDataResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.GetReplicaInfoRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.GetReplicaInfoResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.register.ApplyBrokerIdRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.register.ApplyBrokerIdResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.register.GetNextBrokerIdRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.register.GetNextBrokerIdResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.register.RegisterBrokerToControllerRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.register.RegisterBrokerToControllerResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.namesrv.BrokerHeartbeatRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.namesrv.GetRouteInfoRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.namesrv.QueryDataVersionRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.namesrv.QueryDataVersionResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.namesrv.RegisterBrokerRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.namesrv.RegisterBrokerResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.namesrv.RegisterTopicRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.namesrv.UnRegisterBrokerRequestHeader;
import org.apache.rocketmq.remoting.protocol.namesrv.RegisterBrokerResult;
import org.apache.rocketmq.remoting.protocol.route.BrokerData;
import org.apache.rocketmq.remoting.protocol.route.QueueData;
import org.apache.rocketmq.remoting.protocol.route.TopicRouteData;
import org.apache.rocketmq.remoting.rpc.ClientMetadata;
import org.apache.rocketmq.remoting.rpc.RpcClient;
import org.apache.rocketmq.remoting.rpc.RpcClientImpl;
import org.apache.rocketmq.remoting.rpchook.DynamicalExtFieldRPCHook;
import org.apache.rocketmq.store.timer.TimerCheckpoint;
import org.apache.rocketmq.store.timer.TimerMetrics;

public class BrokerOuterAPI {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"RocketmqBroker");
    private final RemotingClient remotingClient;
    private final TopAddressing topAddressing = new DefaultTopAddressing(MixAll.getWSAddr());
    private final ExecutorService brokerOuterExecutor = ThreadUtils.newThreadPoolExecutor((int)4, (int)10, (long)1L, (TimeUnit)TimeUnit.MINUTES, new ArrayBlockingQueue(32), (ThreadFactory)new ThreadFactoryImpl("brokerOutApi_thread_", true));
    private final ClientMetadata clientMetadata;
    private final RpcClient rpcClient;
    private String nameSrvAddr = null;

    public BrokerOuterAPI(NettyClientConfig nettyClientConfig) {
        this(nettyClientConfig, (RPCHook)new DynamicalExtFieldRPCHook(), new ClientMetadata());
    }

    private BrokerOuterAPI(NettyClientConfig nettyClientConfig, RPCHook rpcHook, ClientMetadata clientMetadata) {
        this.remotingClient = new NettyRemotingClient(nettyClientConfig);
        this.clientMetadata = clientMetadata;
        this.remotingClient.registerRPCHook(rpcHook);
        this.rpcClient = new RpcClientImpl(this.clientMetadata, this.remotingClient);
    }

    public void start() {
        this.remotingClient.start();
    }

    public void shutdown() {
        this.remotingClient.shutdown();
        this.brokerOuterExecutor.shutdown();
    }

    public List<String> getNameServerAddressList() {
        return this.remotingClient.getNameServerAddressList();
    }

    public String fetchNameServerAddr() {
        try {
            String addrs = this.topAddressing.fetchNSAddr();
            if (!UtilAll.isBlank((String)addrs) && !addrs.equals(this.nameSrvAddr)) {
                LOGGER.info("name server address changed, old: {} new: {}", (Object)this.nameSrvAddr, (Object)addrs);
                this.updateNameServerAddressList(addrs);
                this.nameSrvAddr = addrs;
                return this.nameSrvAddr;
            }
        }
        catch (Exception e) {
            LOGGER.error("fetchNameServerAddr Exception", (Throwable)e);
        }
        return this.nameSrvAddr;
    }

    public List<String> dnsLookupAddressByDomain(String domain) {
        ArrayList<String> addressList = new ArrayList<String>();
        try {
            InetAddress[] addresses;
            Security.setProperty("networkaddress.cache.ttl", "10");
            int index = domain.indexOf(":");
            String portStr = domain.substring(index);
            String domainStr = domain.substring(0, index);
            for (InetAddress address : addresses = InetAddress.getAllByName(domainStr)) {
                addressList.add(address.getHostAddress() + portStr);
            }
            LOGGER.info("dns lookup address by domain success, domain={}, result={}", (Object)domain, addressList);
        }
        catch (Exception e) {
            LOGGER.error("dns lookup address by domain error, domain={}", (Object)domain, (Object)e);
        }
        return addressList;
    }

    public boolean checkAddressReachable(String address) {
        return this.remotingClient.isAddressReachable(address);
    }

    public void updateNameServerAddressList(String addrs) {
        String[] addrArray = addrs.split(";");
        ArrayList<String> lst = new ArrayList<String>(Arrays.asList(addrArray));
        this.remotingClient.updateNameServerAddressList(lst);
    }

    public void updateNameServerAddressListByDnsLookup(String domain) {
        List<String> lst = this.dnsLookupAddressByDomain(domain);
        this.remotingClient.updateNameServerAddressList(lst);
    }

    public BrokerMemberGroup syncBrokerMemberGroup(String clusterName, String brokerName) throws InterruptedException, RemotingTimeoutException, RemotingSendRequestException, RemotingConnectException {
        return this.syncBrokerMemberGroup(clusterName, brokerName, false);
    }

    public BrokerMemberGroup syncBrokerMemberGroup(String clusterName, String brokerName, boolean isCompatibleWithOldNameSrv) throws InterruptedException, RemotingTimeoutException, RemotingSendRequestException, RemotingConnectException {
        if (isCompatibleWithOldNameSrv) {
            return this.getBrokerMemberGroupCompatible(clusterName, brokerName);
        }
        return this.getBrokerMemberGroup(clusterName, brokerName);
    }

    public BrokerMemberGroup getBrokerMemberGroup(String clusterName, String brokerName) throws InterruptedException, RemotingTimeoutException, RemotingSendRequestException, RemotingConnectException {
        BrokerMemberGroup brokerMemberGroup = new BrokerMemberGroup(clusterName, brokerName);
        GetBrokerMemberGroupRequestHeader requestHeader = new GetBrokerMemberGroupRequestHeader();
        requestHeader.setClusterName(clusterName);
        requestHeader.setBrokerName(brokerName);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)901, (CommandCustomHeader)requestHeader);
        RemotingCommand response = null;
        response = this.remotingClient.invokeSync(null, request, 3000L);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                byte[] body = response.getBody();
                if (body == null) break;
                GetBrokerMemberGroupResponseBody brokerMemberGroupResponseBody = (GetBrokerMemberGroupResponseBody)GetBrokerMemberGroupResponseBody.decode((byte[])body, GetBrokerMemberGroupResponseBody.class);
                return brokerMemberGroupResponseBody.getBrokerMemberGroup();
            }
        }
        return brokerMemberGroup;
    }

    public BrokerMemberGroup getBrokerMemberGroupCompatible(String clusterName, String brokerName) throws InterruptedException, RemotingTimeoutException, RemotingSendRequestException, RemotingConnectException {
        BrokerMemberGroup brokerMemberGroup = new BrokerMemberGroup(clusterName, brokerName);
        GetRouteInfoRequestHeader requestHeader = new GetRouteInfoRequestHeader();
        requestHeader.setTopic("rmq_sys_SYNC_BROKER_MEMBER_" + brokerName);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)105, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(null, request, 3000L);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                byte[] body = response.getBody();
                if (body == null) break;
                TopicRouteData topicRouteData = (TopicRouteData)TopicRouteData.decode((byte[])body, TopicRouteData.class);
                for (BrokerData brokerData : topicRouteData.getBrokerDatas()) {
                    if (brokerData == null || !brokerData.getBrokerName().equals(brokerName) || !brokerData.getCluster().equals(clusterName)) continue;
                    brokerMemberGroup.getBrokerAddrs().putAll(brokerData.getBrokerAddrs());
                    break;
                }
                return brokerMemberGroup;
            }
        }
        return brokerMemberGroup;
    }

    public void sendHeartbeatViaDataVersion(String clusterName, String brokerAddr, String brokerName, Long brokerId, final int timeoutMillis, final DataVersion dataVersion, boolean isInBrokerContainer) {
        List nameServerAddressList = this.remotingClient.getAvailableNameSrvList();
        if (nameServerAddressList != null && nameServerAddressList.size() > 0) {
            final QueryDataVersionRequestHeader requestHeader = new QueryDataVersionRequestHeader();
            requestHeader.setBrokerAddr(brokerAddr);
            requestHeader.setBrokerName(brokerName);
            requestHeader.setBrokerId(brokerId);
            requestHeader.setClusterName(clusterName);
            for (final String namesrvAddr : nameServerAddressList) {
                this.brokerOuterExecutor.execute((Runnable)new AbstractBrokerRunnable(new BrokerIdentity(clusterName, brokerName, brokerId.longValue(), isInBrokerContainer)){

                    public void run0() {
                        RemotingCommand request = RemotingCommand.createRequestCommand((int)322, (CommandCustomHeader)requestHeader);
                        request.setBody(dataVersion.encode());
                        try {
                            BrokerOuterAPI.this.remotingClient.invokeOneway(namesrvAddr, request, (long)timeoutMillis);
                        }
                        catch (Exception e) {
                            LOGGER.error("sendHeartbeat Exception " + namesrvAddr, (Throwable)e);
                        }
                    }
                });
            }
        }
    }

    public void sendHeartbeat(String clusterName, String brokerAddr, String brokerName, Long brokerId, final int timeoutMills, boolean isInBrokerContainer) {
        List nameServerAddressList = this.remotingClient.getAvailableNameSrvList();
        final BrokerHeartbeatRequestHeader requestHeader = new BrokerHeartbeatRequestHeader();
        requestHeader.setClusterName(clusterName);
        requestHeader.setBrokerAddr(brokerAddr);
        requestHeader.setBrokerName(brokerName);
        if (nameServerAddressList != null && nameServerAddressList.size() > 0) {
            for (final String namesrvAddr : nameServerAddressList) {
                this.brokerOuterExecutor.execute((Runnable)new AbstractBrokerRunnable(new BrokerIdentity(clusterName, brokerName, brokerId.longValue(), isInBrokerContainer)){

                    public void run0() {
                        RemotingCommand request = RemotingCommand.createRequestCommand((int)904, (CommandCustomHeader)requestHeader);
                        try {
                            BrokerOuterAPI.this.remotingClient.invokeOneway(namesrvAddr, request, (long)timeoutMills);
                        }
                        catch (Exception e) {
                            LOGGER.error("sendHeartbeat Exception " + namesrvAddr, (Throwable)e);
                        }
                    }
                });
            }
        }
    }

    public BrokerSyncInfo retrieveBrokerHaInfo(String masterBrokerAddr) throws InterruptedException, RemotingTimeoutException, RemotingSendRequestException, RemotingConnectException, MQBrokerException, RemotingCommandException {
        ExchangeHAInfoRequestHeader requestHeader = new ExchangeHAInfoRequestHeader();
        requestHeader.setMasterHaAddress(null);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)906, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(masterBrokerAddr, request, 3000L);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                ExchangeHAInfoResponseHeader responseHeader = (ExchangeHAInfoResponseHeader)response.decodeCommandCustomHeader(ExchangeHAInfoResponseHeader.class);
                return new BrokerSyncInfo(responseHeader.getMasterHaAddress(), responseHeader.getMasterFlushOffset().longValue(), responseHeader.getMasterAddress());
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark());
    }

    public void sendBrokerHaInfo(String brokerAddr, String masterHaAddr, long brokerInitMaxOffset, String masterAddr) throws InterruptedException, RemotingTimeoutException, RemotingSendRequestException, RemotingConnectException, MQBrokerException {
        ExchangeHAInfoRequestHeader requestHeader = new ExchangeHAInfoRequestHeader();
        requestHeader.setMasterHaAddress(masterHaAddr);
        requestHeader.setMasterFlushOffset(Long.valueOf(brokerInitMaxOffset));
        requestHeader.setMasterAddress(masterAddr);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)906, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(brokerAddr, request, 3000L);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                return;
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark());
    }

    public List<RegisterBrokerResult> registerBrokerAll(String clusterName, String brokerAddr, String brokerName, long brokerId, String haServerAddr, TopicConfigSerializeWrapper topicConfigWrapper, List<String> filterServerList, boolean oneway, int timeoutMills, boolean enableActingMaster, boolean compressed, BrokerIdentity brokerIdentity) {
        return this.registerBrokerAll(clusterName, brokerAddr, brokerName, brokerId, haServerAddr, topicConfigWrapper, filterServerList, oneway, timeoutMills, enableActingMaster, compressed, null, brokerIdentity);
    }

    public List<RegisterBrokerResult> registerBrokerAll(String clusterName, String brokerAddr, String brokerName, long brokerId, String haServerAddr, TopicConfigSerializeWrapper topicConfigWrapper, List<String> filterServerList, final boolean oneway, final int timeoutMills, boolean enableActingMaster, boolean compressed, Long heartbeatTimeoutMillis, BrokerIdentity brokerIdentity) {
        final CopyOnWriteArrayList<RegisterBrokerResult> registerBrokerResultList = new CopyOnWriteArrayList<RegisterBrokerResult>();
        List nameServerAddressList = this.remotingClient.getAvailableNameSrvList();
        if (nameServerAddressList != null && nameServerAddressList.size() > 0) {
            final RegisterBrokerRequestHeader requestHeader = new RegisterBrokerRequestHeader();
            requestHeader.setBrokerAddr(brokerAddr);
            requestHeader.setBrokerId(Long.valueOf(brokerId));
            requestHeader.setBrokerName(brokerName);
            requestHeader.setClusterName(clusterName);
            requestHeader.setHaServerAddr(haServerAddr);
            requestHeader.setEnableActingMaster(Boolean.valueOf(enableActingMaster));
            requestHeader.setCompressed(false);
            if (heartbeatTimeoutMillis != null) {
                requestHeader.setHeartbeatTimeoutMillis(heartbeatTimeoutMillis);
            }
            RegisterBrokerBody requestBody = new RegisterBrokerBody();
            requestBody.setTopicConfigSerializeWrapper(TopicConfigAndMappingSerializeWrapper.from((TopicConfigSerializeWrapper)topicConfigWrapper));
            requestBody.setFilterServerList(filterServerList);
            final byte[] body = requestBody.encode(compressed);
            int bodyCrc32 = UtilAll.crc32((byte[])body);
            requestHeader.setBodyCrc32(Integer.valueOf(bodyCrc32));
            final CountDownLatch countDownLatch = new CountDownLatch(nameServerAddressList.size());
            for (final String namesrvAddr : nameServerAddressList) {
                this.brokerOuterExecutor.execute((Runnable)new AbstractBrokerRunnable(brokerIdentity){

                    public void run0() {
                        try {
                            RegisterBrokerResult result = BrokerOuterAPI.this.registerBroker(namesrvAddr, oneway, timeoutMills, requestHeader, body);
                            if (result != null) {
                                registerBrokerResultList.add(result);
                            }
                            LOGGER.info("Registering current broker to name server completed. TargetHost={}", (Object)namesrvAddr);
                        }
                        catch (Exception e) {
                            LOGGER.error("Failed to register current broker to name server. TargetHost={}", (Object)namesrvAddr, (Object)e);
                        }
                        finally {
                            countDownLatch.countDown();
                        }
                    }
                });
            }
            try {
                if (!countDownLatch.await(timeoutMills, TimeUnit.MILLISECONDS)) {
                    LOGGER.warn("Registration to one or more name servers does NOT complete within deadline. Timeout threshold: {}ms", (Object)timeoutMills);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return registerBrokerResultList;
    }

    private RegisterBrokerResult registerBroker(String namesrvAddr, boolean oneway, int timeoutMills, RegisterBrokerRequestHeader requestHeader, byte[] body) throws RemotingCommandException, MQBrokerException, RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, InterruptedException {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)103, (CommandCustomHeader)requestHeader);
        request.setBody(body);
        if (oneway) {
            try {
                this.remotingClient.invokeOneway(namesrvAddr, request, (long)timeoutMills);
            }
            catch (RemotingTooMuchRequestException remotingTooMuchRequestException) {
                // empty catch block
            }
            return null;
        }
        RemotingCommand response = this.remotingClient.invokeSync(namesrvAddr, request, (long)timeoutMills);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                RegisterBrokerResponseHeader responseHeader = (RegisterBrokerResponseHeader)response.decodeCommandCustomHeader(RegisterBrokerResponseHeader.class);
                RegisterBrokerResult result = new RegisterBrokerResult();
                result.setMasterAddr(responseHeader.getMasterAddr());
                result.setHaServerAddr(responseHeader.getHaServerAddr());
                if (response.getBody() != null) {
                    result.setKvTable((KVTable)KVTable.decode((byte[])response.getBody(), KVTable.class));
                }
                return result;
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark(), requestHeader == null ? null : requestHeader.getBrokerAddr());
    }

    public void unregisterBrokerAll(String clusterName, String brokerAddr, String brokerName, long brokerId) {
        List nameServerAddressList = this.remotingClient.getNameServerAddressList();
        if (nameServerAddressList != null) {
            for (String namesrvAddr : nameServerAddressList) {
                try {
                    this.unregisterBroker(namesrvAddr, clusterName, brokerAddr, brokerName, brokerId);
                    LOGGER.info("unregisterBroker OK, NamesrvAddr: {}", (Object)namesrvAddr);
                }
                catch (Exception e) {
                    LOGGER.warn("unregisterBroker Exception, NamesrvAddr: {}", (Object)namesrvAddr, (Object)e);
                }
            }
        }
    }

    public void unregisterBroker(String namesrvAddr, String clusterName, String brokerAddr, String brokerName, long brokerId) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, InterruptedException, MQBrokerException {
        UnRegisterBrokerRequestHeader requestHeader = new UnRegisterBrokerRequestHeader();
        requestHeader.setBrokerAddr(brokerAddr);
        requestHeader.setBrokerId(Long.valueOf(brokerId));
        requestHeader.setBrokerName(brokerName);
        requestHeader.setClusterName(clusterName);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)104, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(namesrvAddr, request, 3000L);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                return;
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark(), brokerAddr);
    }

    public void registerSingleTopicAll(String brokerName, TopicConfig topicConfig, int timeoutMills) {
        String topic = topicConfig.getTopicName();
        RegisterTopicRequestHeader requestHeader = new RegisterTopicRequestHeader();
        requestHeader.setTopic(topic);
        TopicRouteData topicRouteData = new TopicRouteData();
        ArrayList<QueueData> queueDatas = new ArrayList<QueueData>();
        topicRouteData.setQueueDatas(queueDatas);
        QueueData queueData = new QueueData();
        queueData.setBrokerName(brokerName);
        queueData.setPerm(topicConfig.getPerm());
        queueData.setReadQueueNums(topicConfig.getReadQueueNums());
        queueData.setWriteQueueNums(topicConfig.getWriteQueueNums());
        queueData.setTopicSysFlag(topicConfig.getTopicSysFlag());
        queueDatas.add(queueData);
        byte[] topicRouteBody = topicRouteData.encode();
        List nameServerAddressList = this.remotingClient.getNameServerAddressList();
        CountDownLatch countDownLatch = new CountDownLatch(nameServerAddressList.size());
        for (String namesrvAddr : nameServerAddressList) {
            RemotingCommand request = RemotingCommand.createRequestCommand((int)217, (CommandCustomHeader)requestHeader);
            request.setBody(topicRouteBody);
            try {
                this.brokerOuterExecutor.execute(() -> {
                    try {
                        RemotingCommand response = this.remotingClient.invokeSync(namesrvAddr, request, (long)timeoutMills);
                        assert (response != null);
                        LOGGER.info("Register single topic {} to broker {} with response code {}", new Object[]{topic, brokerName, response.getCode()});
                    }
                    catch (Exception e) {
                        LOGGER.warn("Register single topic {} to broker {} exception", new Object[]{topic, brokerName, e});
                    }
                    finally {
                        countDownLatch.countDown();
                    }
                });
            }
            catch (Exception e) {
                LOGGER.warn("Execute single topic registration task failed, topic {}, broker name {}", (Object)topic, (Object)brokerName);
                countDownLatch.countDown();
            }
        }
        try {
            if (!countDownLatch.await(timeoutMills, TimeUnit.MILLISECONDS)) {
                LOGGER.warn("Registration single topic to one or more name servers timeout. Timeout threshold: {}ms", (Object)timeoutMills);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public List<Boolean> needRegister(final String clusterName, final String brokerAddr, final String brokerName, final long brokerId, final TopicConfigSerializeWrapper topicConfigWrapper, final int timeoutMills, boolean isInBrokerContainer) {
        final CopyOnWriteArrayList<Boolean> changedList = new CopyOnWriteArrayList<Boolean>();
        List nameServerAddressList = this.remotingClient.getNameServerAddressList();
        if (nameServerAddressList != null && nameServerAddressList.size() > 0) {
            final CountDownLatch countDownLatch = new CountDownLatch(nameServerAddressList.size());
            for (final String namesrvAddr : nameServerAddressList) {
                this.brokerOuterExecutor.execute((Runnable)new AbstractBrokerRunnable(new BrokerIdentity(clusterName, brokerName, brokerId, isInBrokerContainer)){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run0() {
                        try {
                            QueryDataVersionRequestHeader requestHeader = new QueryDataVersionRequestHeader();
                            requestHeader.setBrokerAddr(brokerAddr);
                            requestHeader.setBrokerId(Long.valueOf(brokerId));
                            requestHeader.setBrokerName(brokerName);
                            requestHeader.setClusterName(clusterName);
                            RemotingCommand request = RemotingCommand.createRequestCommand((int)322, (CommandCustomHeader)requestHeader);
                            request.setBody(topicConfigWrapper.getDataVersion().encode());
                            RemotingCommand response = BrokerOuterAPI.this.remotingClient.invokeSync(namesrvAddr, request, (long)timeoutMills);
                            DataVersion nameServerDataVersion = null;
                            Boolean changed = false;
                            switch (response.getCode()) {
                                case 0: {
                                    QueryDataVersionResponseHeader queryDataVersionResponseHeader = (QueryDataVersionResponseHeader)response.decodeCommandCustomHeader(QueryDataVersionResponseHeader.class);
                                    changed = queryDataVersionResponseHeader.getChanged();
                                    byte[] body = response.getBody();
                                    if (body != null) {
                                        nameServerDataVersion = (DataVersion)DataVersion.decode((byte[])body, DataVersion.class);
                                        if (!topicConfigWrapper.getDataVersion().equals((Object)nameServerDataVersion)) {
                                            changed = true;
                                        }
                                    }
                                    if (changed != null && !changed.booleanValue()) break;
                                    changedList.add(Boolean.TRUE);
                                }
                            }
                            LOGGER.warn("Query data version from name server {} OK, changed {}, broker {}, name server {}", new Object[]{namesrvAddr, changed, topicConfigWrapper.getDataVersion(), nameServerDataVersion == null ? "" : nameServerDataVersion});
                        }
                        catch (Exception e) {
                            changedList.add(Boolean.TRUE);
                            LOGGER.error("Query data version from name server {} exception", (Object)namesrvAddr, (Object)e);
                        }
                        finally {
                            countDownLatch.countDown();
                        }
                    }
                });
            }
            try {
                countDownLatch.await(timeoutMills, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                LOGGER.error("query dataversion from nameserver countDownLatch await Exception", (Throwable)e);
            }
        }
        return changedList;
    }

    public TopicConfigAndMappingSerializeWrapper getAllTopicConfig(String addr) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, InterruptedException, MQBrokerException {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)21, null);
        RemotingCommand response = this.remotingClient.invokeSync(MixAll.brokerVIPChannel((boolean)true, (String)addr), request, 3000L);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                return (TopicConfigAndMappingSerializeWrapper)TopicConfigSerializeWrapper.decode((byte[])response.getBody(), TopicConfigAndMappingSerializeWrapper.class);
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark(), addr);
    }

    public TimerCheckpoint getTimerCheckPoint(String addr) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, InterruptedException, MQBrokerException {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)60, null);
        RemotingCommand response = this.remotingClient.invokeSync(MixAll.brokerVIPChannel((boolean)true, (String)addr), request, 3000L);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                return TimerCheckpoint.decode((ByteBuffer)ByteBuffer.wrap(response.getBody()));
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark(), addr);
    }

    public TimerMetrics.TimerMetricsSerializeWrapper getTimerMetrics(String addr) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, InterruptedException, MQBrokerException {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)61, null);
        RemotingCommand response = this.remotingClient.invokeSync(MixAll.brokerVIPChannel((boolean)true, (String)addr), request, 3000L);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                return (TimerMetrics.TimerMetricsSerializeWrapper)TimerMetrics.TimerMetricsSerializeWrapper.decode((byte[])response.getBody(), TimerMetrics.TimerMetricsSerializeWrapper.class);
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark(), addr);
    }

    public ConsumerOffsetSerializeWrapper getAllConsumerOffset(String addr) throws InterruptedException, RemotingTimeoutException, RemotingSendRequestException, RemotingConnectException, MQBrokerException {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)43, null);
        RemotingCommand response = this.remotingClient.invokeSync(addr, request, 3000L);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                return (ConsumerOffsetSerializeWrapper)ConsumerOffsetSerializeWrapper.decode((byte[])response.getBody(), ConsumerOffsetSerializeWrapper.class);
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark(), addr);
    }

    public String getAllDelayOffset(String addr) throws InterruptedException, RemotingTimeoutException, RemotingSendRequestException, RemotingConnectException, MQBrokerException, UnsupportedEncodingException {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)45, null);
        RemotingCommand response = this.remotingClient.invokeSync(addr, request, 3000L);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                return new String(response.getBody(), "UTF-8");
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark(), addr);
    }

    public SubscriptionGroupWrapper getAllSubscriptionGroupConfig(String addr) throws InterruptedException, RemotingTimeoutException, RemotingSendRequestException, RemotingConnectException, MQBrokerException {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)201, null);
        RemotingCommand response = this.remotingClient.invokeSync(addr, request, 3000L);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                return (SubscriptionGroupWrapper)SubscriptionGroupWrapper.decode((byte[])response.getBody(), SubscriptionGroupWrapper.class);
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark(), addr);
    }

    public void registerRPCHook(RPCHook rpcHook) {
        this.remotingClient.registerRPCHook(rpcHook);
    }

    public void clearRPCHook() {
        this.remotingClient.clearRPCHook();
    }

    public long getMaxOffset(String addr, String topic, int queueId, boolean committed, boolean isOnlyThisBroker) throws RemotingException, MQBrokerException, InterruptedException {
        GetMaxOffsetRequestHeader requestHeader = new GetMaxOffsetRequestHeader();
        requestHeader.setTopic(topic);
        requestHeader.setQueueId(Integer.valueOf(queueId));
        requestHeader.setCommitted(committed);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)30, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(addr, request, 3000L);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                GetMaxOffsetResponseHeader responseHeader = (GetMaxOffsetResponseHeader)response.decodeCommandCustomHeader(GetMaxOffsetResponseHeader.class);
                return responseHeader.getOffset();
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark());
    }

    public long getMinOffset(String addr, String topic, int queueId, boolean isOnlyThisBroker) throws RemotingException, MQBrokerException, InterruptedException {
        GetMinOffsetRequestHeader requestHeader = new GetMinOffsetRequestHeader();
        requestHeader.setTopic(topic);
        requestHeader.setQueueId(Integer.valueOf(queueId));
        RemotingCommand request = RemotingCommand.createRequestCommand((int)31, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(addr, request, 3000L);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                GetMinOffsetResponseHeader responseHeader = (GetMinOffsetResponseHeader)response.decodeCommandCustomHeader(GetMinOffsetResponseHeader.class);
                return responseHeader.getOffset();
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark());
    }

    public void lockBatchMQAsync(String addr, LockBatchRequestBody requestBody, long timeoutMillis, final LockCallback callback) throws RemotingException, InterruptedException {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)41, (CommandCustomHeader)new LockBatchMqRequestHeader());
        request.setBody(requestBody.encode());
        this.remotingClient.invokeAsync(addr, request, timeoutMillis, new InvokeCallback(){

            public void operationComplete(ResponseFuture responseFuture) {
            }

            public void operationSucceed(RemotingCommand response) {
                if (callback == null) {
                    return;
                }
                if (response.getCode() == 0) {
                    LockBatchResponseBody responseBody = (LockBatchResponseBody)LockBatchResponseBody.decode((byte[])response.getBody(), LockBatchResponseBody.class);
                    Set messageQueues = responseBody.getLockOKMQSet();
                    callback.onSuccess(messageQueues);
                } else {
                    callback.onException((Throwable)new MQBrokerException(response.getCode(), response.getRemark()));
                }
            }

            public void operationFail(Throwable throwable) {
                if (callback == null) {
                    return;
                }
                callback.onException(throwable);
            }
        });
    }

    public void unlockBatchMQAsync(String addr, UnlockBatchRequestBody requestBody, long timeoutMillis, final UnlockCallback callback) throws RemotingException, InterruptedException {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)42, (CommandCustomHeader)new UnlockBatchMqRequestHeader());
        request.setBody(requestBody.encode());
        this.remotingClient.invokeAsync(addr, request, timeoutMillis, new InvokeCallback(){

            public void operationComplete(ResponseFuture responseFuture) {
            }

            public void operationSucceed(RemotingCommand response) {
                if (callback == null) {
                    return;
                }
                if (response.getCode() == 0) {
                    callback.onSuccess();
                } else {
                    callback.onException((Throwable)new MQBrokerException(response.getCode(), response.getRemark()));
                }
            }

            public void operationFail(Throwable throwable) {
                if (callback == null) {
                    return;
                }
                callback.onException(throwable);
            }
        });
    }

    public RemotingClient getRemotingClient() {
        return this.remotingClient;
    }

    public SendResult sendMessageToSpecificBroker(String brokerAddr, String brokerName, MessageExt msg, String group, long timeoutMillis) throws RemotingException, MQBrokerException, InterruptedException {
        RemotingCommand request = BrokerOuterAPI.buildSendMessageRequest(msg, group);
        RemotingCommand response = this.remotingClient.invokeSync(brokerAddr, request, timeoutMillis);
        return this.processSendResponse(brokerName, (Message)msg, response);
    }

    public CompletableFuture<SendResult> sendMessageToSpecificBrokerAsync(String brokerAddr, final String brokerName, final MessageExt msg, String group, long timeoutMillis) {
        RemotingCommand request = BrokerOuterAPI.buildSendMessageRequest(msg, group);
        final CompletableFuture<SendResult> cf = new CompletableFuture<SendResult>();
        final String msgId = msg.getMsgId();
        try {
            this.remotingClient.invokeAsync(brokerAddr, request, timeoutMillis, new InvokeCallback(){

                public void operationComplete(ResponseFuture responseFuture) {
                }

                public void operationSucceed(RemotingCommand response) {
                    try {
                        SendResult sendResult = BrokerOuterAPI.this.processSendResponse(brokerName, (Message)msg, response);
                        cf.complete(sendResult);
                    }
                    catch (MQBrokerException | RemotingCommandException e) {
                        LOGGER.error("processSendResponse in sendMessageToSpecificBrokerAsync failed, msgId=" + msgId, e);
                        cf.completeExceptionally(e);
                    }
                }

                public void operationFail(Throwable throwable) {
                    cf.completeExceptionally(throwable);
                }
            });
        }
        catch (Throwable t) {
            LOGGER.error("invokeAsync failed in sendMessageToSpecificBrokerAsync, msgId=" + msgId, t);
            cf.completeExceptionally(t);
        }
        return cf;
    }

    private static RemotingCommand buildSendMessageRequest(MessageExt msg, String group) {
        SendMessageRequestHeaderV2 requestHeaderV2 = BrokerOuterAPI.buildSendMessageRequestHeaderV2(msg, group);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)310, (CommandCustomHeader)requestHeaderV2);
        request.setBody(msg.getBody());
        return request;
    }

    private static SendMessageRequestHeaderV2 buildSendMessageRequestHeaderV2(MessageExt msg, String group) {
        SendMessageRequestHeader requestHeader = new SendMessageRequestHeader();
        requestHeader.setProducerGroup(group);
        requestHeader.setTopic(msg.getTopic());
        requestHeader.setDefaultTopic("TBW102");
        requestHeader.setDefaultTopicQueueNums(Integer.valueOf(8));
        requestHeader.setQueueId(Integer.valueOf(msg.getQueueId()));
        requestHeader.setSysFlag(Integer.valueOf(msg.getSysFlag()));
        requestHeader.setBornTimestamp(Long.valueOf(msg.getBornTimestamp()));
        requestHeader.setFlag(Integer.valueOf(msg.getFlag()));
        requestHeader.setProperties(MessageDecoder.messageProperties2String((Map)msg.getProperties()));
        requestHeader.setReconsumeTimes(Integer.valueOf(msg.getReconsumeTimes()));
        requestHeader.setBatch(false);
        SendMessageRequestHeaderV2 requestHeaderV2 = SendMessageRequestHeaderV2.createSendMessageRequestHeaderV2((SendMessageRequestHeader)requestHeader);
        return requestHeaderV2;
    }

    private SendResult processSendResponse(String brokerName, Message msg, RemotingCommand response) throws MQBrokerException, RemotingCommandException {
        SendStatus sendStatus = null;
        switch (response.getCode()) {
            case 10: {
                sendStatus = SendStatus.FLUSH_DISK_TIMEOUT;
                break;
            }
            case 12: {
                sendStatus = SendStatus.FLUSH_SLAVE_TIMEOUT;
                break;
            }
            case 11: {
                sendStatus = SendStatus.SLAVE_NOT_AVAILABLE;
                break;
            }
            case 0: {
                sendStatus = SendStatus.SEND_OK;
                break;
            }
        }
        if (sendStatus != null) {
            SendMessageResponseHeader responseHeader = (SendMessageResponseHeader)response.decodeCommandCustomHeader(SendMessageResponseHeader.class);
            String topic = msg.getTopic();
            MessageQueue messageQueue = new MessageQueue(topic, brokerName, responseHeader.getQueueId().intValue());
            String uniqMsgId = MessageClientIDSetter.getUniqID((Message)msg);
            if (msg instanceof MessageBatch) {
                StringBuilder sb = new StringBuilder();
                for (Message message : (MessageBatch)msg) {
                    sb.append(sb.length() == 0 ? "" : ",").append(MessageClientIDSetter.getUniqID((Message)message));
                }
                uniqMsgId = sb.toString();
            }
            SendResult sendResult = new SendResult(sendStatus, uniqMsgId, responseHeader.getMsgId(), messageQueue, responseHeader.getQueueOffset().longValue());
            sendResult.setTransactionId(responseHeader.getTransactionId());
            String regionId = (String)response.getExtFields().get("MSG_REGION");
            String traceOn = (String)response.getExtFields().get("TRACE_ON");
            if (regionId == null || regionId.isEmpty()) {
                regionId = "DefaultRegion";
            }
            if (traceOn != null && traceOn.equals("false")) {
                sendResult.setTraceOn(false);
            } else {
                sendResult.setTraceOn(true);
            }
            sendResult.setRegionId(regionId);
            return sendResult;
        }
        throw new MQBrokerException(response.getCode(), response.getRemark());
    }

    public ExecutorService getBrokerOuterExecutor() {
        return this.brokerOuterExecutor;
    }

    public TopicRouteData getTopicRouteInfoFromNameServer(String topic, long timeoutMillis) throws RemotingException, MQBrokerException, InterruptedException {
        return this.getTopicRouteInfoFromNameServer(topic, timeoutMillis, true);
    }

    public TopicRouteData getTopicRouteInfoFromNameServer(String topic, long timeoutMillis, boolean allowTopicNotExist) throws MQBrokerException, InterruptedException, RemotingTimeoutException, RemotingSendRequestException, RemotingConnectException {
        GetRouteInfoRequestHeader requestHeader = new GetRouteInfoRequestHeader();
        requestHeader.setTopic(topic);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)105, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(null, request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 17: {
                if (!allowTopicNotExist) break;
                LOGGER.warn("get Topic [{}] RouteInfoFromNameServer is not exist value", (Object)topic);
                break;
            }
            case 0: {
                byte[] body = response.getBody();
                if (body == null) break;
                return (TopicRouteData)TopicRouteData.decode((byte[])body, TopicRouteData.class);
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark());
    }

    public ClusterInfo getBrokerClusterInfo() throws InterruptedException, RemotingTimeoutException, RemotingSendRequestException, RemotingConnectException, MQBrokerException {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)106, null);
        RemotingCommand response = this.remotingClient.invokeSync(null, request, 3000L);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                return (ClusterInfo)ClusterInfo.decode((byte[])response.getBody(), ClusterInfo.class);
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark());
    }

    public void forwardRequest(String brokerAddr, RemotingCommand request, long timeoutMillis, InvokeCallback invokeCallback) throws InterruptedException, RemotingSendRequestException, RemotingTimeoutException, RemotingTooMuchRequestException, RemotingConnectException {
        this.remotingClient.invokeAsync(brokerAddr, request, timeoutMillis, invokeCallback);
    }

    public void refreshMetadata() throws Exception {
        ClusterInfo brokerClusterInfo = this.getBrokerClusterInfo();
        this.clientMetadata.refreshClusterInfo(brokerClusterInfo);
    }

    public ClientMetadata getClientMetadata() {
        return this.clientMetadata;
    }

    public RpcClient getRpcClient() {
        return this.rpcClient;
    }

    public MessageRequestModeSerializeWrapper getAllMessageRequestMode(String addr) throws RemotingSendRequestException, RemotingConnectException, MQBrokerException, RemotingTimeoutException, InterruptedException {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)402, null);
        RemotingCommand response = this.remotingClient.invokeSync(addr, request, 3000L);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                return (MessageRequestModeSerializeWrapper)MessageRequestModeSerializeWrapper.decode((byte[])response.getBody(), MessageRequestModeSerializeWrapper.class);
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark(), addr);
    }

    public GetMetaDataResponseHeader getControllerMetaData(String controllerAddress) throws Exception {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)1005, null);
        RemotingCommand response = this.remotingClient.invokeSync(controllerAddress, request, 3000L);
        assert (response != null);
        if (response.getCode() == 0) {
            return (GetMetaDataResponseHeader)response.decodeCommandCustomHeader(GetMetaDataResponseHeader.class);
        }
        throw new MQBrokerException(response.getCode(), response.getRemark());
    }

    public SyncStateSet alterSyncStateSet(String controllerAddress, String brokerName, Long masterBrokerId, int masterEpoch, Set<Long> newSyncStateSet, int syncStateSetEpoch) throws Exception {
        AlterSyncStateSetRequestHeader requestHeader = new AlterSyncStateSetRequestHeader(brokerName, masterBrokerId, Integer.valueOf(masterEpoch));
        RemotingCommand request = RemotingCommand.createRequestCommand((int)1001, (CommandCustomHeader)requestHeader);
        request.setBody(new SyncStateSet(newSyncStateSet, syncStateSetEpoch).encode());
        RemotingCommand response = this.remotingClient.invokeSync(controllerAddress, request, 3000L);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                assert (response.getBody() != null);
                return (SyncStateSet)RemotingSerializable.decode((byte[])response.getBody(), SyncStateSet.class);
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark());
    }

    public Pair<ElectMasterResponseHeader, Set<Long>> brokerElect(String controllerAddress, String clusterName, String brokerName, Long brokerId) throws Exception {
        ElectMasterRequestHeader requestHeader = ElectMasterRequestHeader.ofBrokerTrigger((String)clusterName, (String)brokerName, (Long)brokerId);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)1002, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(controllerAddress, request, 3000L);
        assert (response != null);
        switch (response.getCode()) {
            case 0: 
            case 2011: {
                ElectMasterResponseHeader responseHeader = (ElectMasterResponseHeader)response.decodeCommandCustomHeader(ElectMasterResponseHeader.class);
                ElectMasterResponseBody responseBody = (ElectMasterResponseBody)RemotingSerializable.decode((byte[])response.getBody(), ElectMasterResponseBody.class);
                return new Pair((Object)responseHeader, (Object)responseBody.getSyncStateSet());
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark());
    }

    public GetNextBrokerIdResponseHeader getNextBrokerId(String clusterName, String brokerName, String controllerAddress) throws Exception {
        GetNextBrokerIdRequestHeader requestHeader = new GetNextBrokerIdRequestHeader(clusterName, brokerName);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)1012, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(controllerAddress, request, 3000L);
        assert (response != null);
        if (response.getCode() == 0) {
            return (GetNextBrokerIdResponseHeader)response.decodeCommandCustomHeader(GetNextBrokerIdResponseHeader.class);
        }
        throw new MQBrokerException(response.getCode(), response.getRemark());
    }

    public ApplyBrokerIdResponseHeader applyBrokerId(String clusterName, String brokerName, Long brokerId, String registerCheckCode, String controllerAddress) throws Exception {
        ApplyBrokerIdRequestHeader requestHeader = new ApplyBrokerIdRequestHeader(clusterName, brokerName, brokerId, registerCheckCode);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)1013, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(controllerAddress, request, 3000L);
        assert (response != null);
        if (response.getCode() == 0) {
            return (ApplyBrokerIdResponseHeader)response.decodeCommandCustomHeader(ApplyBrokerIdResponseHeader.class);
        }
        throw new MQBrokerException(response.getCode(), response.getRemark());
    }

    public Pair<RegisterBrokerToControllerResponseHeader, Set<Long>> registerBrokerToController(String clusterName, String brokerName, Long brokerId, String brokerAddress, String controllerAddress) throws Exception {
        RegisterBrokerToControllerRequestHeader requestHeader = new RegisterBrokerToControllerRequestHeader(clusterName, brokerName, brokerId, brokerAddress);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)1003, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(controllerAddress, request, 3000L);
        assert (response != null);
        if (response.getCode() == 0) {
            RegisterBrokerToControllerResponseHeader responseHeader = (RegisterBrokerToControllerResponseHeader)response.decodeCommandCustomHeader(RegisterBrokerToControllerResponseHeader.class);
            Set syncStateSet = ((SyncStateSet)RemotingSerializable.decode((byte[])response.getBody(), SyncStateSet.class)).getSyncStateSet();
            return new Pair((Object)responseHeader, (Object)syncStateSet);
        }
        throw new MQBrokerException(response.getCode(), response.getRemark());
    }

    public Pair<GetReplicaInfoResponseHeader, SyncStateSet> getReplicaInfo(String controllerAddress, String brokerName) throws Exception {
        GetReplicaInfoRequestHeader requestHeader = new GetReplicaInfoRequestHeader(brokerName);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)1004, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(controllerAddress, request, 3000L);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                GetReplicaInfoResponseHeader header = (GetReplicaInfoResponseHeader)response.decodeCommandCustomHeader(GetReplicaInfoResponseHeader.class);
                assert (response.getBody() != null);
                SyncStateSet stateSet = (SyncStateSet)RemotingSerializable.decode((byte[])response.getBody(), SyncStateSet.class);
                return new Pair((Object)header, (Object)stateSet);
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark());
    }

    public void sendHeartbeatToController(final String controllerAddress, String clusterName, String brokerAddr, String brokerName, Long brokerId, final int sendHeartBeatTimeoutMills, boolean isInBrokerContainer, int epoch, long maxOffset, long confirmOffset, long controllerHeartBeatTimeoutMills, int electionPriority) {
        if (StringUtils.isEmpty((CharSequence)controllerAddress)) {
            return;
        }
        final BrokerHeartbeatRequestHeader requestHeader = new BrokerHeartbeatRequestHeader();
        requestHeader.setClusterName(clusterName);
        requestHeader.setBrokerAddr(brokerAddr);
        requestHeader.setBrokerName(brokerName);
        requestHeader.setEpoch(Integer.valueOf(epoch));
        requestHeader.setMaxOffset(Long.valueOf(maxOffset));
        requestHeader.setConfirmOffset(Long.valueOf(confirmOffset));
        requestHeader.setHeartbeatTimeoutMills(Long.valueOf(controllerHeartBeatTimeoutMills));
        requestHeader.setElectionPriority(Integer.valueOf(electionPriority));
        requestHeader.setBrokerId(brokerId);
        this.brokerOuterExecutor.execute((Runnable)new AbstractBrokerRunnable(new BrokerIdentity(clusterName, brokerName, brokerId.longValue(), isInBrokerContainer)){

            public void run0() {
                RemotingCommand request = RemotingCommand.createRequestCommand((int)904, (CommandCustomHeader)requestHeader);
                try {
                    BrokerOuterAPI.this.remotingClient.invokeOneway(controllerAddress, request, (long)sendHeartBeatTimeoutMills);
                }
                catch (Exception e) {
                    LOGGER.error("Error happen when send heartbeat to controller {}", (Object)controllerAddress, (Object)e);
                }
            }
        });
    }

    public CompletableFuture<PullResult> pullMessageFromSpecificBrokerAsync(final String brokerName, final String brokerAddr, String consumerGroup, String topic, final int queueId, long offset, int maxNums, long timeoutMillis) throws RemotingException, InterruptedException {
        PullMessageRequestHeader requestHeader = new PullMessageRequestHeader();
        requestHeader.setConsumerGroup(consumerGroup);
        requestHeader.setTopic(topic);
        requestHeader.setQueueId(Integer.valueOf(queueId));
        requestHeader.setQueueOffset(Long.valueOf(offset));
        requestHeader.setMaxMsgNums(Integer.valueOf(maxNums));
        requestHeader.setSysFlag(Integer.valueOf(PullSysFlag.buildSysFlag((boolean)false, (boolean)false, (boolean)true, (boolean)false)));
        requestHeader.setCommitOffset(Long.valueOf(0L));
        requestHeader.setSuspendTimeoutMillis(Long.valueOf(0L));
        requestHeader.setSubscription("*");
        requestHeader.setSubVersion(Long.valueOf(System.currentTimeMillis()));
        requestHeader.setMaxMsgBytes(Integer.valueOf(Integer.MAX_VALUE));
        requestHeader.setExpressionType("TAG");
        requestHeader.setBrokerName(brokerName);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)11, (CommandCustomHeader)requestHeader);
        final CompletableFuture<PullResult> pullResultFuture = new CompletableFuture<PullResult>();
        this.remotingClient.invokeAsync(brokerAddr, request, timeoutMillis, new InvokeCallback(){

            public void operationComplete(ResponseFuture responseFuture) {
            }

            public void operationSucceed(RemotingCommand response) {
                try {
                    PullResultExt pullResultExt = BrokerOuterAPI.this.processPullResponse(response, brokerAddr);
                    BrokerOuterAPI.this.processPullResult(pullResultExt, brokerName, queueId);
                    pullResultFuture.complete(pullResultExt);
                }
                catch (Exception e) {
                    pullResultFuture.complete(new PullResult(PullStatus.NO_MATCHED_MSG, -1L, -1L, -1L, new ArrayList()));
                }
            }

            public void operationFail(Throwable throwable) {
                pullResultFuture.complete(new PullResult(PullStatus.NO_MATCHED_MSG, -1L, -1L, -1L, new ArrayList()));
            }
        });
        return pullResultFuture;
    }

    private PullResultExt processPullResponse(RemotingCommand response, String addr) throws MQBrokerException, RemotingCommandException {
        PullStatus pullStatus = PullStatus.NO_NEW_MSG;
        switch (response.getCode()) {
            case 0: {
                pullStatus = PullStatus.FOUND;
                break;
            }
            case 19: {
                pullStatus = PullStatus.NO_NEW_MSG;
                break;
            }
            case 20: {
                pullStatus = PullStatus.NO_MATCHED_MSG;
                break;
            }
            case 21: {
                pullStatus = PullStatus.OFFSET_ILLEGAL;
                break;
            }
            default: {
                throw new MQBrokerException(response.getCode(), response.getRemark(), addr);
            }
        }
        PullMessageResponseHeader responseHeader = (PullMessageResponseHeader)response.decodeCommandCustomHeader(PullMessageResponseHeader.class);
        return new PullResultExt(pullStatus, responseHeader.getNextBeginOffset().longValue(), responseHeader.getMinOffset().longValue(), responseHeader.getMaxOffset().longValue(), null, responseHeader.getSuggestWhichBrokerId().longValue(), response.getBody(), responseHeader.getOffsetDelta());
    }

    private PullResult processPullResult(PullResultExt pullResult, String brokerName, int queueId) {
        if (PullStatus.FOUND == pullResult.getPullStatus()) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(pullResult.getMessageBinary());
            List msgList = MessageDecoder.decodesBatch((ByteBuffer)byteBuffer, (boolean)true, (boolean)true, (boolean)true);
            for (MessageExt msg : msgList) {
                String traFlag = msg.getProperty("TRAN_MSG");
                if (Boolean.parseBoolean(traFlag)) {
                    msg.setTransactionId(msg.getProperty("UNIQ_KEY"));
                }
                MessageAccessor.putProperty((Message)msg, (String)"MIN_OFFSET", (String)Long.toString(pullResult.getMinOffset()));
                MessageAccessor.putProperty((Message)msg, (String)"MAX_OFFSET", (String)Long.toString(pullResult.getMaxOffset()));
                msg.setBrokerName(brokerName);
                msg.setQueueId(queueId);
                if (pullResult.getOffsetDelta() == null) continue;
                msg.setQueueOffset(pullResult.getOffsetDelta() + msg.getQueueOffset());
            }
            pullResult.setMsgFoundList(msgList);
        }
        pullResult.setMessageBinary(null);
        return pullResult;
    }
}

