/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.container;

import io.netty.channel.Channel;
import java.util.Collection;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.container.IBrokerContainer;
import org.apache.rocketmq.container.InnerBrokerController;
import org.apache.rocketmq.container.InnerSalveBrokerController;
import org.apache.rocketmq.remoting.ChannelEventListener;

public class ContainerClientHouseKeepingService
implements ChannelEventListener {
    private final IBrokerContainer brokerContainer;

    public ContainerClientHouseKeepingService(IBrokerContainer brokerContainer) {
        this.brokerContainer = brokerContainer;
    }

    public void onChannelConnect(String remoteAddr, Channel channel) {
        this.onChannelOperation(CallbackCode.CONNECT, remoteAddr, channel);
    }

    public void onChannelClose(String remoteAddr, Channel channel) {
        this.onChannelOperation(CallbackCode.CLOSE, remoteAddr, channel);
    }

    public void onChannelException(String remoteAddr, Channel channel) {
        this.onChannelOperation(CallbackCode.EXCEPTION, remoteAddr, channel);
    }

    public void onChannelIdle(String remoteAddr, Channel channel) {
        this.onChannelOperation(CallbackCode.IDLE, remoteAddr, channel);
    }

    private void onChannelOperation(CallbackCode callbackCode, String remoteAddr, Channel channel) {
        Collection<InnerBrokerController> masterBrokers = this.brokerContainer.getMasterBrokers();
        Collection<InnerSalveBrokerController> slaveBrokers = this.brokerContainer.getSlaveBrokers();
        for (BrokerController brokerController : masterBrokers) {
            this.brokerOperation(brokerController, callbackCode, remoteAddr, channel);
        }
        for (InnerSalveBrokerController innerSalveBrokerController : slaveBrokers) {
            this.brokerOperation(innerSalveBrokerController, callbackCode, remoteAddr, channel);
        }
    }

    private void brokerOperation(BrokerController brokerController, CallbackCode callbackCode, String remoteAddr, Channel channel) {
        if (callbackCode == CallbackCode.CONNECT) {
            brokerController.getBrokerStatsManager().incChannelConnectNum();
            return;
        }
        boolean removed = brokerController.getProducerManager().doChannelCloseEvent(remoteAddr, channel);
        if (removed &= brokerController.getConsumerManager().doChannelCloseEvent(remoteAddr, channel)) {
            switch (callbackCode) {
                case CLOSE: {
                    brokerController.getBrokerStatsManager().incChannelCloseNum();
                    break;
                }
                case EXCEPTION: {
                    brokerController.getBrokerStatsManager().incChannelExceptionNum();
                    break;
                }
                case IDLE: {
                    brokerController.getBrokerStatsManager().incChannelIdleNum();
                    break;
                }
            }
        }
    }

    public static enum CallbackCode {
        CONNECT,
        CLOSE,
        EXCEPTION,
        IDLE;

    }
}

