/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.ha;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import org.apache.rocketmq.common.ServiceThread;
import org.apache.rocketmq.common.utils.NetworkUtil;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.netty.NettySystemConfig;
import org.apache.rocketmq.store.SelectMappedBufferResult;
import org.apache.rocketmq.store.ha.DefaultHAService;
import org.apache.rocketmq.store.ha.FlowMonitor;
import org.apache.rocketmq.store.ha.HAConnection;
import org.apache.rocketmq.store.ha.HAConnectionState;

public class DefaultHAConnection
implements HAConnection {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqStore");
    private final DefaultHAService haService;
    private final SocketChannel socketChannel;
    private final String clientAddress;
    private WriteSocketService writeSocketService;
    private ReadSocketService readSocketService;
    private volatile HAConnectionState currentState = HAConnectionState.TRANSFER;
    private volatile long slaveRequestOffset = -1L;
    private volatile long slaveAckOffset = -1L;
    private FlowMonitor flowMonitor;

    public DefaultHAConnection(DefaultHAService haService, SocketChannel socketChannel) throws IOException {
        this.haService = haService;
        this.socketChannel = socketChannel;
        this.clientAddress = this.socketChannel.socket().getRemoteSocketAddress().toString();
        this.socketChannel.configureBlocking(false);
        this.socketChannel.socket().setSoLinger(false, -1);
        this.socketChannel.socket().setTcpNoDelay(true);
        if (NettySystemConfig.socketSndbufSize > 0) {
            this.socketChannel.socket().setReceiveBufferSize(NettySystemConfig.socketSndbufSize);
        }
        if (NettySystemConfig.socketRcvbufSize > 0) {
            this.socketChannel.socket().setSendBufferSize(NettySystemConfig.socketRcvbufSize);
        }
        this.writeSocketService = new WriteSocketService(this.socketChannel);
        this.readSocketService = new ReadSocketService(this.socketChannel);
        this.haService.getConnectionCount().incrementAndGet();
        this.flowMonitor = new FlowMonitor(haService.getDefaultMessageStore().getMessageStoreConfig());
    }

    @Override
    public void start() {
        this.changeCurrentState(HAConnectionState.TRANSFER);
        this.flowMonitor.start();
        this.readSocketService.start();
        this.writeSocketService.start();
    }

    @Override
    public void shutdown() {
        this.changeCurrentState(HAConnectionState.SHUTDOWN);
        this.writeSocketService.shutdown(true);
        this.readSocketService.shutdown(true);
        this.flowMonitor.shutdown(true);
        this.close();
    }

    @Override
    public void close() {
        if (this.socketChannel != null) {
            try {
                this.socketChannel.close();
            }
            catch (IOException e) {
                log.error("", (Throwable)e);
            }
        }
    }

    @Override
    public SocketChannel getSocketChannel() {
        return this.socketChannel;
    }

    public void changeCurrentState(HAConnectionState currentState) {
        log.info("change state to {}", (Object)currentState);
        this.currentState = currentState;
    }

    @Override
    public HAConnectionState getCurrentState() {
        return this.currentState;
    }

    @Override
    public String getClientAddress() {
        return this.clientAddress;
    }

    @Override
    public long getSlaveAckOffset() {
        return this.slaveAckOffset;
    }

    @Override
    public long getTransferredByteInSecond() {
        return this.flowMonitor.getTransferredByteInSecond();
    }

    @Override
    public long getTransferFromWhere() {
        return this.writeSocketService.getNextTransferFromWhere();
    }

    class WriteSocketService
    extends ServiceThread {
        private final Selector selector;
        private final SocketChannel socketChannel;
        private final int headerSize = 12;
        private final ByteBuffer byteBufferHeader = ByteBuffer.allocate(12);
        private long nextTransferFromWhere = -1L;
        private SelectMappedBufferResult selectMappedBufferResult;
        private boolean lastWriteOver = true;
        private long lastPrintTimestamp = System.currentTimeMillis();
        private long lastWriteTimestamp = System.currentTimeMillis();

        public WriteSocketService(SocketChannel socketChannel) throws IOException {
            this.selector = NetworkUtil.openSelector();
            this.socketChannel = socketChannel;
            this.socketChannel.register(this.selector, 4);
            this.setDaemon(true);
        }

        public void run() {
            log.info(this.getServiceName() + " service started");
            while (!this.isStopped()) {
                try {
                    SelectMappedBufferResult selectResult;
                    this.selector.select(1000L);
                    if (-1L == DefaultHAConnection.this.slaveRequestOffset) {
                        Thread.sleep(10L);
                        continue;
                    }
                    if (-1L == this.nextTransferFromWhere) {
                        if (0L == DefaultHAConnection.this.slaveRequestOffset) {
                            long masterOffset = DefaultHAConnection.this.haService.getDefaultMessageStore().getCommitLog().getMaxOffset();
                            if ((masterOffset -= masterOffset % (long)DefaultHAConnection.this.haService.getDefaultMessageStore().getMessageStoreConfig().getMappedFileSizeCommitLog()) < 0L) {
                                masterOffset = 0L;
                            }
                            this.nextTransferFromWhere = masterOffset;
                        } else {
                            this.nextTransferFromWhere = DefaultHAConnection.this.slaveRequestOffset;
                        }
                        log.info("master transfer data from " + this.nextTransferFromWhere + " to slave[" + DefaultHAConnection.this.clientAddress + "], and slave request " + DefaultHAConnection.this.slaveRequestOffset);
                    }
                    if (this.lastWriteOver) {
                        long interval = DefaultHAConnection.this.haService.getDefaultMessageStore().getSystemClock().now() - this.lastWriteTimestamp;
                        if (interval > (long)DefaultHAConnection.this.haService.getDefaultMessageStore().getMessageStoreConfig().getHaSendHeartbeatInterval()) {
                            this.byteBufferHeader.position(0);
                            this.byteBufferHeader.limit(12);
                            this.byteBufferHeader.putLong(this.nextTransferFromWhere);
                            this.byteBufferHeader.putInt(0);
                            this.byteBufferHeader.flip();
                            this.lastWriteOver = this.transferData();
                            if (!this.lastWriteOver) {
                                continue;
                            }
                        }
                    } else {
                        this.lastWriteOver = this.transferData();
                        if (!this.lastWriteOver) continue;
                    }
                    if ((selectResult = DefaultHAConnection.this.haService.getDefaultMessageStore().getCommitLogData(this.nextTransferFromWhere)) != null) {
                        int canTransferMaxBytes;
                        int size = selectResult.getSize();
                        if (size > DefaultHAConnection.this.haService.getDefaultMessageStore().getMessageStoreConfig().getHaTransferBatchSize()) {
                            size = DefaultHAConnection.this.haService.getDefaultMessageStore().getMessageStoreConfig().getHaTransferBatchSize();
                        }
                        if (size > (canTransferMaxBytes = DefaultHAConnection.this.flowMonitor.canTransferMaxByteNum())) {
                            if (System.currentTimeMillis() - this.lastPrintTimestamp > 1000L) {
                                log.warn("Trigger HA flow control, max transfer speed {}KB/s, current speed: {}KB/s", (Object)String.format("%.2f", (double)DefaultHAConnection.this.flowMonitor.maxTransferByteInSecond() / 1024.0), (Object)String.format("%.2f", (double)DefaultHAConnection.this.flowMonitor.getTransferredByteInSecond() / 1024.0));
                                this.lastPrintTimestamp = System.currentTimeMillis();
                            }
                            size = canTransferMaxBytes;
                        }
                        long thisOffset = this.nextTransferFromWhere;
                        this.nextTransferFromWhere += (long)size;
                        selectResult.getByteBuffer().limit(size);
                        this.selectMappedBufferResult = selectResult;
                        this.byteBufferHeader.position(0);
                        this.byteBufferHeader.limit(12);
                        this.byteBufferHeader.putLong(thisOffset);
                        this.byteBufferHeader.putInt(size);
                        this.byteBufferHeader.flip();
                        this.lastWriteOver = this.transferData();
                        continue;
                    }
                    DefaultHAConnection.this.haService.getWaitNotifyObject().allWaitForRunning(100L);
                }
                catch (Exception e) {
                    log.error(this.getServiceName() + " service has exception.", (Throwable)e);
                    break;
                }
            }
            DefaultHAConnection.this.haService.getWaitNotifyObject().removeFromWaitingThreadTable();
            if (this.selectMappedBufferResult != null) {
                this.selectMappedBufferResult.release();
            }
            DefaultHAConnection.this.changeCurrentState(HAConnectionState.SHUTDOWN);
            this.makeStop();
            DefaultHAConnection.this.readSocketService.makeStop();
            DefaultHAConnection.this.haService.removeConnection(DefaultHAConnection.this);
            SelectionKey sk = this.socketChannel.keyFor(this.selector);
            if (sk != null) {
                sk.cancel();
            }
            try {
                this.selector.close();
                this.socketChannel.close();
            }
            catch (IOException e) {
                log.error("", (Throwable)e);
            }
            log.info(this.getServiceName() + " service end");
        }

        private boolean transferData() throws Exception {
            boolean result;
            int writeSize;
            int writeSizeZeroTimes = 0;
            while (this.byteBufferHeader.hasRemaining()) {
                writeSize = this.socketChannel.write(this.byteBufferHeader);
                if (writeSize > 0) {
                    DefaultHAConnection.this.flowMonitor.addByteCountTransferred(writeSize);
                    writeSizeZeroTimes = 0;
                    this.lastWriteTimestamp = DefaultHAConnection.this.haService.getDefaultMessageStore().getSystemClock().now();
                    continue;
                }
                if (writeSize == 0) {
                    if (++writeSizeZeroTimes < 3) continue;
                    break;
                }
                throw new Exception("ha master write header error < 0");
            }
            if (null == this.selectMappedBufferResult) {
                return !this.byteBufferHeader.hasRemaining();
            }
            writeSizeZeroTimes = 0;
            if (!this.byteBufferHeader.hasRemaining()) {
                while (this.selectMappedBufferResult.getByteBuffer().hasRemaining()) {
                    writeSize = this.socketChannel.write(this.selectMappedBufferResult.getByteBuffer());
                    if (writeSize > 0) {
                        writeSizeZeroTimes = 0;
                        this.lastWriteTimestamp = DefaultHAConnection.this.haService.getDefaultMessageStore().getSystemClock().now();
                        continue;
                    }
                    if (writeSize == 0) {
                        if (++writeSizeZeroTimes < 3) continue;
                        break;
                    }
                    throw new Exception("ha master write body error < 0");
                }
            }
            boolean bl = result = !this.byteBufferHeader.hasRemaining() && !this.selectMappedBufferResult.getByteBuffer().hasRemaining();
            if (!this.selectMappedBufferResult.getByteBuffer().hasRemaining()) {
                this.selectMappedBufferResult.release();
                this.selectMappedBufferResult = null;
            }
            return result;
        }

        public String getServiceName() {
            if (DefaultHAConnection.this.haService.getDefaultMessageStore().getBrokerConfig().isInBrokerContainer()) {
                return DefaultHAConnection.this.haService.getDefaultMessageStore().getBrokerIdentity().getIdentifier() + WriteSocketService.class.getSimpleName();
            }
            return WriteSocketService.class.getSimpleName();
        }

        public void shutdown() {
            super.shutdown();
        }

        public long getNextTransferFromWhere() {
            return this.nextTransferFromWhere;
        }
    }

    class ReadSocketService
    extends ServiceThread {
        private static final int READ_MAX_BUFFER_SIZE = 0x100000;
        private final Selector selector;
        private final SocketChannel socketChannel;
        private final ByteBuffer byteBufferRead = ByteBuffer.allocate(0x100000);
        private int processPosition = 0;
        private volatile long lastReadTimestamp = System.currentTimeMillis();

        public ReadSocketService(SocketChannel socketChannel) throws IOException {
            this.selector = NetworkUtil.openSelector();
            this.socketChannel = socketChannel;
            this.socketChannel.register(this.selector, 1);
            this.setDaemon(true);
        }

        public void run() {
            log.info(this.getServiceName() + " service started");
            while (!this.isStopped()) {
                try {
                    this.selector.select(1000L);
                    boolean ok = this.processReadEvent();
                    if (!ok) {
                        log.error("processReadEvent error");
                        break;
                    }
                    long interval = DefaultHAConnection.this.haService.getDefaultMessageStore().getSystemClock().now() - this.lastReadTimestamp;
                    if (interval <= (long)DefaultHAConnection.this.haService.getDefaultMessageStore().getMessageStoreConfig().getHaHousekeepingInterval()) continue;
                    log.warn("ha housekeeping, found this connection[" + DefaultHAConnection.this.clientAddress + "] expired, " + interval);
                    break;
                }
                catch (Exception e) {
                    log.error(this.getServiceName() + " service has exception.", (Throwable)e);
                    break;
                }
            }
            DefaultHAConnection.this.changeCurrentState(HAConnectionState.SHUTDOWN);
            this.makeStop();
            DefaultHAConnection.this.writeSocketService.makeStop();
            DefaultHAConnection.this.haService.removeConnection(DefaultHAConnection.this);
            DefaultHAConnection.this.haService.getConnectionCount().decrementAndGet();
            SelectionKey sk = this.socketChannel.keyFor(this.selector);
            if (sk != null) {
                sk.cancel();
            }
            try {
                this.selector.close();
                this.socketChannel.close();
            }
            catch (IOException e) {
                log.error("", (Throwable)e);
            }
            log.info(this.getServiceName() + " service end");
        }

        public String getServiceName() {
            if (DefaultHAConnection.this.haService.getDefaultMessageStore().getBrokerConfig().isInBrokerContainer()) {
                return DefaultHAConnection.this.haService.getDefaultMessageStore().getBrokerIdentity().getIdentifier() + ReadSocketService.class.getSimpleName();
            }
            return ReadSocketService.class.getSimpleName();
        }

        private boolean processReadEvent() {
            int readSizeZeroTimes = 0;
            if (!this.byteBufferRead.hasRemaining()) {
                this.byteBufferRead.flip();
                this.processPosition = 0;
            }
            while (this.byteBufferRead.hasRemaining()) {
                try {
                    int readSize = this.socketChannel.read(this.byteBufferRead);
                    if (readSize > 0) {
                        readSizeZeroTimes = 0;
                        this.lastReadTimestamp = DefaultHAConnection.this.haService.getDefaultMessageStore().getSystemClock().now();
                        if (this.byteBufferRead.position() - this.processPosition < 8) continue;
                        int pos = this.byteBufferRead.position() - this.byteBufferRead.position() % 8;
                        long readOffset = this.byteBufferRead.getLong(pos - 8);
                        this.processPosition = pos;
                        DefaultHAConnection.this.slaveAckOffset = readOffset;
                        if (DefaultHAConnection.this.slaveRequestOffset < 0L) {
                            DefaultHAConnection.this.slaveRequestOffset = readOffset;
                            log.info("slave[" + DefaultHAConnection.this.clientAddress + "] request offset " + readOffset);
                        }
                        DefaultHAConnection.this.haService.notifyTransferSome(DefaultHAConnection.this.slaveAckOffset);
                        continue;
                    }
                    if (readSize == 0) {
                        if (++readSizeZeroTimes < 3) continue;
                        break;
                    }
                    log.error("read socket[" + DefaultHAConnection.this.clientAddress + "] < 0");
                    return false;
                }
                catch (IOException e) {
                    log.error("processReadEvent exception", (Throwable)e);
                    return false;
                }
            }
            return true;
        }
    }
}

