/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.netty.client;

import java.io.IOException;
import org.apache.ratis.client.impl.ClientProtoUtils;
import org.apache.ratis.client.impl.RaftClientRpcWithProxy;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.netty.NettyRpcProxy;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.proto.netty.NettyProtos;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.GroupInfoRequest;
import org.apache.ratis.protocol.GroupListRequest;
import org.apache.ratis.protocol.GroupManagementRequest;
import org.apache.ratis.protocol.LeaderElectionManagementRequest;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.SetConfigurationRequest;
import org.apache.ratis.protocol.SnapshotManagementRequest;
import org.apache.ratis.protocol.TransferLeadershipRequest;

public class NettyClientRpc
extends RaftClientRpcWithProxy<NettyRpcProxy> {
    public NettyClientRpc(ClientId clientId, RaftProperties properties) {
        super(new NettyRpcProxy.PeerMap(clientId.toString(), properties));
    }

    @Override
    public RaftClientReply sendRequest(RaftClientRequest request) throws IOException {
        RaftProtos.RaftRpcRequestProto rpcRequest;
        RaftPeerId serverId = request.getServerId();
        NettyRpcProxy proxy = (NettyRpcProxy)this.getProxies().getProxy(serverId);
        NettyProtos.RaftNettyServerRequestProto.Builder b = NettyProtos.RaftNettyServerRequestProto.newBuilder();
        if (request instanceof GroupManagementRequest) {
            RaftProtos.GroupManagementRequestProto proto = ClientProtoUtils.toGroupManagementRequestProto((GroupManagementRequest)request);
            b.setGroupManagementRequest(proto);
            rpcRequest = proto.getRpcRequest();
        } else if (request instanceof SetConfigurationRequest) {
            RaftProtos.SetConfigurationRequestProto proto = ClientProtoUtils.toSetConfigurationRequestProto((SetConfigurationRequest)request);
            b.setSetConfigurationRequest(proto);
            rpcRequest = proto.getRpcRequest();
        } else if (request instanceof GroupListRequest) {
            RaftProtos.GroupListRequestProto proto = ClientProtoUtils.toGroupListRequestProto((GroupListRequest)request);
            b.setGroupListRequest(proto);
            rpcRequest = proto.getRpcRequest();
        } else if (request instanceof GroupInfoRequest) {
            RaftProtos.GroupInfoRequestProto proto = ClientProtoUtils.toGroupInfoRequestProto((GroupInfoRequest)request);
            b.setGroupInfoRequest(proto);
            rpcRequest = proto.getRpcRequest();
        } else if (request instanceof TransferLeadershipRequest) {
            RaftProtos.TransferLeadershipRequestProto proto = ClientProtoUtils.toTransferLeadershipRequestProto((TransferLeadershipRequest)request);
            b.setTransferLeadershipRequest(proto);
            rpcRequest = proto.getRpcRequest();
        } else if (request instanceof SnapshotManagementRequest) {
            RaftProtos.SnapshotManagementRequestProto proto = ClientProtoUtils.toSnapshotManagementRequestProto((SnapshotManagementRequest)request);
            b.setSnapshotManagementRequest(proto);
            rpcRequest = proto.getRpcRequest();
        } else if (request instanceof LeaderElectionManagementRequest) {
            RaftProtos.LeaderElectionManagementRequestProto proto = ClientProtoUtils.toLeaderElectionManagementRequestProto((LeaderElectionManagementRequest)request);
            b.setLeaderElectionManagementRequest(proto);
            rpcRequest = proto.getRpcRequest();
        } else {
            RaftProtos.RaftClientRequestProto proto = ClientProtoUtils.toRaftClientRequestProto(request);
            b.setRaftClientRequest(proto);
            rpcRequest = proto.getRpcRequest();
        }
        if (request instanceof GroupListRequest) {
            return ClientProtoUtils.toGroupListReply(proxy.send(rpcRequest, b.build()).getGroupListReply());
        }
        if (request instanceof GroupInfoRequest) {
            return ClientProtoUtils.toGroupInfoReply(proxy.send(rpcRequest, b.build()).getGroupInfoReply());
        }
        return ClientProtoUtils.toRaftClientReply(proxy.send(rpcRequest, b.build()).getRaftClientReply());
    }
}

