/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.encoders.primitives;

import java.util.Map;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.EncodeException;
import org.apache.qpid.protonj2.codec.EncoderState;
import org.apache.qpid.protonj2.codec.TypeEncoder;
import org.apache.qpid.protonj2.codec.encoders.AbstractPrimitiveTypeEncoder;

public final class MapTypeEncoder
extends AbstractPrimitiveTypeEncoder<Map> {
    @Override
    public Class<Map> getTypeClass() {
        return Map.class;
    }

    @Override
    public void writeType(ProtonBuffer buffer, EncoderState state, Map value) {
        buffer.writeByte((byte)-47);
        this.writeValue(buffer, state, value);
    }

    @Override
    public void writeRawArray(ProtonBuffer buffer, EncoderState state, Object[] values) {
        buffer.writeByte((byte)-47);
        for (Object value : values) {
            this.writeValue(buffer, state, (Map)value);
        }
    }

    private void writeValue(ProtonBuffer buffer, EncoderState state, Map value) {
        int startIndex = buffer.getWriteOffset();
        buffer.writeInt(0);
        buffer.writeInt(value.size() * 2);
        value.forEach((key, entry) -> {
            TypeEncoder<?> keyEncoder = state.getEncoder().getTypeEncoder(key);
            if (keyEncoder == null) {
                throw new EncodeException("Cannot find encoder for type " + key);
            }
            keyEncoder.writeType(buffer, state, key);
            TypeEncoder<?> valueEncoder = state.getEncoder().getTypeEncoder(entry);
            if (valueEncoder == null) {
                throw new EncodeException("Cannot find encoder for type " + entry);
            }
            valueEncoder.writeType(buffer, state, entry);
        });
        buffer.setInt(startIndex, buffer.getWriteOffset() - startIndex - 4);
    }
}

