/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.engine.impl.ssl;

import javax.net.ssl.SSLContext;
import org.apache.qpid.proton.engine.ProtonJSslDomain;
import org.apache.qpid.proton.engine.SslDomain;
import org.apache.qpid.proton.engine.SslPeerDetails;
import org.apache.qpid.proton.engine.impl.ssl.ProtonSslEngine;
import org.apache.qpid.proton.engine.impl.ssl.ProtonSslEngineProvider;
import org.apache.qpid.proton.engine.impl.ssl.SslEngineFacadeFactory;

public class SslDomainImpl
implements SslDomain,
ProtonSslEngineProvider,
ProtonJSslDomain {
    private SslDomain.Mode _mode;
    private SslDomain.VerifyMode _verifyMode;
    private String _certificateFile;
    private String _privateKeyFile;
    private String _privateKeyPassword;
    private String _trustedCaDb;
    private boolean _allowUnsecuredClient;
    private SSLContext _sslContext;
    private final SslEngineFacadeFactory _sslEngineFacadeFactory = new SslEngineFacadeFactory();

    @Override
    public void init(SslDomain.Mode mode) {
        this._sslEngineFacadeFactory.resetCache();
        this._mode = mode;
    }

    @Override
    public SslDomain.Mode getMode() {
        return this._mode;
    }

    @Override
    public void setCredentials(String certificateFile, String privateKeyFile, String privateKeyPassword) {
        this._certificateFile = certificateFile;
        this._privateKeyFile = privateKeyFile;
        this._privateKeyPassword = privateKeyPassword;
        this._sslEngineFacadeFactory.resetCache();
    }

    @Override
    public void setTrustedCaDb(String certificateDb) {
        this._trustedCaDb = certificateDb;
        this._sslEngineFacadeFactory.resetCache();
    }

    @Override
    public String getTrustedCaDb() {
        return this._trustedCaDb;
    }

    @Override
    public void setSslContext(SSLContext sslContext) {
        this._sslContext = sslContext;
    }

    @Override
    public SSLContext getSslContext() {
        return this._sslContext;
    }

    @Override
    public void setPeerAuthentication(SslDomain.VerifyMode verifyMode) {
        this._verifyMode = verifyMode;
        this._sslEngineFacadeFactory.resetCache();
    }

    @Override
    public SslDomain.VerifyMode getPeerAuthentication() {
        if (this._verifyMode == null) {
            return this._mode == SslDomain.Mode.SERVER ? SslDomain.VerifyMode.ANONYMOUS_PEER : SslDomain.VerifyMode.VERIFY_PEER_NAME;
        }
        return this._verifyMode;
    }

    @Override
    public String getPrivateKeyFile() {
        return this._privateKeyFile;
    }

    @Override
    public String getPrivateKeyPassword() {
        return this._privateKeyPassword;
    }

    @Override
    public String getCertificateFile() {
        return this._certificateFile;
    }

    @Override
    public void allowUnsecuredClient(boolean allowUnsecured) {
        this._allowUnsecuredClient = allowUnsecured;
        this._sslEngineFacadeFactory.resetCache();
    }

    @Override
    public boolean allowUnsecuredClient() {
        return this._allowUnsecuredClient;
    }

    @Override
    public ProtonSslEngine createSslEngine(SslPeerDetails peerDetails) {
        return this._sslEngineFacadeFactory.createProtonSslEngine(this, peerDetails);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SslDomainImpl [_mode=").append((Object)this._mode).append(", _verifyMode=").append((Object)this._verifyMode).append(", _certificateFile=").append(this._certificateFile).append(", _privateKeyFile=").append(this._privateKeyFile).append(", _trustedCaDb=").append(this._trustedCaDb).append(", _allowUnsecuredClient=").append(this._allowUnsecuredClient).append("]");
        return builder.toString();
    }
}

