/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.instrumentation.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.qpid.server.instrumentation.metadata.MemberDescription;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class MethodDescription
implements MemberDescription {
    private final String _declaringClass;
    private final String _name;
    private final String _returnType;
    private final List<String> _parameters;
    private static final Map<String, Supplier<String>> TYPES = Map.of("Z", () -> "boolean", "B", () -> "byte", "C", () -> "char", "D", () -> "double", "F", () -> "float", "I", () -> "int", "J", () -> "long", "S", () -> "short");
    private static final List<String> PRIMITIVES = List.of("B", "Z", "C", "D", "F", "I", "J", "S", "V");

    public MethodDescription(String declaringClass, String name, String returnType, List<String> parameters) {
        this._declaringClass = declaringClass;
        this._name = name;
        this._returnType = returnType;
        this._parameters = new ArrayList<String>(parameters);
    }

    public static MethodDescription of(ClassNode classNode, MethodNode methodNode) {
        String declaringClass = classNode.name;
        String methodName = methodNode.name;
        String returnType = Type.getReturnType((String)methodNode.desc).getInternalName();
        List<String> parameters = Arrays.stream(Type.getArgumentTypes((String)methodNode.desc)).map(Type::getInternalName).collect(Collectors.toList());
        return new MethodDescription(declaringClass, methodName, returnType, parameters);
    }

    @Override
    public String getDeclaringClass() {
        return this._declaringClass;
    }

    @Override
    public String getName() {
        return this._name;
    }

    public String getReturnType() {
        return this._returnType;
    }

    public List<String> getParameters() {
        return new ArrayList<String>(this._parameters);
    }

    public String getParameter(int i) {
        return this._parameters.get(i);
    }

    public int getParameterCount() {
        return this._parameters.size();
    }

    public boolean returnsVoid() {
        return "V".equalsIgnoreCase(this._returnType);
    }

    public boolean returnsPrimitive() {
        return PRIMITIVES.contains(this._returnType);
    }

    @Override
    public String getSignature() {
        return this._declaringClass.replace('/', '.') + "#" + this._name + (this._parameters.isEmpty() ? "" : this._parameters.stream().map(param -> param.lastIndexOf(47) == -1 ? param : param.substring(param.lastIndexOf(47) + 1)).map(param -> TYPES.getOrDefault(param, () -> param).get()).collect(Collectors.joining()));
    }

    public String toString() {
        return "MethodDescription{declaringClass='" + this._declaringClass + "', name='" + this._name + "', returnType='" + this._returnType + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodDescription that = (MethodDescription)o;
        return Objects.equals(this._declaringClass, that._declaringClass) && Objects.equals(this._name, that._name) && Objects.equals(this._parameters, that._parameters);
    }

    public int hashCode() {
        return Objects.hash(this._declaringClass, this._name, this._parameters);
    }
}

