/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.type.messaging.codec;

import java.util.Map;
import org.apache.qpid.server.protocol.v1_0.DeserializationFactories;
import org.apache.qpid.server.protocol.v1_0.codec.AbstractCompositeTypeConstructor;
import org.apache.qpid.server.protocol.v1_0.codec.DescribedTypeConstructorRegistry;
import org.apache.qpid.server.protocol.v1_0.type.AmqpErrorException;
import org.apache.qpid.server.protocol.v1_0.type.Outcome;
import org.apache.qpid.server.protocol.v1_0.type.Symbol;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedInteger;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedLong;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Filter;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Source;
import org.apache.qpid.server.protocol.v1_0.type.messaging.TerminusDurability;
import org.apache.qpid.server.protocol.v1_0.type.messaging.TerminusExpiryPolicy;
import org.apache.qpid.server.protocol.v1_0.type.transport.AmqpError;
import org.apache.qpid.server.protocol.v1_0.type.transport.Error;

public final class SourceConstructor
extends AbstractCompositeTypeConstructor<Source> {
    private static final SourceConstructor INSTANCE = new SourceConstructor();

    public static void register(DescribedTypeConstructorRegistry registry) {
        registry.register(Symbol.valueOf("amqp:source:list"), INSTANCE);
        registry.register(UnsignedLong.valueOf(40L), INSTANCE);
    }

    @Override
    protected String getTypeName() {
        return Source.class.getSimpleName();
    }

    @Override
    protected Source construct(AbstractCompositeTypeConstructor.FieldValueReader fieldValueReader) throws AmqpErrorException {
        Symbol[] capabilities;
        Symbol[] outcomes;
        Outcome defaultOutcome;
        Map<Symbol, Filter> filter;
        Object distributionMode;
        Object dynamicNodeProperties;
        Boolean dynamic;
        UnsignedInteger timeout;
        Object expiryPolicy;
        Object durable;
        Source obj = new Source();
        String address = fieldValueReader.readValue(0, "address", false, String.class);
        if (address != null) {
            obj.setAddress(address);
        }
        if ((durable = fieldValueReader.readValue(1, "durable", false, Object.class)) != null) {
            try {
                obj.setDurable(TerminusDurability.valueOf(durable));
            }
            catch (RuntimeException e) {
                Error error = new Error(AmqpError.DECODE_ERROR, "Could not decode value field 'durable' of 'Source'");
                throw new AmqpErrorException(error, (Throwable)e);
            }
        }
        if ((expiryPolicy = fieldValueReader.readValue(2, "expiryPolicy", false, Object.class)) != null) {
            try {
                obj.setExpiryPolicy(TerminusExpiryPolicy.valueOf(expiryPolicy));
            }
            catch (RuntimeException e) {
                Error error = new Error(AmqpError.DECODE_ERROR, "Could not decode value field 'expiryPolicy' of 'Source'");
                throw new AmqpErrorException(error, (Throwable)e);
            }
        }
        if ((timeout = fieldValueReader.readValue(3, "timeout", false, UnsignedInteger.class)) != null) {
            obj.setTimeout(timeout);
        }
        if ((dynamic = fieldValueReader.readValue(4, "dynamic", false, Boolean.class)) != null) {
            obj.setDynamic(dynamic);
        }
        if ((dynamicNodeProperties = fieldValueReader.readValue(5, "dynamicNodeProperties", false, Object.class)) != null) {
            try {
                obj.setDynamicNodeProperties(DeserializationFactories.convertToNodeProperties(dynamicNodeProperties));
            }
            catch (RuntimeException e) {
                Error error = new Error(AmqpError.DECODE_ERROR, "Could not decode value field 'dynamicNodeProperties' of 'Source'");
                throw new AmqpErrorException(error, (Throwable)e);
            }
        }
        if ((distributionMode = fieldValueReader.readValue(6, "distributionMode", false, Object.class)) != null) {
            try {
                obj.setDistributionMode(DeserializationFactories.convertToDistributionMode(distributionMode));
            }
            catch (RuntimeException e) {
                Error error = new Error(AmqpError.DECODE_ERROR, "Could not decode value field 'distributionMode' of 'Source'");
                throw new AmqpErrorException(error, (Throwable)e);
            }
        }
        if ((filter = fieldValueReader.readMapValue(7, "filter", false, Symbol.class, Filter.class)) != null) {
            obj.setFilter(filter);
        }
        if ((defaultOutcome = fieldValueReader.readValue(8, "defaultOutcome", false, Outcome.class)) != null) {
            obj.setDefaultOutcome(defaultOutcome);
        }
        if ((outcomes = fieldValueReader.readArrayValue(9, "outcomes", false, Symbol.class, x -> (Symbol)x)) != null) {
            obj.setOutcomes(outcomes);
        }
        if ((capabilities = fieldValueReader.readArrayValue(10, "capabilities", false, Symbol.class, x -> (Symbol)x)) != null) {
            obj.setCapabilities(capabilities);
        }
        return obj;
    }
}

