/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl.cache;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.function.Consumer;
import org.apache.bookkeeper.mledger.impl.cache.RangeCacheEntryWrapper;
import org.apache.bookkeeper.mledger.impl.cache.RangeCacheRemovalCounters;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableLong;
import org.apache.commons.lang3.tuple.Pair;
import org.jctools.queues.MpscUnboundedArrayQueue;

class RangeCacheRemovalQueue {
    private static final int REMOVAL_QUEUE_CHUNK_SIZE = 131072;
    private final MpscUnboundedArrayQueue<RangeCacheEntryWrapper> removalQueue = new MpscUnboundedArrayQueue(131072);
    private int maxRequeueCountWhenHasExpectedReads;
    private boolean extendTTLOfRecentlyAccessed;

    RangeCacheRemovalQueue(int maxRequeueCountWhenHasExpectedReads, boolean extendTTLOfRecentlyAccessed) {
        this.maxRequeueCountWhenHasExpectedReads = maxRequeueCountWhenHasExpectedReads;
        this.extendTTLOfRecentlyAccessed = extendTTLOfRecentlyAccessed;
    }

    public synchronized Pair<Integer, Long> evictLEntriesBeforeTimestamp(long timestampNanos) {
        return this.evictEntries((e, c) -> {
            boolean expired;
            boolean bl = expired = e.timestampNanos < timestampNanos;
            if (expired) {
                if (this.shouldRequeue(e)) {
                    return EvictionResult.REQUEUE;
                }
                return EvictionResult.REMOVE;
            }
            return EvictionResult.STOP;
        });
    }

    public synchronized Pair<Integer, Long> evictLeastAccessedEntries(long sizeToFree) {
        Preconditions.checkArgument((sizeToFree > 0L ? 1 : 0) != 0);
        return this.evictEntries((e, c) -> {
            if (c.removedSize >= sizeToFree) {
                return EvictionResult.STOP;
            }
            if (this.shouldRequeue(e)) {
                return EvictionResult.REQUEUE;
            }
            return EvictionResult.REMOVE;
        });
    }

    private boolean shouldRequeue(RangeCacheEntryWrapper e) {
        return this.extendTTLOfRecentlyAccessed && e.accessed || e.value.hasExpectedReads() && e.requeueCount < this.maxRequeueCountWhenHasExpectedReads;
    }

    public boolean addEntry(RangeCacheEntryWrapper newWrapper) {
        return this.removalQueue.offer((Object)newWrapper);
    }

    private synchronized Pair<Integer, Long> evictEntries(EvictionPredicate evictionPredicate) {
        RangeCacheRemovalCounters counters = RangeCacheRemovalCounters.create();
        this.handleQueue(evictionPredicate, counters);
        return this.handleRemovalResult(counters);
    }

    private void handleQueue(EvictionPredicate evictionPredicate, RangeCacheRemovalCounters counters) {
        RangeCacheEntryWrapper entry;
        while (!Thread.currentThread().isInterrupted() && (entry = (RangeCacheEntryWrapper)this.removalQueue.peek()) != null) {
            EvictionResult evictionResult = this.handleEviction(evictionPredicate, entry, counters);
            if (evictionResult.shouldRemovePeekedEntry()) {
                this.removalQueue.poll();
            }
            if (evictionResult.shouldRequeue()) {
                this.removalQueue.add((Object)entry);
            } else if (evictionResult.shouldDrop()) {
                entry.recycle();
            }
            if (!evictionResult.shouldStop()) continue;
            break;
        }
    }

    private EvictionResult handleEviction(EvictionPredicate evictionPredicate, RangeCacheEntryWrapper entry, RangeCacheRemovalCounters counters) {
        EvictionResult evictionResult = entry.withWriteLock(e -> {
            EvictionResult result = RangeCacheRemovalQueue.evaluateEvictionPredicate(evictionPredicate, counters, e);
            if (result == EvictionResult.REMOVE) {
                e.rangeCache.removeEntry(e.key, e.value, (RangeCacheEntryWrapper)e, counters, true);
            } else if (result == EvictionResult.REQUEUE) {
                e.markRequeued();
            }
            return result;
        });
        return evictionResult;
    }

    private static EvictionResult evaluateEvictionPredicate(EvictionPredicate evictionPredicate, RangeCacheRemovalCounters counters, RangeCacheEntryWrapper entry) {
        if (entry.key == null) {
            return EvictionResult.MISSING;
        }
        return evictionPredicate.test(entry, counters);
    }

    private Pair<Integer, Long> handleRemovalResult(RangeCacheRemovalCounters counters) {
        Pair result = Pair.of((Object)counters.removedEntries, (Object)counters.removedSize);
        counters.recycle();
        return result;
    }

    @VisibleForTesting
    public synchronized Pair<Integer, Long> getNonEvictableSize() {
        MutableInt entries = new MutableInt(0);
        MutableLong bytesSize = new MutableLong(0L);
        this.forEachEntry(entryWrapper -> {
            if (entryWrapper.value.getReadCountHandler() == null || entryWrapper.value.hasExpectedReads()) {
                entries.increment();
                bytesSize.add(entryWrapper.size);
            }
        });
        return Pair.of((Object)entries.getValue(), (Object)bytesSize.getValue());
    }

    @VisibleForTesting
    public synchronized void forEachEntry(Consumer<RangeCacheEntryWrapper> consumer) {
        RangeCacheEntryWrapper entry;
        RangeCacheEntryWrapper firstEntry = null;
        while (!Thread.currentThread().isInterrupted() && (entry = (RangeCacheEntryWrapper)this.removalQueue.peek()) != null && entry != firstEntry) {
            boolean exists = entry.withWriteLock(wrapper -> {
                if (wrapper.key != null && wrapper.value != null) {
                    consumer.accept((RangeCacheEntryWrapper)wrapper);
                    return true;
                }
                return false;
            });
            this.removalQueue.poll();
            if (!exists) continue;
            this.removalQueue.add((Object)entry);
            if (firstEntry != null) continue;
            firstEntry = entry;
        }
    }

    public synchronized void setMaxRequeueCountWhenHasExpectedReads(int maxRequeueCountWhenHasExpectedReads) {
        this.maxRequeueCountWhenHasExpectedReads = maxRequeueCountWhenHasExpectedReads;
    }

    public synchronized void setExtendTTLOfRecentlyAccessed(boolean extendTTLOfRecentlyAccessed) {
        this.extendTTLOfRecentlyAccessed = extendTTLOfRecentlyAccessed;
    }

    public boolean isEmpty() {
        return this.removalQueue.isEmpty();
    }

    static interface EvictionPredicate {
        public EvictionResult test(RangeCacheEntryWrapper var1, RangeCacheRemovalCounters var2);
    }

    static enum EvictionResult {
        REMOVE,
        REQUEUE,
        STOP,
        MISSING;


        boolean shouldStop() {
            return this == STOP;
        }

        boolean shouldRemovePeekedEntry() {
            return this.shouldRequeue() || this.shouldDrop();
        }

        boolean shouldRequeue() {
            return this == REQUEUE;
        }

        boolean shouldDrop() {
            return this == REMOVE || this == MISSING;
        }
    }
}

