/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.pulsar.broker.service.Topic;
import org.apache.pulsar.common.naming.TopicName;
import org.jspecify.annotations.Nullable;

public class TopicLoadingContext {
    private static final String EXAMPLE_LATENCY_OUTPUTS = "1234 ms (queued: 567)";
    private final long startNs = System.nanoTime();
    private final TopicName topicName;
    private final boolean createIfMissing;
    private final CompletableFuture<Optional<Topic>> topicFuture;
    private @Nullable Map<String, String> properties;
    private long polledFromQueueNs = -1L;

    public void polledFromQueue() {
        this.polledFromQueueNs = System.nanoTime();
    }

    public long latencyMs(long nowInNanos) {
        return TimeUnit.NANOSECONDS.toMillis(nowInNanos - this.startNs);
    }

    public String latencyString(long nowInNanos) {
        StringBuilder builder = new StringBuilder(EXAMPLE_LATENCY_OUTPUTS.length());
        builder.append(this.latencyMs(nowInNanos));
        builder.append(" ms");
        if (this.polledFromQueueNs >= 0L) {
            builder.append(" (queued: ").append(this.latencyMs(this.polledFromQueueNs)).append(")");
        }
        return builder.toString();
    }

    @Generated
    public TopicLoadingContext(TopicName topicName, boolean createIfMissing, CompletableFuture<Optional<Topic>> topicFuture) {
        this.topicName = topicName;
        this.createIfMissing = createIfMissing;
        this.topicFuture = topicFuture;
    }

    @Generated
    public TopicName getTopicName() {
        return this.topicName;
    }

    @Generated
    public boolean isCreateIfMissing() {
        return this.createIfMissing;
    }

    @Generated
    public CompletableFuture<Optional<Topic>> getTopicFuture() {
        return this.topicFuture;
    }

    @Generated
    public @Nullable Map<String, String> getProperties() {
        return this.properties;
    }

    @Generated
    public void setProperties(@Nullable Map<String, String> properties) {
        this.properties = properties;
    }
}

