/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.broker.service.EntryAndMetadata;
import org.apache.pulsar.common.api.proto.MessageMetadata;

public class SharedConsumerAssignor {
    @VisibleForTesting
    private final Map<String, Consumer> uuidToConsumer = new ConcurrentHashMap<String, Consumer>();
    private final Map<Consumer, Integer> consumerToPermits = new IdentityHashMap<Consumer, Integer>();
    private final Supplier<Consumer> defaultSelector;
    private final java.util.function.Consumer<EntryAndMetadata> unassignedMessageProcessor;

    public Map<Consumer, List<EntryAndMetadata>> assign(List<EntryAndMetadata> entryAndMetadataList, int numConsumers) {
        int index;
        assert (numConsumers >= 0);
        this.consumerToPermits.clear();
        IdentityHashMap<Consumer, List<EntryAndMetadata>> consumerToEntries = new IdentityHashMap<Consumer, List<EntryAndMetadata>>();
        Consumer consumer = this.getConsumer(numConsumers);
        if (consumer == null) {
            entryAndMetadataList.forEach(EntryAndMetadata::release);
            return consumerToEntries;
        }
        int availablePermits = this.consumerToPermits.computeIfAbsent(consumer, Consumer::getAvailablePermits);
        for (index = 0; index < entryAndMetadataList.size(); ++index) {
            EntryAndMetadata entryAndMetadata = entryAndMetadataList.get(index);
            MessageMetadata metadata = entryAndMetadata.getMetadata();
            if (availablePermits <= 0) {
                this.consumerToPermits.put(consumer, availablePermits);
                consumer = this.getConsumer(numConsumers);
                if (consumer == null) break;
                availablePermits = consumer.getAvailablePermits();
            }
            if (!(metadata != null && metadata.hasUuid() && metadata.hasChunkId() && metadata.hasNumChunksFromMsg())) {
                consumerToEntries.computeIfAbsent(consumer, __ -> new ArrayList()).add(entryAndMetadata);
            } else {
                Consumer consumerForUuid = this.getConsumerForUuid(metadata, consumer, availablePermits);
                if (consumerForUuid == null) {
                    this.unassignedMessageProcessor.accept(entryAndMetadata);
                    continue;
                }
                consumerToEntries.computeIfAbsent(consumerForUuid, __ -> new ArrayList()).add(entryAndMetadata);
            }
            --availablePermits;
        }
        while (index < entryAndMetadataList.size()) {
            this.unassignedMessageProcessor.accept(entryAndMetadataList.get(index));
            ++index;
        }
        return consumerToEntries;
    }

    private Consumer getConsumer(int numConsumers) {
        for (int i = 0; i < numConsumers; ++i) {
            Consumer consumer = this.defaultSelector.get();
            if (consumer == null) {
                return null;
            }
            int permits = this.consumerToPermits.computeIfAbsent(consumer, Consumer::getAvailablePermits);
            if (permits <= 0) continue;
            return consumer;
        }
        return null;
    }

    private Consumer getConsumerForUuid(MessageMetadata metadata, Consumer defaultConsumer, int currentAvailablePermits) {
        int permits;
        String uuid = metadata.getUuid();
        Consumer consumer = this.uuidToConsumer.get(uuid);
        if (consumer == null) {
            if (metadata.getChunkId() != 0) {
                return null;
            }
            consumer = defaultConsumer;
            this.uuidToConsumer.put(uuid, consumer);
        }
        if ((permits = this.consumerToPermits.computeIfAbsent(consumer, Consumer::getAvailablePermits).intValue()) <= 0) {
            return null;
        }
        if (metadata.getChunkId() == metadata.getNumChunksFromMsg() - 1) {
            this.uuidToConsumer.remove(uuid);
        }
        this.consumerToPermits.put(consumer, currentAvailablePermits - 1);
        return consumer;
    }

    @Generated
    public SharedConsumerAssignor(Supplier<Consumer> defaultSelector, java.util.function.Consumer<EntryAndMetadata> unassignedMessageProcessor) {
        this.defaultSelector = defaultSelector;
        this.unassignedMessageProcessor = unassignedMessageProcessor;
    }

    @Generated
    public Map<String, Consumer> getUuidToConsumer() {
        return this.uuidToConsumer;
    }
}

