/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf.workload.mt.handlers;

import com.lmax.disruptor.LifecycleAware;
import java.util.ArrayList;
import java.util.List;
import org.apache.phoenix.pherf.configuration.Scenario;
import org.apache.phoenix.pherf.result.ResultValue;
import org.apache.phoenix.pherf.util.PhoenixUtil;
import org.apache.phoenix.pherf.workload.mt.generators.BaseLoadEventGenerator;
import org.apache.phoenix.pherf.workload.mt.generators.TenantOperationInfo;
import org.apache.phoenix.pherf.workload.mt.handlers.PherfWorkHandler;
import org.apache.phoenix.pherf.workload.mt.operations.OperationStats;
import org.apache.phoenix.pherf.workload.mt.operations.TenantOperationFactory;
import org.apache.phoenix.thirdparty.com.google.common.base.Function;
import org.apache.phoenix.thirdparty.com.google.common.base.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantOperationWorkHandler
implements PherfWorkHandler<BaseLoadEventGenerator.TenantOperationEvent>,
LifecycleAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(TenantOperationWorkHandler.class);
    private final String handlerId;
    private final TenantOperationFactory operationFactory;

    public TenantOperationWorkHandler(TenantOperationFactory operationFactory, String handlerId) {
        this.handlerId = handlerId;
        this.operationFactory = operationFactory;
    }

    @Override
    public void onEvent(BaseLoadEventGenerator.TenantOperationEvent event) throws Exception {
        TenantOperationInfo input = event.getTenantOperationInfo();
        Supplier<Function<TenantOperationInfo, OperationStats>> opSupplier = this.operationFactory.getOperationSupplier(input);
        OperationStats stats = opSupplier.get().apply(input);
        stats.setHandlerId(this.handlerId);
        this.operationFactory.getPhoenixUtil();
        LOGGER.info(PhoenixUtil.getGSON().toJson(stats));
    }

    @Override
    public void onStart() {
        Scenario scenario = this.operationFactory.getScenario();
        LOGGER.info(String.format("TenantOperationWorkHandler started for %s:%s", scenario.getName(), scenario.getTableName()));
    }

    @Override
    public void onShutdown() {
        Scenario scenario = this.operationFactory.getScenario();
        LOGGER.info(String.format("TenantOperationWorkHandler stopped for %s:%s", scenario.getName(), scenario.getTableName()));
    }

    @Override
    public List<ResultValue<OperationStats>> getResults() {
        return new ArrayList<ResultValue<OperationStats>>();
    }
}

